% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_parameters_by_path}
\alias{ssm_get_parameters_by_path}
\title{Retrieve information about one or more parameters in a specific
hierarchy}
\usage{
ssm_get_parameters_by_path(Path, Recursive, ParameterFilters,
  WithDecryption, MaxResults, NextToken)
}
\arguments{
\item{Path}{[required] The hierarchy for the parameter. Hierarchies start with a forward slash
(/) and end with the parameter name. A parameter name hierarchy can have
a maximum of 15 levels. Here is an example of a hierarchy:
\verb{/Finance/Prod/IAD/WinServ2016/license33}}

\item{Recursive}{Retrieve all parameters within a hierarchy.

If a user has access to a path, then the user can access all levels of
that path. For example, if a user has permission to access path \verb{/a},
then the user can also access \verb{/a/b}. Even if a user has explicitly been
denied access in IAM for parameter \verb{/a/b}, they can still call the
GetParametersByPath API action recursively for \verb{/a} and view \verb{/a/b}.}

\item{ParameterFilters}{Filters to limit the request results.}

\item{WithDecryption}{Retrieve all parameters in a hierarchy with their value decrypted.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{A token to start the list. Use this token to get the next set of
results.}
}
\description{
Retrieve information about one or more parameters in a specific
hierarchy.
}
\details{
Request results are returned on a best-effort basis. If you specify
\code{MaxResults} in the request, the response includes information up to the
limit specified. The number of items returned, however, can be between
zero and the value of \code{MaxResults}. If the service reaches an internal
limit while processing the results, it stops the operation and returns
the matching values up to that point and a \code{NextToken}. You can specify
the \code{NextToken} in a subsequent call to get the next set of results.
}
\section{Request syntax}{
\preformatted{svc$get_parameters_by_path(
  Path = "string",
  Recursive = TRUE|FALSE,
  ParameterFilters = list(
    list(
      Key = "string",
      Option = "string",
      Values = list(
        "string"
      )
    )
  ),
  WithDecryption = TRUE|FALSE,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
