% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_event_details_for_organization}
\alias{health_describe_event_details_for_organization}
\title{Returns detailed information about one or more specified events for one
or more accounts in your organization}
\usage{
health_describe_event_details_for_organization(
  organizationEventDetailFilters, locale)
}
\arguments{
\item{organizationEventDetailFilters}{[required] A set of JSON elements that includes the \code{awsAccountId} and the
\code{eventArn}.}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}
}
\description{
Returns detailed information about one or more specified events for one
or more accounts in your organization. Information includes standard
event data (Region, service, and so on, as returned by
DescribeEventsForOrganization, a detailed event description, and
possible additional metadata that depends upon the nature of the event.
Affected entities are not included; to retrieve those, use the
DescribeAffectedEntitiesForOrganization operation.
}
\details{
Before you can call this operation, you must first enable AWS Health to
work with AWS Organizations. To do this, call the
EnableHealthServiceAccessForOrganization operation from your
organization\'s master account.
}
\section{Request syntax}{
\preformatted{svc$describe_event_details_for_organization(
  organizationEventDetailFilters = list(
    list(
      eventArn = "string",
      awsAccountId = "string"
    )
  ),
  locale = "string"
)
}
}

\keyword{internal}
