# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include autoscaling_service.R
NULL

#' Attaches one or more EC2 instances to the specified Auto Scaling group
#'
#' Attaches one or more EC2 instances to the specified Auto Scaling group.
#' 
#' When you attach instances, Amazon EC2 Auto Scaling increases the desired
#' capacity of the group by the number of instances being attached. If the
#' number of instances being attached plus the desired capacity of the
#' group exceeds the maximum size of the group, the operation fails.
#' 
#' If there is a Classic Load Balancer attached to your Auto Scaling group,
#' the instances are also registered with the load balancer. If there are
#' target groups attached to your Auto Scaling group, the instances are
#' also registered with the target groups.
#' 
#' For more information, see [Attach EC2 Instances to Your Auto Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-instance-asg.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_attach_instances(InstanceIds, AutoScalingGroupName)
#'
#' @param InstanceIds The IDs of the instances. You can specify up to 20 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @section Request syntax:
#' ```
#' svc$attach_instances(
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   AutoScalingGroupName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example attaches the specified instance to the specified Auto
#' # Scaling group.
#' svc$attach_instances(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   InstanceIds = list(
#'     "i-93633f9b"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_attach_instances
autoscaling_attach_instances <- function(InstanceIds = NULL, AutoScalingGroupName) {
  op <- new_operation(
    name = "AttachInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$attach_instances_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$attach_instances_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$attach_instances <- autoscaling_attach_instances

#' Attaches one or more target groups to the specified Auto Scaling group
#'
#' Attaches one or more target groups to the specified Auto Scaling group.
#' 
#' To describe the target groups for an Auto Scaling group, call the
#' DescribeLoadBalancerTargetGroups API. To detach the target group from
#' the Auto Scaling group, call the DetachLoadBalancerTargetGroups API.
#' 
#' With Application Load Balancers and Network Load Balancers, instances
#' are registered as targets with a target group. With Classic Load
#' Balancers, instances are registered with the load balancer. For more
#' information, see [Attaching a Load Balancer to Your Auto Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-load-balancer-asg.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_attach_load_balancer_target_groups(AutoScalingGroupName,
#'   TargetGroupARNs)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TargetGroupARNs &#91;required&#93; The Amazon Resource Names (ARN) of the target groups. You can specify up
#' to 10 target groups.
#'
#' @section Request syntax:
#' ```
#' svc$attach_load_balancer_target_groups(
#'   AutoScalingGroupName = "string",
#'   TargetGroupARNs = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example attaches the specified target group to the specified Auto
#' # Scaling group.
#' svc$attach_load_balancer_target_groups(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   TargetGroupARNs = list(
#'     "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8..."
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_attach_load_balancer_target_groups
autoscaling_attach_load_balancer_target_groups <- function(AutoScalingGroupName, TargetGroupARNs) {
  op <- new_operation(
    name = "AttachLoadBalancerTargetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$attach_load_balancer_target_groups_input(AutoScalingGroupName = AutoScalingGroupName, TargetGroupARNs = TargetGroupARNs)
  output <- .autoscaling$attach_load_balancer_target_groups_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$attach_load_balancer_target_groups <- autoscaling_attach_load_balancer_target_groups

#' To attach an Application Load Balancer or a Network Load Balancer, use
#' the AttachLoadBalancerTargetGroups API operation instead
#'
#' To attach an Application Load Balancer or a Network Load Balancer, use
#' the AttachLoadBalancerTargetGroups API operation instead.
#' 
#' Attaches one or more Classic Load Balancers to the specified Auto
#' Scaling group. Amazon EC2 Auto Scaling registers the running instances
#' with these Classic Load Balancers.
#' 
#' To describe the load balancers for an Auto Scaling group, call the
#' DescribeLoadBalancers API. To detach the load balancer from the Auto
#' Scaling group, call the DetachLoadBalancers API.
#' 
#' For more information, see [Attaching a Load Balancer to Your Auto
#' Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-load-balancer-asg.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_attach_load_balancers(AutoScalingGroupName,
#'   LoadBalancerNames)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LoadBalancerNames &#91;required&#93; The names of the load balancers. You can specify up to 10 load
#' balancers.
#'
#' @section Request syntax:
#' ```
#' svc$attach_load_balancers(
#'   AutoScalingGroupName = "string",
#'   LoadBalancerNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example attaches the specified load balancer to the specified Auto
#' # Scaling group.
#' svc$attach_load_balancers(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   LoadBalancerNames = list(
#'     "my-load-balancer"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_attach_load_balancers
autoscaling_attach_load_balancers <- function(AutoScalingGroupName, LoadBalancerNames) {
  op <- new_operation(
    name = "AttachLoadBalancers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$attach_load_balancers_input(AutoScalingGroupName = AutoScalingGroupName, LoadBalancerNames = LoadBalancerNames)
  output <- .autoscaling$attach_load_balancers_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$attach_load_balancers <- autoscaling_attach_load_balancers

#' Deletes one or more scheduled actions for the specified Auto Scaling
#' group
#'
#' Deletes one or more scheduled actions for the specified Auto Scaling
#' group.
#'
#' @usage
#' autoscaling_batch_delete_scheduled_action(AutoScalingGroupName,
#'   ScheduledActionNames)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScheduledActionNames &#91;required&#93; The names of the scheduled actions to delete. The maximum number allowed
#' is 50.
#'
#' @section Request syntax:
#' ```
#' svc$batch_delete_scheduled_action(
#'   AutoScalingGroupName = "string",
#'   ScheduledActionNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname autoscaling_batch_delete_scheduled_action
autoscaling_batch_delete_scheduled_action <- function(AutoScalingGroupName, ScheduledActionNames) {
  op <- new_operation(
    name = "BatchDeleteScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$batch_delete_scheduled_action_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledActionNames = ScheduledActionNames)
  output <- .autoscaling$batch_delete_scheduled_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$batch_delete_scheduled_action <- autoscaling_batch_delete_scheduled_action

#' Creates or updates one or more scheduled scaling actions for an Auto
#' Scaling group
#'
#' Creates or updates one or more scheduled scaling actions for an Auto
#' Scaling group. If you leave a parameter unspecified when updating a
#' scheduled scaling action, the corresponding value remains unchanged.
#'
#' @usage
#' autoscaling_batch_put_scheduled_update_group_action(
#'   AutoScalingGroupName, ScheduledUpdateGroupActions)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScheduledUpdateGroupActions &#91;required&#93; One or more scheduled actions. The maximum number allowed is 50.
#'
#' @section Request syntax:
#' ```
#' svc$batch_put_scheduled_update_group_action(
#'   AutoScalingGroupName = "string",
#'   ScheduledUpdateGroupActions = list(
#'     list(
#'       ScheduledActionName = "string",
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EndTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Recurrence = "string",
#'       MinSize = 123,
#'       MaxSize = 123,
#'       DesiredCapacity = 123
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname autoscaling_batch_put_scheduled_update_group_action
autoscaling_batch_put_scheduled_update_group_action <- function(AutoScalingGroupName, ScheduledUpdateGroupActions) {
  op <- new_operation(
    name = "BatchPutScheduledUpdateGroupAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$batch_put_scheduled_update_group_action_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledUpdateGroupActions = ScheduledUpdateGroupActions)
  output <- .autoscaling$batch_put_scheduled_update_group_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$batch_put_scheduled_update_group_action <- autoscaling_batch_put_scheduled_update_group_action

#' Cancels an instance refresh operation in progress
#'
#' Cancels an instance refresh operation in progress. Cancellation does not
#' roll back any replacements that have already been completed, but it
#' prevents new replacements from being started.
#' 
#' For more information, see [Replacing Auto Scaling Instances Based on an
#' Instance
#' Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html).
#'
#' @usage
#' autoscaling_cancel_instance_refresh(AutoScalingGroupName)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_instance_refresh(
#'   AutoScalingGroupName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example cancels an instance refresh operation in progress.
#' svc$cancel_instance_refresh(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_cancel_instance_refresh
autoscaling_cancel_instance_refresh <- function(AutoScalingGroupName) {
  op <- new_operation(
    name = "CancelInstanceRefresh",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$cancel_instance_refresh_input(AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$cancel_instance_refresh_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$cancel_instance_refresh <- autoscaling_cancel_instance_refresh

#' Completes the lifecycle action for the specified token or instance with
#' the specified result
#'
#' Completes the lifecycle action for the specified token or instance with
#' the specified result.
#' 
#' This step is a part of the procedure for adding a lifecycle hook to an
#' Auto Scaling group:
#' 
#' 1.  (Optional) Create a Lambda function and a rule that allows
#'     CloudWatch Events to invoke your Lambda function when Amazon EC2
#'     Auto Scaling launches or terminates instances.
#' 
#' 2.  (Optional) Create a notification target and an IAM role. The target
#'     can be either an Amazon SQS queue or an Amazon SNS topic. The role
#'     allows Amazon EC2 Auto Scaling to publish lifecycle notifications to
#'     the target.
#' 
#' 3.  Create the lifecycle hook. Specify whether the hook is used when the
#'     instances launch or terminate.
#' 
#' 4.  If you need more time, record the lifecycle action heartbeat to keep
#'     the instance in a pending state.
#' 
#' 5.  **If you finish before the timeout period ends, complete the
#'     lifecycle action.**
#' 
#' For more information, see [Amazon EC2 Auto Scaling Lifecycle
#' Hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_complete_lifecycle_action(LifecycleHookName,
#'   AutoScalingGroupName, LifecycleActionToken, LifecycleActionResult,
#'   InstanceId)
#'
#' @param LifecycleHookName &#91;required&#93; The name of the lifecycle hook.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LifecycleActionToken A universally unique identifier (UUID) that identifies a specific
#' lifecycle action associated with an instance. Amazon EC2 Auto Scaling
#' sends this token to the notification target you specified when you
#' created the lifecycle hook.
#' @param LifecycleActionResult &#91;required&#93; The action for the group to take. This parameter can be either
#' `CONTINUE` or `ABANDON`.
#' @param InstanceId The ID of the instance.
#'
#' @section Request syntax:
#' ```
#' svc$complete_lifecycle_action(
#'   LifecycleHookName = "string",
#'   AutoScalingGroupName = "string",
#'   LifecycleActionToken = "string",
#'   LifecycleActionResult = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example notifies Auto Scaling that the specified lifecycle action
#' # is complete so that it can finish launching or terminating the instance.
#' svc$complete_lifecycle_action(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   LifecycleActionResult = "CONTINUE",
#'   LifecycleActionToken = "bcd2f1b8-9a78-44d3-8a7a-4dd07d7cf635",
#'   LifecycleHookName = "my-lifecycle-hook"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_complete_lifecycle_action
autoscaling_complete_lifecycle_action <- function(LifecycleHookName, AutoScalingGroupName, LifecycleActionToken = NULL, LifecycleActionResult, InstanceId = NULL) {
  op <- new_operation(
    name = "CompleteLifecycleAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$complete_lifecycle_action_input(LifecycleHookName = LifecycleHookName, AutoScalingGroupName = AutoScalingGroupName, LifecycleActionToken = LifecycleActionToken, LifecycleActionResult = LifecycleActionResult, InstanceId = InstanceId)
  output <- .autoscaling$complete_lifecycle_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$complete_lifecycle_action <- autoscaling_complete_lifecycle_action

#' Creates an Auto Scaling group with the specified name and attributes
#'
#' Creates an Auto Scaling group with the specified name and attributes.
#' 
#' If you exceed your maximum limit of Auto Scaling groups, the call fails.
#' To query this limit, call the DescribeAccountLimits API. For information
#' about updating this limit, see [Amazon EC2 Auto Scaling Service
#' Quotas](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' For introductory exercises for creating an Auto Scaling group, see
#' [Getting Started with Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/GettingStartedTutorial.html)
#' and [Tutorial: Set Up a Scaled and Load-Balanced
#' Application](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-register-lbs-with-asg.html)
#' in the *Amazon EC2 Auto Scaling User Guide*. For more information, see
#' [Auto Scaling
#' Groups](https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroup.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_create_auto_scaling_group(AutoScalingGroupName,
#'   LaunchConfigurationName, LaunchTemplate, MixedInstancesPolicy,
#'   InstanceId, MinSize, MaxSize, DesiredCapacity, DefaultCooldown,
#'   AvailabilityZones, LoadBalancerNames, TargetGroupARNs, HealthCheckType,
#'   HealthCheckGracePeriod, PlacementGroup, VPCZoneIdentifier,
#'   TerminationPolicies, NewInstancesProtectedFromScaleIn,
#'   LifecycleHookSpecificationList, Tags, ServiceLinkedRoleARN,
#'   MaxInstanceLifetime)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group. This name must be unique per Region
#' per account.
#' @param LaunchConfigurationName The name of the launch configuration to use when an instance is
#' launched. To get the launch configuration name, use the
#' DescribeLaunchConfigurations API operation. New launch configurations
#' can be created with the CreateLaunchConfiguration API.
#' 
#' You must specify one of the following parameters in your request:
#' `LaunchConfigurationName`, `LaunchTemplate`, `InstanceId`, or
#' `MixedInstancesPolicy`.
#' @param LaunchTemplate Parameters used to specify the launch template and version to use when
#' an instance is launched.
#' 
#' For more information, see
#' [LaunchTemplateSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_LaunchTemplateSpecification.html)
#' in the *Amazon EC2 Auto Scaling API Reference*.
#' 
#' You can alternatively associate a launch template to the Auto Scaling
#' group by using the `MixedInstancesPolicy` parameter.
#' 
#' You must specify one of the following parameters in your request:
#' `LaunchConfigurationName`, `LaunchTemplate`, `InstanceId`, or
#' `MixedInstancesPolicy`.
#' @param MixedInstancesPolicy An embedded object that specifies a mixed instances policy. The required
#' parameters must be specified. If optional parameters are unspecified,
#' their default values are used.
#' 
#' The policy includes parameters that not only define the distribution of
#' On-Demand Instances and Spot Instances, the maximum price to pay for
#' Spot Instances, and how the Auto Scaling group allocates instance types
#' to fulfill On-Demand and Spot capacity, but also the parameters that
#' specify the instance configuration information---the launch template and
#' instance types.
#' 
#' For more information, see
#' [MixedInstancesPolicy](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_MixedInstancesPolicy.html)
#' in the *Amazon EC2 Auto Scaling API Reference* and [Auto Scaling Groups
#' with Multiple Instance Types and Purchase
#' Options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' You must specify one of the following parameters in your request:
#' `LaunchConfigurationName`, `LaunchTemplate`, `InstanceId`, or
#' `MixedInstancesPolicy`.
#' @param InstanceId The ID of the instance used to create a launch configuration for the
#' group. To get the instance ID, use the Amazon EC2
#' [DescribeInstances](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html)
#' API operation.
#' 
#' When you specify an ID of an instance, Amazon EC2 Auto Scaling creates a
#' new launch configuration and associates it with the group. This launch
#' configuration derives its attributes from the specified instance, except
#' for the block device mapping.
#' 
#' You must specify one of the following parameters in your request:
#' `LaunchConfigurationName`, `LaunchTemplate`, `InstanceId`, or
#' `MixedInstancesPolicy`.
#' @param MinSize &#91;required&#93; The minimum size of the group.
#' @param MaxSize &#91;required&#93; The maximum size of the group.
#' 
#' With a mixed instances policy that uses instance weighting, Amazon EC2
#' Auto Scaling may need to go above `MaxSize` to meet your capacity
#' requirements. In this event, Amazon EC2 Auto Scaling will never go above
#' `MaxSize` by more than your maximum instance weight (weights that define
#' how many capacity units each instance contributes to the capacity of the
#' group).
#' @param DesiredCapacity The desired capacity is the initial capacity of the Auto Scaling group
#' at the time of its creation and the capacity it attempts to maintain. It
#' can scale beyond this capacity if you configure automatic scaling.
#' 
#' This number must be greater than or equal to the minimum size of the
#' group and less than or equal to the maximum size of the group. If you do
#' not specify a desired capacity, the default is the minimum size of the
#' group.
#' @param DefaultCooldown The amount of time, in seconds, after a scaling activity completes
#' before another scaling activity can start. The default value is `300`.
#' 
#' This setting applies when using simple scaling policies, but not when
#' using other scaling policies or scheduled scaling. For more information,
#' see [Scaling Cooldowns for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param AvailabilityZones One or more Availability Zones for the group. This parameter is optional
#' if you specify one or more subnets for `VPCZoneIdentifier`.
#' 
#' Conditional: If your account supports EC2-Classic and VPC, this
#' parameter is required to launch instances into EC2-Classic.
#' @param LoadBalancerNames A list of Classic Load Balancers associated with this Auto Scaling
#' group. For Application Load Balancers and Network Load Balancers,
#' specify a list of target groups using the `TargetGroupARNs` property
#' instead.
#' 
#' For more information, see [Using a Load Balancer with an Auto Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param TargetGroupARNs The Amazon Resource Names (ARN) of the target groups to associate with
#' the Auto Scaling group. Instances are registered as targets in a target
#' group, and traffic is routed to the target group.
#' 
#' For more information, see [Using a Load Balancer with an Auto Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-load-balancer.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param HealthCheckType The service to use for the health checks. The valid values are `EC2` and
#' `ELB`. The default value is `EC2`. If you configure an Auto Scaling
#' group to use ELB health checks, it considers the instance unhealthy if
#' it fails either the EC2 status checks or the load balancer health
#' checks.
#' 
#' For more information, see [Health Checks for Auto Scaling
#' Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param HealthCheckGracePeriod The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
#' before checking the health status of an EC2 instance that has come into
#' service. During this time, any health check failures for the instance
#' are ignored. The default value is `0`.
#' 
#' For more information, see [Health Check Grace
#' Period](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Required if you are adding an `ELB` health check.
#' @param PlacementGroup The name of the placement group into which to launch your instances, if
#' any. A placement group is a logical grouping of instances within a
#' single Availability Zone. You cannot specify multiple Availability Zones
#' and a placement group. For more information, see [Placement
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param VPCZoneIdentifier A comma-separated list of subnet IDs for your virtual private cloud
#' (VPC).
#' 
#' If you specify `VPCZoneIdentifier` with `AvailabilityZones`, the subnets
#' that you specify for this parameter must reside in those Availability
#' Zones.
#' 
#' Conditional: If your account supports EC2-Classic and VPC, this
#' parameter is required to launch instances into a VPC.
#' @param TerminationPolicies One or more termination policies used to select the instance to
#' terminate. These policies are executed in the order that they are
#' listed.
#' 
#' For more information, see [Controlling Which Instances Auto Scaling
#' Terminates During Scale
#' In](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param NewInstancesProtectedFromScaleIn Indicates whether newly launched instances are protected from
#' termination by Amazon EC2 Auto Scaling when scaling in.
#' 
#' For more information about preventing instances from terminating on
#' scale in, see [Instance
#' Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param LifecycleHookSpecificationList One or more lifecycle hooks.
#' @param Tags One or more tags. You can tag your Auto Scaling group and propagate the
#' tags to the Amazon EC2 instances it launches.
#' 
#' Tags are not propagated to Amazon EBS volumes. To add tags to Amazon EBS
#' volumes, specify the tags in a launch template but use caution. If the
#' launch template specifies an instance tag with a key that is also
#' specified for the Auto Scaling group, Amazon EC2 Auto Scaling overrides
#' the value of that instance tag with the value specified by the Auto
#' Scaling group.
#' 
#' For more information, see [Tagging Auto Scaling Groups and
#' Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param ServiceLinkedRoleARN The Amazon Resource Name (ARN) of the service-linked role that the Auto
#' Scaling group uses to call other AWS services on your behalf. By
#' default, Amazon EC2 Auto Scaling uses a service-linked role named
#' AWSServiceRoleForAutoScaling, which it creates if it does not exist. For
#' more information, see [Service-Linked
#' Roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MaxInstanceLifetime The maximum amount of time, in seconds, that an instance can be in
#' service. The default is null.
#' 
#' This parameter is optional, but if you specify a value for it, you must
#' specify a value of at least 604,800 seconds (7 days). To clear a
#' previously set value, specify a new value of 0.
#' 
#' For more information, see [Replacing Auto Scaling Instances Based on
#' Maximum Instance
#' Lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Valid Range: Minimum value of 0.
#'
#' @section Request syntax:
#' ```
#' svc$create_auto_scaling_group(
#'   AutoScalingGroupName = "string",
#'   LaunchConfigurationName = "string",
#'   LaunchTemplate = list(
#'     LaunchTemplateId = "string",
#'     LaunchTemplateName = "string",
#'     Version = "string"
#'   ),
#'   MixedInstancesPolicy = list(
#'     LaunchTemplate = list(
#'       LaunchTemplateSpecification = list(
#'         LaunchTemplateId = "string",
#'         LaunchTemplateName = "string",
#'         Version = "string"
#'       ),
#'       Overrides = list(
#'         list(
#'           InstanceType = "string",
#'           WeightedCapacity = "string"
#'         )
#'       )
#'     ),
#'     InstancesDistribution = list(
#'       OnDemandAllocationStrategy = "string",
#'       OnDemandBaseCapacity = 123,
#'       OnDemandPercentageAboveBaseCapacity = 123,
#'       SpotAllocationStrategy = "string",
#'       SpotInstancePools = 123,
#'       SpotMaxPrice = "string"
#'     )
#'   ),
#'   InstanceId = "string",
#'   MinSize = 123,
#'   MaxSize = 123,
#'   DesiredCapacity = 123,
#'   DefaultCooldown = 123,
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   LoadBalancerNames = list(
#'     "string"
#'   ),
#'   TargetGroupARNs = list(
#'     "string"
#'   ),
#'   HealthCheckType = "string",
#'   HealthCheckGracePeriod = 123,
#'   PlacementGroup = "string",
#'   VPCZoneIdentifier = "string",
#'   TerminationPolicies = list(
#'     "string"
#'   ),
#'   NewInstancesProtectedFromScaleIn = TRUE|FALSE,
#'   LifecycleHookSpecificationList = list(
#'     list(
#'       LifecycleHookName = "string",
#'       LifecycleTransition = "string",
#'       NotificationMetadata = "string",
#'       HeartbeatTimeout = 123,
#'       DefaultResult = "string",
#'       NotificationTargetARN = "string",
#'       RoleARN = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       ResourceId = "string",
#'       ResourceType = "string",
#'       Key = "string",
#'       Value = "string",
#'       PropagateAtLaunch = TRUE|FALSE
#'     )
#'   ),
#'   ServiceLinkedRoleARN = "string",
#'   MaxInstanceLifetime = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates an Auto Scaling group.
#' svc$create_auto_scaling_group(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   LaunchTemplate = list(
#'     LaunchTemplateId = "lt-0a20c965061f64abc",
#'     Version = "$Latest"
#'   ),
#'   MaxInstanceLifetime = 2592000L,
#'   MaxSize = 3L,
#'   MinSize = 1L,
#'   VPCZoneIdentifier = "subnet-057fa0918fEXAMPLE"
#' )
#' 
#' # This example creates an Auto Scaling group and attaches the specified
#' # target group.
#' svc$create_auto_scaling_group(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   HealthCheckGracePeriod = 120L,
#'   HealthCheckType = "ELB",
#'   LaunchConfigurationName = "my-launch-config",
#'   MaxSize = 3L,
#'   MinSize = 1L,
#'   TargetGroupARNs = list(
#'     "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8..."
#'   ),
#'   VPCZoneIdentifier = "subnet-057fa0918fEXAMPLE, subnet-610acd08EXAMPLE"
#' )
#' 
#' # This example creates an Auto Scaling group and attaches the specified
#' # Classic Load Balancer.
#' svc$create_auto_scaling_group(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   AvailabilityZones = list(
#'     "us-west-2c"
#'   ),
#'   HealthCheckGracePeriod = 120L,
#'   HealthCheckType = "ELB",
#'   LaunchConfigurationName = "my-launch-config",
#'   LoadBalancerNames = list(
#'     "my-load-balancer"
#'   ),
#'   MaxSize = 3L,
#'   MinSize = 1L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_create_auto_scaling_group
autoscaling_create_auto_scaling_group <- function(AutoScalingGroupName, LaunchConfigurationName = NULL, LaunchTemplate = NULL, MixedInstancesPolicy = NULL, InstanceId = NULL, MinSize, MaxSize, DesiredCapacity = NULL, DefaultCooldown = NULL, AvailabilityZones = NULL, LoadBalancerNames = NULL, TargetGroupARNs = NULL, HealthCheckType = NULL, HealthCheckGracePeriod = NULL, PlacementGroup = NULL, VPCZoneIdentifier = NULL, TerminationPolicies = NULL, NewInstancesProtectedFromScaleIn = NULL, LifecycleHookSpecificationList = NULL, Tags = NULL, ServiceLinkedRoleARN = NULL, MaxInstanceLifetime = NULL) {
  op <- new_operation(
    name = "CreateAutoScalingGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$create_auto_scaling_group_input(AutoScalingGroupName = AutoScalingGroupName, LaunchConfigurationName = LaunchConfigurationName, LaunchTemplate = LaunchTemplate, MixedInstancesPolicy = MixedInstancesPolicy, InstanceId = InstanceId, MinSize = MinSize, MaxSize = MaxSize, DesiredCapacity = DesiredCapacity, DefaultCooldown = DefaultCooldown, AvailabilityZones = AvailabilityZones, LoadBalancerNames = LoadBalancerNames, TargetGroupARNs = TargetGroupARNs, HealthCheckType = HealthCheckType, HealthCheckGracePeriod = HealthCheckGracePeriod, PlacementGroup = PlacementGroup, VPCZoneIdentifier = VPCZoneIdentifier, TerminationPolicies = TerminationPolicies, NewInstancesProtectedFromScaleIn = NewInstancesProtectedFromScaleIn, LifecycleHookSpecificationList = LifecycleHookSpecificationList, Tags = Tags, ServiceLinkedRoleARN = ServiceLinkedRoleARN, MaxInstanceLifetime = MaxInstanceLifetime)
  output <- .autoscaling$create_auto_scaling_group_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$create_auto_scaling_group <- autoscaling_create_auto_scaling_group

#' Creates a launch configuration
#'
#' Creates a launch configuration.
#' 
#' If you exceed your maximum limit of launch configurations, the call
#' fails. To query this limit, call the DescribeAccountLimits API. For
#' information about updating this limit, see [Amazon EC2 Auto Scaling
#' Service
#' Quotas](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' For more information, see [Launch
#' Configurations](https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchConfiguration.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_create_launch_configuration(LaunchConfigurationName,
#'   ImageId, KeyName, SecurityGroups, ClassicLinkVPCId,
#'   ClassicLinkVPCSecurityGroups, UserData, InstanceId, InstanceType,
#'   KernelId, RamdiskId, BlockDeviceMappings, InstanceMonitoring, SpotPrice,
#'   IamInstanceProfile, EbsOptimized, AssociatePublicIpAddress,
#'   PlacementTenancy)
#'
#' @param LaunchConfigurationName &#91;required&#93; The name of the launch configuration. This name must be unique per
#' Region per account.
#' @param ImageId The ID of the Amazon Machine Image (AMI) that was assigned during
#' registration. For more information, see [Finding an
#' AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' If you do not specify `InstanceId`, you must specify `ImageId`.
#' @param KeyName The name of the key pair. For more information, see [Amazon EC2 Key
#' Pairs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param SecurityGroups A list that contains the security groups to assign to the instances in
#' the Auto Scaling group.
#' 
#' \[EC2-VPC\] Specify the security group IDs. For more information, see
#' [Security Groups for Your
#' VPC](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' \[EC2-Classic\] Specify either the security group names or the security
#' group IDs. For more information, see [Amazon EC2 Security
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param ClassicLinkVPCId The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances
#' to. For more information, see
#' [ClassicLink](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
#' in the *Amazon EC2 User Guide for Linux Instances* and [Linking
#' EC2-Classic Instances to a
#' VPC](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' This parameter can only be used if you are launching EC2-Classic
#' instances.
#' @param ClassicLinkVPCSecurityGroups The IDs of one or more security groups for the specified
#' ClassicLink-enabled VPC. For more information, see
#' [ClassicLink](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
#' in the *Amazon EC2 User Guide for Linux Instances* and [Linking
#' EC2-Classic Instances to a
#' VPC](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' If you specify the `ClassicLinkVPCId` parameter, you must specify this
#' parameter.
#' @param UserData The Base64-encoded user data to make available to the launched EC2
#' instances. For more information, see [Instance Metadata and User
#' Data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param InstanceId The ID of the instance to use to create the launch configuration. The
#' new launch configuration derives attributes from the instance, except
#' for the block device mapping.
#' 
#' To create a launch configuration with a block device mapping or override
#' any other instance attributes, specify them as part of the same request.
#' 
#' For more information, see [Create a Launch Configuration Using an EC2
#' Instance](https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-lc-with-instanceID.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' If you do not specify `InstanceId`, you must specify both `ImageId` and
#' `InstanceType`.
#' @param InstanceType Specifies the instance type of the EC2 instance.
#' 
#' For information about available instance types, see [Available Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
#' in the *Amazon EC2 User Guide for Linux Instances.*
#' 
#' If you do not specify `InstanceId`, you must specify `InstanceType`.
#' @param KernelId The ID of the kernel associated with the AMI.
#' @param RamdiskId The ID of the RAM disk to select.
#' @param BlockDeviceMappings A block device mapping, which specifies the block devices for the
#' instance. You can specify virtual devices and EBS volumes. For more
#' information, see [Block Device
#' Mapping](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param InstanceMonitoring Controls whether instances in this group are launched with detailed
#' (`true`) or basic (`false`) monitoring.
#' 
#' The default value is `true` (enabled).
#' 
#' When detailed monitoring is enabled, Amazon CloudWatch generates metrics
#' every minute and your account is charged a fee. When you disable
#' detailed monitoring, CloudWatch generates metrics every 5 minutes. For
#' more information, see [Configure Monitoring for Auto Scaling
#' Instances](https://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html#enable-as-instance-metrics)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param SpotPrice The maximum hourly price to be paid for any Spot Instance launched to
#' fulfill the request. Spot Instances are launched when the price you
#' specify exceeds the current Spot price. For more information, see
#' [Launching Spot Instances in Your Auto Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' When you change your maximum price by creating a new launch
#' configuration, running instances will continue to run as long as the
#' maximum price for those running instances is higher than the current
#' Spot price.
#' @param IamInstanceProfile The name or the Amazon Resource Name (ARN) of the instance profile
#' associated with the IAM role for the instance. The instance profile
#' contains the IAM role.
#' 
#' For more information, see [IAM Role for Applications That Run on Amazon
#' EC2
#' Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param EbsOptimized Specifies whether the launch configuration is optimized for EBS I/O
#' (`true`) or not (`false`). The optimization provides dedicated
#' throughput to Amazon EBS and an optimized configuration stack to provide
#' optimal I/O performance. This optimization is not available with all
#' instance types. Additional fees are incurred when you enable EBS
#' optimization for an instance type that is not EBS-optimized by default.
#' For more information, see [Amazon EBS-Optimized
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' The default value is `false`.
#' @param AssociatePublicIpAddress For Auto Scaling groups that are running in a virtual private cloud
#' (VPC), specifies whether to assign a public IP address to the group\'s
#' instances. If you specify `true`, each instance in the Auto Scaling
#' group receives a unique public IP address. For more information, see
#' [Launching Auto Scaling Instances in a
#' VPC](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' If you specify this parameter, you must specify at least one subnet for
#' `VPCZoneIdentifier` when you create your group.
#' 
#' If the instance is launched into a default subnet, the default is to
#' assign a public IP address, unless you disabled the option to assign a
#' public IP address on the subnet. If the instance is launched into a
#' nondefault subnet, the default is not to assign a public IP address,
#' unless you enabled the option to assign a public IP address on the
#' subnet.
#' @param PlacementTenancy The tenancy of the instance. An instance with `dedicated` tenancy runs
#' on isolated, single-tenant hardware and can only be launched into a VPC.
#' 
#' To launch dedicated instances into a shared tenancy VPC (a VPC with the
#' instance placement tenancy attribute set to `default`), you must set the
#' value of this parameter to `dedicated`.
#' 
#' If you specify `PlacementTenancy`, you must specify at least one subnet
#' for `VPCZoneIdentifier` when you create your group.
#' 
#' For more information, see [Instance Placement
#' Tenancy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-vpc-tenancy)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Valid Values: `default` \\| `dedicated`
#'
#' @section Request syntax:
#' ```
#' svc$create_launch_configuration(
#'   LaunchConfigurationName = "string",
#'   ImageId = "string",
#'   KeyName = "string",
#'   SecurityGroups = list(
#'     "string"
#'   ),
#'   ClassicLinkVPCId = "string",
#'   ClassicLinkVPCSecurityGroups = list(
#'     "string"
#'   ),
#'   UserData = "string",
#'   InstanceId = "string",
#'   InstanceType = "string",
#'   KernelId = "string",
#'   RamdiskId = "string",
#'   BlockDeviceMappings = list(
#'     list(
#'       VirtualName = "string",
#'       DeviceName = "string",
#'       Ebs = list(
#'         SnapshotId = "string",
#'         VolumeSize = 123,
#'         VolumeType = "string",
#'         DeleteOnTermination = TRUE|FALSE,
#'         Iops = 123,
#'         Encrypted = TRUE|FALSE
#'       ),
#'       NoDevice = TRUE|FALSE
#'     )
#'   ),
#'   InstanceMonitoring = list(
#'     Enabled = TRUE|FALSE
#'   ),
#'   SpotPrice = "string",
#'   IamInstanceProfile = "string",
#'   EbsOptimized = TRUE|FALSE,
#'   AssociatePublicIpAddress = TRUE|FALSE,
#'   PlacementTenancy = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a launch configuration.
#' svc$create_launch_configuration(
#'   IamInstanceProfile = "my-iam-role",
#'   ImageId = "ami-12345678",
#'   InstanceType = "m3.medium",
#'   LaunchConfigurationName = "my-launch-config",
#'   SecurityGroups = list(
#'     "sg-eb2af88e"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_create_launch_configuration
autoscaling_create_launch_configuration <- function(LaunchConfigurationName, ImageId = NULL, KeyName = NULL, SecurityGroups = NULL, ClassicLinkVPCId = NULL, ClassicLinkVPCSecurityGroups = NULL, UserData = NULL, InstanceId = NULL, InstanceType = NULL, KernelId = NULL, RamdiskId = NULL, BlockDeviceMappings = NULL, InstanceMonitoring = NULL, SpotPrice = NULL, IamInstanceProfile = NULL, EbsOptimized = NULL, AssociatePublicIpAddress = NULL, PlacementTenancy = NULL) {
  op <- new_operation(
    name = "CreateLaunchConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$create_launch_configuration_input(LaunchConfigurationName = LaunchConfigurationName, ImageId = ImageId, KeyName = KeyName, SecurityGroups = SecurityGroups, ClassicLinkVPCId = ClassicLinkVPCId, ClassicLinkVPCSecurityGroups = ClassicLinkVPCSecurityGroups, UserData = UserData, InstanceId = InstanceId, InstanceType = InstanceType, KernelId = KernelId, RamdiskId = RamdiskId, BlockDeviceMappings = BlockDeviceMappings, InstanceMonitoring = InstanceMonitoring, SpotPrice = SpotPrice, IamInstanceProfile = IamInstanceProfile, EbsOptimized = EbsOptimized, AssociatePublicIpAddress = AssociatePublicIpAddress, PlacementTenancy = PlacementTenancy)
  output <- .autoscaling$create_launch_configuration_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$create_launch_configuration <- autoscaling_create_launch_configuration

#' Creates or updates tags for the specified Auto Scaling group
#'
#' Creates or updates tags for the specified Auto Scaling group.
#' 
#' When you specify a tag with a key that already exists, the operation
#' overwrites the previous tag definition, and you do not get an error
#' message.
#' 
#' For more information, see [Tagging Auto Scaling Groups and
#' Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_create_or_update_tags(Tags)
#'
#' @param Tags &#91;required&#93; One or more tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_or_update_tags(
#'   Tags = list(
#'     list(
#'       ResourceId = "string",
#'       ResourceType = "string",
#'       Key = "string",
#'       Value = "string",
#'       PropagateAtLaunch = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example adds two tags to the specified Auto Scaling group.
#' svc$create_or_update_tags(
#'   Tags = list(
#'     list(
#'       Key = "Role",
#'       PropagateAtLaunch = TRUE,
#'       ResourceId = "my-auto-scaling-group",
#'       ResourceType = "auto-scaling-group",
#'       Value = "WebServer"
#'     ),
#'     list(
#'       Key = "Dept",
#'       PropagateAtLaunch = TRUE,
#'       ResourceId = "my-auto-scaling-group",
#'       ResourceType = "auto-scaling-group",
#'       Value = "Research"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_create_or_update_tags
autoscaling_create_or_update_tags <- function(Tags) {
  op <- new_operation(
    name = "CreateOrUpdateTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$create_or_update_tags_input(Tags = Tags)
  output <- .autoscaling$create_or_update_tags_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$create_or_update_tags <- autoscaling_create_or_update_tags

#' Deletes the specified Auto Scaling group
#'
#' Deletes the specified Auto Scaling group.
#' 
#' If the group has instances or scaling activities in progress, you must
#' specify the option to force the deletion in order for it to succeed.
#' 
#' If the group has policies, deleting the group deletes the policies, the
#' underlying alarm actions, and any alarm that no longer has an associated
#' action.
#' 
#' To remove instances from the Auto Scaling group before deleting it, call
#' the DetachInstances API with the list of instances and the option to
#' decrement the desired capacity. This ensures that Amazon EC2 Auto
#' Scaling does not launch replacement instances.
#' 
#' To terminate all instances before deleting the Auto Scaling group, call
#' the UpdateAutoScalingGroup API and set the minimum size and desired
#' capacity of the Auto Scaling group to zero.
#'
#' @usage
#' autoscaling_delete_auto_scaling_group(AutoScalingGroupName, ForceDelete)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ForceDelete Specifies that the group is to be deleted along with all instances
#' associated with the group, without waiting for all instances to be
#' terminated. This parameter also deletes any lifecycle actions associated
#' with the group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_auto_scaling_group(
#'   AutoScalingGroupName = "string",
#'   ForceDelete = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified Auto Scaling group.
#' svc$delete_auto_scaling_group(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' 
#' # This example deletes the specified Auto Scaling group and all its
#' # instances.
#' svc$delete_auto_scaling_group(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   ForceDelete = TRUE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_auto_scaling_group
autoscaling_delete_auto_scaling_group <- function(AutoScalingGroupName, ForceDelete = NULL) {
  op <- new_operation(
    name = "DeleteAutoScalingGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$delete_auto_scaling_group_input(AutoScalingGroupName = AutoScalingGroupName, ForceDelete = ForceDelete)
  output <- .autoscaling$delete_auto_scaling_group_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_auto_scaling_group <- autoscaling_delete_auto_scaling_group

#' Deletes the specified launch configuration
#'
#' Deletes the specified launch configuration.
#' 
#' The launch configuration must not be attached to an Auto Scaling group.
#' When this call completes, the launch configuration is no longer
#' available for use.
#'
#' @usage
#' autoscaling_delete_launch_configuration(LaunchConfigurationName)
#'
#' @param LaunchConfigurationName &#91;required&#93; The name of the launch configuration.
#'
#' @section Request syntax:
#' ```
#' svc$delete_launch_configuration(
#'   LaunchConfigurationName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified launch configuration.
#' svc$delete_launch_configuration(
#'   LaunchConfigurationName = "my-launch-config"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_launch_configuration
autoscaling_delete_launch_configuration <- function(LaunchConfigurationName) {
  op <- new_operation(
    name = "DeleteLaunchConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$delete_launch_configuration_input(LaunchConfigurationName = LaunchConfigurationName)
  output <- .autoscaling$delete_launch_configuration_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_launch_configuration <- autoscaling_delete_launch_configuration

#' Deletes the specified lifecycle hook
#'
#' Deletes the specified lifecycle hook.
#' 
#' If there are any outstanding lifecycle actions, they are completed first
#' (`ABANDON` for launching instances, `CONTINUE` for terminating
#' instances).
#'
#' @usage
#' autoscaling_delete_lifecycle_hook(LifecycleHookName,
#'   AutoScalingGroupName)
#'
#' @param LifecycleHookName &#91;required&#93; The name of the lifecycle hook.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_lifecycle_hook(
#'   LifecycleHookName = "string",
#'   AutoScalingGroupName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified lifecycle hook.
#' svc$delete_lifecycle_hook(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   LifecycleHookName = "my-lifecycle-hook"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_lifecycle_hook
autoscaling_delete_lifecycle_hook <- function(LifecycleHookName, AutoScalingGroupName) {
  op <- new_operation(
    name = "DeleteLifecycleHook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$delete_lifecycle_hook_input(LifecycleHookName = LifecycleHookName, AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$delete_lifecycle_hook_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_lifecycle_hook <- autoscaling_delete_lifecycle_hook

#' Deletes the specified notification
#'
#' Deletes the specified notification.
#'
#' @usage
#' autoscaling_delete_notification_configuration(AutoScalingGroupName,
#'   TopicARN)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TopicARN &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
#' (Amazon SNS) topic.
#'
#' @section Request syntax:
#' ```
#' svc$delete_notification_configuration(
#'   AutoScalingGroupName = "string",
#'   TopicARN = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified notification from the specified Auto
#' # Scaling group.
#' svc$delete_notification_configuration(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   TopicARN = "arn:aws:sns:us-west-2:123456789012:my-sns-topic"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_notification_configuration
autoscaling_delete_notification_configuration <- function(AutoScalingGroupName, TopicARN) {
  op <- new_operation(
    name = "DeleteNotificationConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$delete_notification_configuration_input(AutoScalingGroupName = AutoScalingGroupName, TopicARN = TopicARN)
  output <- .autoscaling$delete_notification_configuration_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_notification_configuration <- autoscaling_delete_notification_configuration

#' Deletes the specified scaling policy
#'
#' Deletes the specified scaling policy.
#' 
#' Deleting either a step scaling policy or a simple scaling policy deletes
#' the underlying alarm action, but does not delete the alarm, even if it
#' no longer has an associated action.
#' 
#' For more information, see [Deleting a Scaling
#' Policy](https://docs.aws.amazon.com/autoscaling/ec2/userguide/deleting-scaling-policy.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_delete_policy(AutoScalingGroupName, PolicyName)
#'
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param PolicyName &#91;required&#93; The name or Amazon Resource Name (ARN) of the policy.
#'
#' @section Request syntax:
#' ```
#' svc$delete_policy(
#'   AutoScalingGroupName = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified Auto Scaling policy.
#' svc$delete_policy(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   PolicyName = "my-step-scale-out-policy"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_policy
autoscaling_delete_policy <- function(AutoScalingGroupName = NULL, PolicyName) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$delete_policy_input(AutoScalingGroupName = AutoScalingGroupName, PolicyName = PolicyName)
  output <- .autoscaling$delete_policy_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_policy <- autoscaling_delete_policy

#' Deletes the specified scheduled action
#'
#' Deletes the specified scheduled action.
#'
#' @usage
#' autoscaling_delete_scheduled_action(AutoScalingGroupName,
#'   ScheduledActionName)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScheduledActionName &#91;required&#93; The name of the action to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_scheduled_action(
#'   AutoScalingGroupName = "string",
#'   ScheduledActionName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified scheduled action from the specified
#' # Auto Scaling group.
#' svc$delete_scheduled_action(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   ScheduledActionName = "my-scheduled-action"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_scheduled_action
autoscaling_delete_scheduled_action <- function(AutoScalingGroupName, ScheduledActionName) {
  op <- new_operation(
    name = "DeleteScheduledAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$delete_scheduled_action_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledActionName = ScheduledActionName)
  output <- .autoscaling$delete_scheduled_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_scheduled_action <- autoscaling_delete_scheduled_action

#' Deletes the specified tags
#'
#' Deletes the specified tags.
#'
#' @usage
#' autoscaling_delete_tags(Tags)
#'
#' @param Tags &#91;required&#93; One or more tags.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   Tags = list(
#'     list(
#'       ResourceId = "string",
#'       ResourceType = "string",
#'       Key = "string",
#'       Value = "string",
#'       PropagateAtLaunch = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example deletes the specified tag from the specified Auto Scaling
#' # group.
#' svc$delete_tags(
#'   Tags = list(
#'     list(
#'       Key = "Dept",
#'       ResourceId = "my-auto-scaling-group",
#'       ResourceType = "auto-scaling-group",
#'       Value = "Research"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_delete_tags
autoscaling_delete_tags <- function(Tags) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$delete_tags_input(Tags = Tags)
  output <- .autoscaling$delete_tags_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$delete_tags <- autoscaling_delete_tags

#' Describes the current Amazon EC2 Auto Scaling resource quotas for your
#' AWS account
#'
#' Describes the current Amazon EC2 Auto Scaling resource quotas for your
#' AWS account.
#' 
#' For information about requesting an increase, see [Amazon EC2 Auto
#' Scaling Service
#' Quotas](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-account-limits.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_describe_account_limits()
#'

#'

#'
#' @examples
#' \dontrun{
#' # This example describes the Auto Scaling limits for your AWS account.
#' svc$describe_account_limits()
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_account_limits
autoscaling_describe_account_limits <- function() {
  op <- new_operation(
    name = "DescribeAccountLimits",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_account_limits_input()
  output <- .autoscaling$describe_account_limits_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_account_limits <- autoscaling_describe_account_limits

#' Describes the available adjustment types for Amazon EC2 Auto Scaling
#' scaling policies
#'
#' Describes the available adjustment types for Amazon EC2 Auto Scaling
#' scaling policies. These settings apply to step scaling policies and
#' simple scaling policies; they do not apply to target tracking scaling
#' policies.
#' 
#' The following adjustment types are supported:
#' 
#' -   ChangeInCapacity
#' 
#' -   ExactCapacity
#' 
#' -   PercentChangeInCapacity
#'
#' @usage
#' autoscaling_describe_adjustment_types()
#'

#'

#'
#' @examples
#' \dontrun{
#' # This example describes the available adjustment types.
#' svc$describe_adjustment_types()
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_adjustment_types
autoscaling_describe_adjustment_types <- function() {
  op <- new_operation(
    name = "DescribeAdjustmentTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_adjustment_types_input()
  output <- .autoscaling$describe_adjustment_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_adjustment_types <- autoscaling_describe_adjustment_types

#' Describes one or more Auto Scaling groups
#'
#' Describes one or more Auto Scaling groups.
#'
#' @usage
#' autoscaling_describe_auto_scaling_groups(AutoScalingGroupNames,
#'   NextToken, MaxRecords)
#'
#' @param AutoScalingGroupNames The names of the Auto Scaling groups. Each name can be a maximum of 1600
#' characters. By default, you can only specify up to 50 names. You can
#' optionally increase this limit using the `MaxRecords` parameter.
#' 
#' If you omit this parameter, all Auto Scaling groups are described.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_auto_scaling_groups(
#'   AutoScalingGroupNames = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified Auto Scaling group.
#' svc$describe_auto_scaling_groups(
#'   AutoScalingGroupNames = list(
#'     "my-auto-scaling-group"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_auto_scaling_groups
autoscaling_describe_auto_scaling_groups <- function(AutoScalingGroupNames = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeAutoScalingGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_auto_scaling_groups_input(AutoScalingGroupNames = AutoScalingGroupNames, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_auto_scaling_groups_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_auto_scaling_groups <- autoscaling_describe_auto_scaling_groups

#' Describes one or more Auto Scaling instances
#'
#' Describes one or more Auto Scaling instances.
#'
#' @usage
#' autoscaling_describe_auto_scaling_instances(InstanceIds, MaxRecords,
#'   NextToken)
#'
#' @param InstanceIds The IDs of the instances. You can specify up to `MaxRecords` IDs. If you
#' omit this parameter, all Auto Scaling instances are described. If you
#' specify an ID that does not exist, it is ignored with no error.
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `50`.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_auto_scaling_instances(
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified Auto Scaling instance.
#' svc$describe_auto_scaling_instances(
#'   InstanceIds = list(
#'     "i-4ba0837f"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_auto_scaling_instances
autoscaling_describe_auto_scaling_instances <- function(InstanceIds = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAutoScalingInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_auto_scaling_instances_input(InstanceIds = InstanceIds, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .autoscaling$describe_auto_scaling_instances_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_auto_scaling_instances <- autoscaling_describe_auto_scaling_instances

#' Describes the notification types that are supported by Amazon EC2 Auto
#' Scaling
#'
#' Describes the notification types that are supported by Amazon EC2 Auto
#' Scaling.
#'
#' @usage
#' autoscaling_describe_auto_scaling_notification_types()
#'

#'

#'
#' @examples
#' \dontrun{
#' # This example describes the available notification types.
#' svc$describe_auto_scaling_notification_types()
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_auto_scaling_notification_types
autoscaling_describe_auto_scaling_notification_types <- function() {
  op <- new_operation(
    name = "DescribeAutoScalingNotificationTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_auto_scaling_notification_types_input()
  output <- .autoscaling$describe_auto_scaling_notification_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_auto_scaling_notification_types <- autoscaling_describe_auto_scaling_notification_types

#' Describes one or more instance refreshes
#'
#' Describes one or more instance refreshes.
#' 
#' You can determine the status of a request by looking at the `Status`
#' parameter. The following are the possible statuses:
#' 
#' -   `Pending` - The request was created, but the operation has not
#'     started.
#' 
#' -   `InProgress` - The operation is in progress.
#' 
#' -   `Successful` - The operation completed successfully.
#' 
#' -   `Failed` - The operation failed to complete. You can troubleshoot
#'     using the status reason and the scaling activities.
#' 
#' -   `Cancelling` - An ongoing operation is being cancelled. Cancellation
#'     does not roll back any replacements that have already been
#'     completed, but it prevents new replacements from being started.
#' 
#' -   `Cancelled` - The operation is cancelled.
#' 
#' For more information, see [Replacing Auto Scaling Instances Based on an
#' Instance
#' Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html).
#'
#' @usage
#' autoscaling_describe_instance_refreshes(AutoScalingGroupName,
#'   InstanceRefreshIds, NextToken, MaxRecords)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param InstanceRefreshIds One or more instance refresh IDs.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_refreshes(
#'   AutoScalingGroupName = "string",
#'   InstanceRefreshIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the instance refreshes for the specified Auto
#' # Scaling group.
#' svc$describe_instance_refreshes(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_instance_refreshes
autoscaling_describe_instance_refreshes <- function(AutoScalingGroupName, InstanceRefreshIds = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeInstanceRefreshes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_instance_refreshes_input(AutoScalingGroupName = AutoScalingGroupName, InstanceRefreshIds = InstanceRefreshIds, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_instance_refreshes_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_instance_refreshes <- autoscaling_describe_instance_refreshes

#' Describes one or more launch configurations
#'
#' Describes one or more launch configurations.
#'
#' @usage
#' autoscaling_describe_launch_configurations(LaunchConfigurationNames,
#'   NextToken, MaxRecords)
#'
#' @param LaunchConfigurationNames The launch configuration names. If you omit this parameter, all launch
#' configurations are described.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_launch_configurations(
#'   LaunchConfigurationNames = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the specified launch configuration.
#' svc$describe_launch_configurations(
#'   LaunchConfigurationNames = list(
#'     "my-launch-config"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_launch_configurations
autoscaling_describe_launch_configurations <- function(LaunchConfigurationNames = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeLaunchConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_launch_configurations_input(LaunchConfigurationNames = LaunchConfigurationNames, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_launch_configurations_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_launch_configurations <- autoscaling_describe_launch_configurations

#' Describes the available types of lifecycle hooks
#'
#' Describes the available types of lifecycle hooks.
#' 
#' The following hook types are supported:
#' 
#' -   autoscaling:EC2\\_INSTANCE\\_LAUNCHING
#' 
#' -   autoscaling:EC2\\_INSTANCE\\_TERMINATING
#'
#' @usage
#' autoscaling_describe_lifecycle_hook_types()
#'

#'

#'
#' @examples
#' \dontrun{
#' # This example describes the available lifecycle hook types.
#' svc$describe_lifecycle_hook_types()
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_lifecycle_hook_types
autoscaling_describe_lifecycle_hook_types <- function() {
  op <- new_operation(
    name = "DescribeLifecycleHookTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_lifecycle_hook_types_input()
  output <- .autoscaling$describe_lifecycle_hook_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_lifecycle_hook_types <- autoscaling_describe_lifecycle_hook_types

#' Describes the lifecycle hooks for the specified Auto Scaling group
#'
#' Describes the lifecycle hooks for the specified Auto Scaling group.
#'
#' @usage
#' autoscaling_describe_lifecycle_hooks(AutoScalingGroupName,
#'   LifecycleHookNames)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LifecycleHookNames The names of one or more lifecycle hooks. If you omit this parameter,
#' all lifecycle hooks are described.
#'
#' @section Request syntax:
#' ```
#' svc$describe_lifecycle_hooks(
#'   AutoScalingGroupName = "string",
#'   LifecycleHookNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the lifecycle hooks for the specified Auto
#' # Scaling group.
#' svc$describe_lifecycle_hooks(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_lifecycle_hooks
autoscaling_describe_lifecycle_hooks <- function(AutoScalingGroupName, LifecycleHookNames = NULL) {
  op <- new_operation(
    name = "DescribeLifecycleHooks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_lifecycle_hooks_input(AutoScalingGroupName = AutoScalingGroupName, LifecycleHookNames = LifecycleHookNames)
  output <- .autoscaling$describe_lifecycle_hooks_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_lifecycle_hooks <- autoscaling_describe_lifecycle_hooks

#' Describes the target groups for the specified Auto Scaling group
#'
#' Describes the target groups for the specified Auto Scaling group.
#'
#' @usage
#' autoscaling_describe_load_balancer_target_groups(AutoScalingGroupName,
#'   NextToken, MaxRecords)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `100` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_load_balancer_target_groups(
#'   AutoScalingGroupName = "string",
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the target groups attached to the specified Auto
#' # Scaling group.
#' svc$describe_load_balancer_target_groups(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_load_balancer_target_groups
autoscaling_describe_load_balancer_target_groups <- function(AutoScalingGroupName, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancerTargetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_load_balancer_target_groups_input(AutoScalingGroupName = AutoScalingGroupName, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_load_balancer_target_groups_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_load_balancer_target_groups <- autoscaling_describe_load_balancer_target_groups

#' Describes the load balancers for the specified Auto Scaling group
#'
#' Describes the load balancers for the specified Auto Scaling group.
#' 
#' This operation describes only Classic Load Balancers. If you have
#' Application Load Balancers or Network Load Balancers, use the
#' DescribeLoadBalancerTargetGroups API instead.
#'
#' @usage
#' autoscaling_describe_load_balancers(AutoScalingGroupName, NextToken,
#'   MaxRecords)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `100` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_load_balancers(
#'   AutoScalingGroupName = "string",
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the load balancers attached to the specified Auto
#' # Scaling group.
#' svc$describe_load_balancers(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_load_balancers
autoscaling_describe_load_balancers <- function(AutoScalingGroupName, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeLoadBalancers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_load_balancers_input(AutoScalingGroupName = AutoScalingGroupName, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_load_balancers_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_load_balancers <- autoscaling_describe_load_balancers

#' Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling
#'
#' Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling.
#' 
#' The `GroupStandbyInstances` metric is not returned by default. You must
#' explicitly request this metric when calling the EnableMetricsCollection
#' API.
#'
#' @usage
#' autoscaling_describe_metric_collection_types()
#'

#'

#'
#' @examples
#' \dontrun{
#' # This example describes the available metric collection types.
#' svc$describe_metric_collection_types()
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_metric_collection_types
autoscaling_describe_metric_collection_types <- function() {
  op <- new_operation(
    name = "DescribeMetricCollectionTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_metric_collection_types_input()
  output <- .autoscaling$describe_metric_collection_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_metric_collection_types <- autoscaling_describe_metric_collection_types

#' Describes the notification actions associated with the specified Auto
#' Scaling group
#'
#' Describes the notification actions associated with the specified Auto
#' Scaling group.
#'
#' @usage
#' autoscaling_describe_notification_configurations(AutoScalingGroupNames,
#'   NextToken, MaxRecords)
#'
#' @param AutoScalingGroupNames The name of the Auto Scaling group.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_notification_configurations(
#'   AutoScalingGroupNames = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the notification configurations for the specified
#' # Auto Scaling group.
#' svc$describe_notification_configurations(
#'   AutoScalingGroupNames = list(
#'     "my-auto-scaling-group"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_notification_configurations
autoscaling_describe_notification_configurations <- function(AutoScalingGroupNames = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeNotificationConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_notification_configurations_input(AutoScalingGroupNames = AutoScalingGroupNames, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_notification_configurations_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_notification_configurations <- autoscaling_describe_notification_configurations

#' Describes the policies for the specified Auto Scaling group
#'
#' Describes the policies for the specified Auto Scaling group.
#'
#' @usage
#' autoscaling_describe_policies(AutoScalingGroupName, PolicyNames,
#'   PolicyTypes, NextToken, MaxRecords)
#'
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param PolicyNames The names of one or more policies. If you omit this parameter, all
#' policies are described. If a group name is provided, the results are
#' limited to that group. This list is limited to 50 items. If you specify
#' an unknown policy name, it is ignored with no error.
#' @param PolicyTypes One or more policy types. The valid values are `SimpleScaling`,
#' `StepScaling`, and `TargetTrackingScaling`.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to be returned with each call. The default
#' value is `50` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_policies(
#'   AutoScalingGroupName = "string",
#'   PolicyNames = list(
#'     "string"
#'   ),
#'   PolicyTypes = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the policies for the specified Auto Scaling
#' # group.
#' svc$describe_policies(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_policies
autoscaling_describe_policies <- function(AutoScalingGroupName = NULL, PolicyNames = NULL, PolicyTypes = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribePolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_policies_input(AutoScalingGroupName = AutoScalingGroupName, PolicyNames = PolicyNames, PolicyTypes = PolicyTypes, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_policies_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_policies <- autoscaling_describe_policies

#' Describes one or more scaling activities for the specified Auto Scaling
#' group
#'
#' Describes one or more scaling activities for the specified Auto Scaling
#' group.
#'
#' @usage
#' autoscaling_describe_scaling_activities(ActivityIds,
#'   AutoScalingGroupName, MaxRecords, NextToken)
#'
#' @param ActivityIds The activity IDs of the desired scaling activities. You can specify up
#' to 50 IDs. If you omit this parameter, all activities for the past six
#' weeks are described. If unknown activities are requested, they are
#' ignored with no error. If you specify an Auto Scaling group, the results
#' are limited to that group.
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `100` and the maximum value is `100`.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_scaling_activities(
#'   ActivityIds = list(
#'     "string"
#'   ),
#'   AutoScalingGroupName = "string",
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the scaling activities for the specified Auto
#' # Scaling group.
#' svc$describe_scaling_activities(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_scaling_activities
autoscaling_describe_scaling_activities <- function(ActivityIds = NULL, AutoScalingGroupName = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeScalingActivities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_scaling_activities_input(ActivityIds = ActivityIds, AutoScalingGroupName = AutoScalingGroupName, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .autoscaling$describe_scaling_activities_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_scaling_activities <- autoscaling_describe_scaling_activities

#' Describes the scaling process types for use with the ResumeProcesses and
#' SuspendProcesses APIs
#'
#' Describes the scaling process types for use with the ResumeProcesses and
#' SuspendProcesses APIs.
#'
#' @usage
#' autoscaling_describe_scaling_process_types()
#'

#'

#'
#' @examples
#' \dontrun{
#' # This example describes the Auto Scaling process types.
#' svc$describe_scaling_process_types()
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_scaling_process_types
autoscaling_describe_scaling_process_types <- function() {
  op <- new_operation(
    name = "DescribeScalingProcessTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_scaling_process_types_input()
  output <- .autoscaling$describe_scaling_process_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_scaling_process_types <- autoscaling_describe_scaling_process_types

#' Describes the actions scheduled for your Auto Scaling group that haven't
#' run or that have not reached their end time
#'
#' Describes the actions scheduled for your Auto Scaling group that
#' haven\'t run or that have not reached their end time. To describe the
#' actions that have already run, call the DescribeScalingActivities API.
#'
#' @usage
#' autoscaling_describe_scheduled_actions(AutoScalingGroupName,
#'   ScheduledActionNames, StartTime, EndTime, NextToken, MaxRecords)
#'
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param ScheduledActionNames The names of one or more scheduled actions. You can specify up to 50
#' actions. If you omit this parameter, all scheduled actions are
#' described. If you specify an unknown scheduled action, it is ignored
#' with no error.
#' @param StartTime The earliest scheduled start time to return. If scheduled action names
#' are provided, this parameter is ignored.
#' @param EndTime The latest scheduled start time to return. If scheduled action names are
#' provided, this parameter is ignored.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scheduled_actions(
#'   AutoScalingGroupName = "string",
#'   ScheduledActionNames = list(
#'     "string"
#'   ),
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the scheduled actions for the specified Auto
#' # Scaling group.
#' svc$describe_scheduled_actions(
#'   AutoScalingGroupName = "my-auto-scaling-group"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_scheduled_actions
autoscaling_describe_scheduled_actions <- function(AutoScalingGroupName = NULL, ScheduledActionNames = NULL, StartTime = NULL, EndTime = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeScheduledActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_scheduled_actions_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledActionNames = ScheduledActionNames, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_scheduled_actions_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_scheduled_actions <- autoscaling_describe_scheduled_actions

#' Describes the specified tags
#'
#' Describes the specified tags.
#' 
#' You can use filters to limit the results. For example, you can query for
#' the tags for a specific Auto Scaling group. You can specify multiple
#' values for a filter. A tag must match at least one of the specified
#' values for it to be included in the results.
#' 
#' You can also specify multiple filters. The result includes information
#' for a particular tag only if it matches all the filters. If there\'s no
#' match, no special message is returned.
#' 
#' For more information, see [Tagging Auto Scaling Groups and
#' Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_describe_tags(Filters, NextToken, MaxRecords)
#'
#' @param Filters One or more filters to scope the tags to return. The maximum number of
#' filters per filter type (for example, `auto-scaling-group`) is 1000.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxRecords The maximum number of items to return with this call. The default value
#' is `50` and the maximum value is `100`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tags(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxRecords = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example describes the tags for the specified Auto Scaling group.
#' svc$describe_tags(
#'   Filters = list(
#'     list(
#'       Name = "auto-scaling-group",
#'       Values = list(
#'         "my-auto-scaling-group"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_tags
autoscaling_describe_tags <- function(Filters = NULL, NextToken = NULL, MaxRecords = NULL) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_tags_input(Filters = Filters, NextToken = NextToken, MaxRecords = MaxRecords)
  output <- .autoscaling$describe_tags_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_tags <- autoscaling_describe_tags

#' Describes the termination policies supported by Amazon EC2 Auto Scaling
#'
#' Describes the termination policies supported by Amazon EC2 Auto Scaling.
#' 
#' For more information, see [Controlling Which Auto Scaling Instances
#' Terminate During Scale
#' In](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_describe_termination_policy_types()
#'

#'

#'
#' @examples
#' \dontrun{
#' # This example describes the available termination policy types.
#' svc$describe_termination_policy_types()
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_describe_termination_policy_types
autoscaling_describe_termination_policy_types <- function() {
  op <- new_operation(
    name = "DescribeTerminationPolicyTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$describe_termination_policy_types_input()
  output <- .autoscaling$describe_termination_policy_types_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$describe_termination_policy_types <- autoscaling_describe_termination_policy_types

#' Removes one or more instances from the specified Auto Scaling group
#'
#' Removes one or more instances from the specified Auto Scaling group.
#' 
#' After the instances are detached, you can manage them independent of the
#' Auto Scaling group.
#' 
#' If you do not specify the option to decrement the desired capacity,
#' Amazon EC2 Auto Scaling launches instances to replace the ones that are
#' detached.
#' 
#' If there is a Classic Load Balancer attached to the Auto Scaling group,
#' the instances are deregistered from the load balancer. If there are
#' target groups attached to the Auto Scaling group, the instances are
#' deregistered from the target groups.
#' 
#' For more information, see [Detach EC2 Instances from Your Auto Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/detach-instance-asg.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_detach_instances(InstanceIds, AutoScalingGroupName,
#'   ShouldDecrementDesiredCapacity)
#'
#' @param InstanceIds The IDs of the instances. You can specify up to 20 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ShouldDecrementDesiredCapacity &#91;required&#93; Indicates whether the Auto Scaling group decrements the desired capacity
#' value by the number of instances detached.
#'
#' @section Request syntax:
#' ```
#' svc$detach_instances(
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   AutoScalingGroupName = "string",
#'   ShouldDecrementDesiredCapacity = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example detaches the specified instance from the specified Auto
#' # Scaling group.
#' svc$detach_instances(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   InstanceIds = list(
#'     "i-93633f9b"
#'   ),
#'   ShouldDecrementDesiredCapacity = TRUE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_detach_instances
autoscaling_detach_instances <- function(InstanceIds = NULL, AutoScalingGroupName, ShouldDecrementDesiredCapacity) {
  op <- new_operation(
    name = "DetachInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$detach_instances_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName, ShouldDecrementDesiredCapacity = ShouldDecrementDesiredCapacity)
  output <- .autoscaling$detach_instances_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$detach_instances <- autoscaling_detach_instances

#' Detaches one or more target groups from the specified Auto Scaling group
#'
#' Detaches one or more target groups from the specified Auto Scaling
#' group.
#'
#' @usage
#' autoscaling_detach_load_balancer_target_groups(AutoScalingGroupName,
#'   TargetGroupARNs)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TargetGroupARNs &#91;required&#93; The Amazon Resource Names (ARN) of the target groups. You can specify up
#' to 10 target groups.
#'
#' @section Request syntax:
#' ```
#' svc$detach_load_balancer_target_groups(
#'   AutoScalingGroupName = "string",
#'   TargetGroupARNs = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example detaches the specified target group from the specified Auto
#' # Scaling group
#' svc$detach_load_balancer_target_groups(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   TargetGroupARNs = list(
#'     "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8..."
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_detach_load_balancer_target_groups
autoscaling_detach_load_balancer_target_groups <- function(AutoScalingGroupName, TargetGroupARNs) {
  op <- new_operation(
    name = "DetachLoadBalancerTargetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$detach_load_balancer_target_groups_input(AutoScalingGroupName = AutoScalingGroupName, TargetGroupARNs = TargetGroupARNs)
  output <- .autoscaling$detach_load_balancer_target_groups_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$detach_load_balancer_target_groups <- autoscaling_detach_load_balancer_target_groups

#' Detaches one or more Classic Load Balancers from the specified Auto
#' Scaling group
#'
#' Detaches one or more Classic Load Balancers from the specified Auto
#' Scaling group.
#' 
#' This operation detaches only Classic Load Balancers. If you have
#' Application Load Balancers or Network Load Balancers, use the
#' DetachLoadBalancerTargetGroups API instead.
#' 
#' When you detach a load balancer, it enters the `Removing` state while
#' deregistering the instances in the group. When all instances are
#' deregistered, then you can no longer describe the load balancer using
#' the DescribeLoadBalancers API call. The instances remain running.
#'
#' @usage
#' autoscaling_detach_load_balancers(AutoScalingGroupName,
#'   LoadBalancerNames)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LoadBalancerNames &#91;required&#93; The names of the load balancers. You can specify up to 10 load
#' balancers.
#'
#' @section Request syntax:
#' ```
#' svc$detach_load_balancers(
#'   AutoScalingGroupName = "string",
#'   LoadBalancerNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example detaches the specified load balancer from the specified
#' # Auto Scaling group.
#' svc$detach_load_balancers(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   LoadBalancerNames = list(
#'     "my-load-balancer"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_detach_load_balancers
autoscaling_detach_load_balancers <- function(AutoScalingGroupName, LoadBalancerNames) {
  op <- new_operation(
    name = "DetachLoadBalancers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$detach_load_balancers_input(AutoScalingGroupName = AutoScalingGroupName, LoadBalancerNames = LoadBalancerNames)
  output <- .autoscaling$detach_load_balancers_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$detach_load_balancers <- autoscaling_detach_load_balancers

#' Disables group metrics for the specified Auto Scaling group
#'
#' Disables group metrics for the specified Auto Scaling group.
#'
#' @usage
#' autoscaling_disable_metrics_collection(AutoScalingGroupName, Metrics)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param Metrics Specifies one or more of the following metrics:
#' 
#' -   `GroupMinSize`
#' 
#' -   `GroupMaxSize`
#' 
#' -   `GroupDesiredCapacity`
#' 
#' -   `GroupInServiceInstances`
#' 
#' -   `GroupPendingInstances`
#' 
#' -   `GroupStandbyInstances`
#' 
#' -   `GroupTerminatingInstances`
#' 
#' -   `GroupTotalInstances`
#' 
#' -   `GroupInServiceCapacity`
#' 
#' -   `GroupPendingCapacity`
#' 
#' -   `GroupStandbyCapacity`
#' 
#' -   `GroupTerminatingCapacity`
#' 
#' -   `GroupTotalCapacity`
#' 
#' If you omit this parameter, all metrics are disabled.
#'
#' @section Request syntax:
#' ```
#' svc$disable_metrics_collection(
#'   AutoScalingGroupName = "string",
#'   Metrics = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example disables collecting data for the GroupDesiredCapacity
#' # metric for the specified Auto Scaling group.
#' svc$disable_metrics_collection(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   Metrics = list(
#'     "GroupDesiredCapacity"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_disable_metrics_collection
autoscaling_disable_metrics_collection <- function(AutoScalingGroupName, Metrics = NULL) {
  op <- new_operation(
    name = "DisableMetricsCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$disable_metrics_collection_input(AutoScalingGroupName = AutoScalingGroupName, Metrics = Metrics)
  output <- .autoscaling$disable_metrics_collection_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$disable_metrics_collection <- autoscaling_disable_metrics_collection

#' Enables group metrics for the specified Auto Scaling group
#'
#' Enables group metrics for the specified Auto Scaling group. For more
#' information, see [Monitoring Your Auto Scaling Groups and
#' Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-monitoring.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_enable_metrics_collection(AutoScalingGroupName, Metrics,
#'   Granularity)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param Metrics Specifies which group-level metrics to start collecting. You can specify
#' one or more of the following metrics:
#' 
#' -   `GroupMinSize`
#' 
#' -   `GroupMaxSize`
#' 
#' -   `GroupDesiredCapacity`
#' 
#' -   `GroupInServiceInstances`
#' 
#' -   `GroupPendingInstances`
#' 
#' -   `GroupStandbyInstances`
#' 
#' -   `GroupTerminatingInstances`
#' 
#' -   `GroupTotalInstances`
#' 
#' The instance weighting feature supports the following additional
#' metrics:
#' 
#' -   `GroupInServiceCapacity`
#' 
#' -   `GroupPendingCapacity`
#' 
#' -   `GroupStandbyCapacity`
#' 
#' -   `GroupTerminatingCapacity`
#' 
#' -   `GroupTotalCapacity`
#' 
#' If you omit this parameter, all metrics are enabled.
#' @param Granularity &#91;required&#93; The granularity to associate with the metrics to collect. The only valid
#' value is `1Minute`.
#'
#' @section Request syntax:
#' ```
#' svc$enable_metrics_collection(
#'   AutoScalingGroupName = "string",
#'   Metrics = list(
#'     "string"
#'   ),
#'   Granularity = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example enables data collection for the specified Auto Scaling
#' # group.
#' svc$enable_metrics_collection(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   Granularity = "1Minute"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_enable_metrics_collection
autoscaling_enable_metrics_collection <- function(AutoScalingGroupName, Metrics = NULL, Granularity) {
  op <- new_operation(
    name = "EnableMetricsCollection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$enable_metrics_collection_input(AutoScalingGroupName = AutoScalingGroupName, Metrics = Metrics, Granularity = Granularity)
  output <- .autoscaling$enable_metrics_collection_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$enable_metrics_collection <- autoscaling_enable_metrics_collection

#' Moves the specified instances into the standby state
#'
#' Moves the specified instances into the standby state.
#' 
#' If you choose to decrement the desired capacity of the Auto Scaling
#' group, the instances can enter standby as long as the desired capacity
#' of the Auto Scaling group after the instances are placed into standby is
#' equal to or greater than the minimum capacity of the group.
#' 
#' If you choose not to decrement the desired capacity of the Auto Scaling
#' group, the Auto Scaling group launches new instances to replace the
#' instances on standby.
#' 
#' For more information, see [Temporarily Removing Instances from Your Auto
#' Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_enter_standby(InstanceIds, AutoScalingGroupName,
#'   ShouldDecrementDesiredCapacity)
#'
#' @param InstanceIds The IDs of the instances. You can specify up to 20 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ShouldDecrementDesiredCapacity &#91;required&#93; Indicates whether to decrement the desired capacity of the Auto Scaling
#' group by the number of instances moved to `Standby` mode.
#'
#' @section Request syntax:
#' ```
#' svc$enter_standby(
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   AutoScalingGroupName = "string",
#'   ShouldDecrementDesiredCapacity = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example puts the specified instance into standby mode.
#' svc$enter_standby(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   InstanceIds = list(
#'     "i-93633f9b"
#'   ),
#'   ShouldDecrementDesiredCapacity = TRUE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_enter_standby
autoscaling_enter_standby <- function(InstanceIds = NULL, AutoScalingGroupName, ShouldDecrementDesiredCapacity) {
  op <- new_operation(
    name = "EnterStandby",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$enter_standby_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName, ShouldDecrementDesiredCapacity = ShouldDecrementDesiredCapacity)
  output <- .autoscaling$enter_standby_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$enter_standby <- autoscaling_enter_standby

#' Executes the specified policy
#'
#' Executes the specified policy. This can be useful for testing the design
#' of your scaling policy.
#'
#' @usage
#' autoscaling_execute_policy(AutoScalingGroupName, PolicyName,
#'   HonorCooldown, MetricValue, BreachThreshold)
#'
#' @param AutoScalingGroupName The name of the Auto Scaling group.
#' @param PolicyName &#91;required&#93; The name or ARN of the policy.
#' @param HonorCooldown Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period
#' to complete before executing the policy.
#' 
#' Valid only if the policy type is `SimpleScaling`. For more information,
#' see [Scaling Cooldowns for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MetricValue The metric value to compare to `BreachThreshold`. This enables you to
#' execute a policy of type `StepScaling` and determine which step
#' adjustment to use. For example, if the breach threshold is 50 and you
#' want to use a step adjustment with a lower bound of 0 and an upper bound
#' of 10, you can set the metric value to 59.
#' 
#' If you specify a metric value that doesn\'t correspond to a step
#' adjustment for the policy, the call returns an error.
#' 
#' Required if the policy type is `StepScaling` and not supported
#' otherwise.
#' @param BreachThreshold The breach threshold for the alarm.
#' 
#' Required if the policy type is `StepScaling` and not supported
#' otherwise.
#'
#' @section Request syntax:
#' ```
#' svc$execute_policy(
#'   AutoScalingGroupName = "string",
#'   PolicyName = "string",
#'   HonorCooldown = TRUE|FALSE,
#'   MetricValue = 123.0,
#'   BreachThreshold = 123.0
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example executes the specified policy.
#' svc$execute_policy(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   BreachThreshold = 50,
#'   MetricValue = 59,
#'   PolicyName = "my-step-scale-out-policy"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_execute_policy
autoscaling_execute_policy <- function(AutoScalingGroupName = NULL, PolicyName, HonorCooldown = NULL, MetricValue = NULL, BreachThreshold = NULL) {
  op <- new_operation(
    name = "ExecutePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$execute_policy_input(AutoScalingGroupName = AutoScalingGroupName, PolicyName = PolicyName, HonorCooldown = HonorCooldown, MetricValue = MetricValue, BreachThreshold = BreachThreshold)
  output <- .autoscaling$execute_policy_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$execute_policy <- autoscaling_execute_policy

#' Moves the specified instances out of the standby state
#'
#' Moves the specified instances out of the standby state.
#' 
#' After you put the instances back in service, the desired capacity is
#' incremented.
#' 
#' For more information, see [Temporarily Removing Instances from Your Auto
#' Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enter-exit-standby.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_exit_standby(InstanceIds, AutoScalingGroupName)
#'
#' @param InstanceIds The IDs of the instances. You can specify up to 20 instances.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#'
#' @section Request syntax:
#' ```
#' svc$exit_standby(
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   AutoScalingGroupName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example moves the specified instance out of standby mode.
#' svc$exit_standby(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   InstanceIds = list(
#'     "i-93633f9b"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_exit_standby
autoscaling_exit_standby <- function(InstanceIds = NULL, AutoScalingGroupName) {
  op <- new_operation(
    name = "ExitStandby",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$exit_standby_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName)
  output <- .autoscaling$exit_standby_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$exit_standby <- autoscaling_exit_standby

#' Creates or updates a lifecycle hook for the specified Auto Scaling group
#'
#' Creates or updates a lifecycle hook for the specified Auto Scaling
#' group.
#' 
#' A lifecycle hook tells Amazon EC2 Auto Scaling to perform an action on
#' an instance when the instance launches (before it is put into service)
#' or as the instance terminates (before it is fully terminated).
#' 
#' This step is a part of the procedure for adding a lifecycle hook to an
#' Auto Scaling group:
#' 
#' 1.  (Optional) Create a Lambda function and a rule that allows
#'     CloudWatch Events to invoke your Lambda function when Amazon EC2
#'     Auto Scaling launches or terminates instances.
#' 
#' 2.  (Optional) Create a notification target and an IAM role. The target
#'     can be either an Amazon SQS queue or an Amazon SNS topic. The role
#'     allows Amazon EC2 Auto Scaling to publish lifecycle notifications to
#'     the target.
#' 
#' 3.  **Create the lifecycle hook. Specify whether the hook is used when
#'     the instances launch or terminate.**
#' 
#' 4.  If you need more time, record the lifecycle action heartbeat to keep
#'     the instance in a pending state using the
#'     RecordLifecycleActionHeartbeat API call.
#' 
#' 5.  If you finish before the timeout period ends, complete the lifecycle
#'     action using the CompleteLifecycleAction API call.
#' 
#' For more information, see [Amazon EC2 Auto Scaling Lifecycle
#' Hooks](https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' If you exceed your maximum limit of lifecycle hooks, which by default is
#' 50 per Auto Scaling group, the call fails.
#' 
#' You can view the lifecycle hooks for an Auto Scaling group using the
#' DescribeLifecycleHooks API call. If you are no longer using a lifecycle
#' hook, you can delete it by calling the DeleteLifecycleHook API.
#'
#' @usage
#' autoscaling_put_lifecycle_hook(LifecycleHookName, AutoScalingGroupName,
#'   LifecycleTransition, RoleARN, NotificationTargetARN,
#'   NotificationMetadata, HeartbeatTimeout, DefaultResult)
#'
#' @param LifecycleHookName &#91;required&#93; The name of the lifecycle hook.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LifecycleTransition The instance state to which you want to attach the lifecycle hook. The
#' valid values are:
#' 
#' -   autoscaling:EC2\\_INSTANCE\\_LAUNCHING
#' 
#' -   autoscaling:EC2\\_INSTANCE\\_TERMINATING
#' 
#' Required for new lifecycle hooks, but optional when updating existing
#' hooks.
#' @param RoleARN The ARN of the IAM role that allows the Auto Scaling group to publish to
#' the specified notification target, for example, an Amazon SNS topic or
#' an Amazon SQS queue.
#' 
#' Required for new lifecycle hooks, but optional when updating existing
#' hooks.
#' @param NotificationTargetARN The ARN of the notification target that Amazon EC2 Auto Scaling uses to
#' notify you when an instance is in the transition state for the lifecycle
#' hook. This target can be either an SQS queue or an SNS topic.
#' 
#' If you specify an empty string, this overrides the current ARN.
#' 
#' This operation uses the JSON format when sending notifications to an
#' Amazon SQS queue, and an email key-value pair format when sending
#' notifications to an Amazon SNS topic.
#' 
#' When you specify a notification target, Amazon EC2 Auto Scaling sends it
#' a test message. Test messages contain the following additional key-value
#' pair: `"Event": "autoscaling:TEST_NOTIFICATION"`.
#' @param NotificationMetadata Additional information that you want to include any time Amazon EC2 Auto
#' Scaling sends a message to the notification target.
#' @param HeartbeatTimeout The maximum time, in seconds, that can elapse before the lifecycle hook
#' times out. The range is from `30` to `7200` seconds. The default value
#' is `3600` seconds (1 hour).
#' 
#' If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the
#' action that you specified in the `DefaultResult` parameter. You can
#' prevent the lifecycle hook from timing out by calling the
#' RecordLifecycleActionHeartbeat API.
#' @param DefaultResult Defines the action the Auto Scaling group should take when the lifecycle
#' hook timeout elapses or if an unexpected failure occurs. This parameter
#' can be either `CONTINUE` or `ABANDON`. The default value is `ABANDON`.
#'
#' @section Request syntax:
#' ```
#' svc$put_lifecycle_hook(
#'   LifecycleHookName = "string",
#'   AutoScalingGroupName = "string",
#'   LifecycleTransition = "string",
#'   RoleARN = "string",
#'   NotificationTargetARN = "string",
#'   NotificationMetadata = "string",
#'   HeartbeatTimeout = 123,
#'   DefaultResult = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example creates a lifecycle hook.
#' svc$put_lifecycle_hook(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   LifecycleHookName = "my-lifecycle-hook",
#'   LifecycleTransition = "autoscaling:EC2_INSTANCE_LAUNCHING",
#'   NotificationTargetARN = "arn:aws:sns:us-west-2:123456789012:my-sns-topic --role-arn",
#'   RoleARN = "arn:aws:iam::123456789012:role/my-auto-scaling-role"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_lifecycle_hook
autoscaling_put_lifecycle_hook <- function(LifecycleHookName, AutoScalingGroupName, LifecycleTransition = NULL, RoleARN = NULL, NotificationTargetARN = NULL, NotificationMetadata = NULL, HeartbeatTimeout = NULL, DefaultResult = NULL) {
  op <- new_operation(
    name = "PutLifecycleHook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$put_lifecycle_hook_input(LifecycleHookName = LifecycleHookName, AutoScalingGroupName = AutoScalingGroupName, LifecycleTransition = LifecycleTransition, RoleARN = RoleARN, NotificationTargetARN = NotificationTargetARN, NotificationMetadata = NotificationMetadata, HeartbeatTimeout = HeartbeatTimeout, DefaultResult = DefaultResult)
  output <- .autoscaling$put_lifecycle_hook_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_lifecycle_hook <- autoscaling_put_lifecycle_hook

#' Configures an Auto Scaling group to send notifications when specified
#' events take place
#'
#' Configures an Auto Scaling group to send notifications when specified
#' events take place. Subscribers to the specified topic can have messages
#' delivered to an endpoint such as a web server or an email address.
#' 
#' This configuration overwrites any existing configuration.
#' 
#' For more information, see [Getting Amazon SNS Notifications When Your
#' Auto Scaling Group
#' Scales](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ASGettingNotifications.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_put_notification_configuration(AutoScalingGroupName,
#'   TopicARN, NotificationTypes)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param TopicARN &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
#' (Amazon SNS) topic.
#' @param NotificationTypes &#91;required&#93; The type of event that causes the notification to be sent. To query the
#' notification types supported by Amazon EC2 Auto Scaling, call the
#' DescribeAutoScalingNotificationTypes API.
#'
#' @section Request syntax:
#' ```
#' svc$put_notification_configuration(
#'   AutoScalingGroupName = "string",
#'   TopicARN = "string",
#'   NotificationTypes = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example adds the specified notification to the specified Auto
#' # Scaling group.
#' svc$put_notification_configuration(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   NotificationTypes = list(
#'     "autoscaling:TEST_NOTIFICATION"
#'   ),
#'   TopicARN = "arn:aws:sns:us-west-2:123456789012:my-sns-topic"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_notification_configuration
autoscaling_put_notification_configuration <- function(AutoScalingGroupName, TopicARN, NotificationTypes) {
  op <- new_operation(
    name = "PutNotificationConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$put_notification_configuration_input(AutoScalingGroupName = AutoScalingGroupName, TopicARN = TopicARN, NotificationTypes = NotificationTypes)
  output <- .autoscaling$put_notification_configuration_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_notification_configuration <- autoscaling_put_notification_configuration

#' Creates or updates a scaling policy for an Auto Scaling group
#'
#' Creates or updates a scaling policy for an Auto Scaling group.
#' 
#' For more information about using scaling policies to scale your Auto
#' Scaling group, see [Target Tracking Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html)
#' and [Step and Simple Scaling
#' Policies](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_put_scaling_policy(AutoScalingGroupName, PolicyName,
#'   PolicyType, AdjustmentType, MinAdjustmentStep, MinAdjustmentMagnitude,
#'   ScalingAdjustment, Cooldown, MetricAggregationType, StepAdjustments,
#'   EstimatedInstanceWarmup, TargetTrackingConfiguration, Enabled)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param PolicyName &#91;required&#93; The name of the policy.
#' @param PolicyType One of the following policy types:
#' 
#' -   `TargetTrackingScaling`
#' 
#' -   `StepScaling`
#' 
#' -   `SimpleScaling` (default)
#' @param AdjustmentType Specifies how the scaling adjustment is interpreted (either an absolute
#' number or a percentage). The valid values are `ChangeInCapacity`,
#' `ExactCapacity`, and `PercentChangeInCapacity`.
#' 
#' Required if the policy type is `StepScaling` or `SimpleScaling`. For
#' more information, see [Scaling Adjustment
#' Types](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MinAdjustmentStep Available for backward compatibility. Use `MinAdjustmentMagnitude`
#' instead.
#' @param MinAdjustmentMagnitude The minimum value to scale by when the adjustment type is
#' `PercentChangeInCapacity`. For example, suppose that you create a step
#' scaling policy to scale out an Auto Scaling group by 25 percent and you
#' specify a `MinAdjustmentMagnitude` of 2. If the group has 4 instances
#' and the scaling policy is performed, 25 percent of 4 is 1. However,
#' because you specified a `MinAdjustmentMagnitude` of 2, Amazon EC2 Auto
#' Scaling scales out the group by 2 instances.
#' 
#' Valid only if the policy type is `StepScaling` or `SimpleScaling`. For
#' more information, see [Scaling Adjustment
#' Types](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Some Auto Scaling groups use instance weights. In this case, set the
#' `MinAdjustmentMagnitude` to a value that is at least as large as your
#' largest instance weight.
#' @param ScalingAdjustment The amount by which to scale, based on the specified adjustment type. A
#' positive value adds to the current capacity while a negative number
#' removes from the current capacity. For exact capacity, you must specify
#' a positive value.
#' 
#' Required if the policy type is `SimpleScaling`. (Not used with any other
#' policy type.)
#' @param Cooldown The duration of the policy\'s cooldown period, in seconds. When a
#' cooldown period is specified here, it overrides the default cooldown
#' period defined for the Auto Scaling group.
#' 
#' Valid only if the policy type is `SimpleScaling`. For more information,
#' see [Scaling Cooldowns for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MetricAggregationType The aggregation type for the CloudWatch metrics. The valid values are
#' `Minimum`, `Maximum`, and `Average`. If the aggregation type is null,
#' the value is treated as `Average`.
#' 
#' Valid only if the policy type is `StepScaling`.
#' @param StepAdjustments A set of adjustments that enable you to scale based on the size of the
#' alarm breach.
#' 
#' Required if the policy type is `StepScaling`. (Not used with any other
#' policy type.)
#' @param EstimatedInstanceWarmup The estimated time, in seconds, until a newly launched instance can
#' contribute to the CloudWatch metrics. If not provided, the default is to
#' use the value from the default cooldown period for the Auto Scaling
#' group.
#' 
#' Valid only if the policy type is `TargetTrackingScaling` or
#' `StepScaling`.
#' @param TargetTrackingConfiguration A target tracking scaling policy. Includes support for predefined or
#' customized metrics.
#' 
#' The following predefined metrics are available:
#' 
#' -   `ASGAverageCPUUtilization`
#' 
#' -   `ASGAverageNetworkIn`
#' 
#' -   `ASGAverageNetworkOut`
#' 
#' -   `ALBRequestCountPerTarget`
#' 
#' If you specify `ALBRequestCountPerTarget` for the metric, you must
#' specify the `ResourceLabel` parameter with the
#' `PredefinedMetricSpecification`.
#' 
#' For more information, see
#' [TargetTrackingConfiguration](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_TargetTrackingConfiguration.html)
#' in the *Amazon EC2 Auto Scaling API Reference*.
#' 
#' Required if the policy type is `TargetTrackingScaling`.
#' @param Enabled Indicates whether the scaling policy is enabled or disabled. The default
#' is enabled. For more information, see [Disabling a Scaling Policy for an
#' Auto Scaling
#' Group](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-enable-disable-scaling-policy.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$put_scaling_policy(
#'   AutoScalingGroupName = "string",
#'   PolicyName = "string",
#'   PolicyType = "string",
#'   AdjustmentType = "string",
#'   MinAdjustmentStep = 123,
#'   MinAdjustmentMagnitude = 123,
#'   ScalingAdjustment = 123,
#'   Cooldown = 123,
#'   MetricAggregationType = "string",
#'   StepAdjustments = list(
#'     list(
#'       MetricIntervalLowerBound = 123.0,
#'       MetricIntervalUpperBound = 123.0,
#'       ScalingAdjustment = 123
#'     )
#'   ),
#'   EstimatedInstanceWarmup = 123,
#'   TargetTrackingConfiguration = list(
#'     PredefinedMetricSpecification = list(
#'       PredefinedMetricType = "ASGAverageCPUUtilization"|"ASGAverageNetworkIn"|"ASGAverageNetworkOut"|"ALBRequestCountPerTarget",
#'       ResourceLabel = "string"
#'     ),
#'     CustomizedMetricSpecification = list(
#'       MetricName = "string",
#'       Namespace = "string",
#'       Dimensions = list(
#'         list(
#'           Name = "string",
#'           Value = "string"
#'         )
#'       ),
#'       Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
#'       Unit = "string"
#'     ),
#'     TargetValue = 123.0,
#'     DisableScaleIn = TRUE|FALSE
#'   ),
#'   Enabled = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example adds the specified policy to the specified Auto Scaling
#' # group.
#' svc$put_scaling_policy(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   PolicyName = "alb1000-target-tracking-scaling-policy",
#'   PolicyType = "TargetTrackingScaling",
#'   TargetTrackingConfiguration = list(
#'     PredefinedMetricSpecification = list(
#'       PredefinedMetricType = "ALBRequestCountPerTarget",
#'       ResourceLabel = "app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defa..."
#'     ),
#'     TargetValue = 1000
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_scaling_policy
autoscaling_put_scaling_policy <- function(AutoScalingGroupName, PolicyName, PolicyType = NULL, AdjustmentType = NULL, MinAdjustmentStep = NULL, MinAdjustmentMagnitude = NULL, ScalingAdjustment = NULL, Cooldown = NULL, MetricAggregationType = NULL, StepAdjustments = NULL, EstimatedInstanceWarmup = NULL, TargetTrackingConfiguration = NULL, Enabled = NULL) {
  op <- new_operation(
    name = "PutScalingPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$put_scaling_policy_input(AutoScalingGroupName = AutoScalingGroupName, PolicyName = PolicyName, PolicyType = PolicyType, AdjustmentType = AdjustmentType, MinAdjustmentStep = MinAdjustmentStep, MinAdjustmentMagnitude = MinAdjustmentMagnitude, ScalingAdjustment = ScalingAdjustment, Cooldown = Cooldown, MetricAggregationType = MetricAggregationType, StepAdjustments = StepAdjustments, EstimatedInstanceWarmup = EstimatedInstanceWarmup, TargetTrackingConfiguration = TargetTrackingConfiguration, Enabled = Enabled)
  output <- .autoscaling$put_scaling_policy_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_scaling_policy <- autoscaling_put_scaling_policy

#' Creates or updates a scheduled scaling action for an Auto Scaling group
#'
#' Creates or updates a scheduled scaling action for an Auto Scaling group.
#' If you leave a parameter unspecified when updating a scheduled scaling
#' action, the corresponding value remains unchanged.
#' 
#' For more information, see [Scheduled
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_put_scheduled_update_group_action(AutoScalingGroupName,
#'   ScheduledActionName, Time, StartTime, EndTime, Recurrence, MinSize,
#'   MaxSize, DesiredCapacity)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScheduledActionName &#91;required&#93; The name of this scaling action.
#' @param Time This parameter is no longer used.
#' @param StartTime The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ
#' format in UTC/GMT only and in quotes (for example,
#' `"2019-06-01T00:00:00Z"`).
#' 
#' If you specify `Recurrence` and `StartTime`, Amazon EC2 Auto Scaling
#' performs the action at this time, and then performs the action based on
#' the specified recurrence.
#' 
#' If you try to schedule your action in the past, Amazon EC2 Auto Scaling
#' returns an error message.
#' @param EndTime The date and time for the recurring schedule to end. Amazon EC2 Auto
#' Scaling does not perform the action after this time.
#' @param Recurrence The recurring schedule for this action, in Unix cron syntax format. This
#' format consists of five fields separated by white spaces: \[Minute\]
#' \[Hour\] \[Day\\_of\\_Month\] \[Month\\_of\\_Year\] \[Day\\_of\\_Week\]. The
#' value must be in quotes (for example, `"30 0 1 1,6,12 *"`). For more
#' information about this format, see [Crontab](http://crontab.org).
#' 
#' When `StartTime` and `EndTime` are specified with `Recurrence`, they
#' form the boundaries of when the recurring action starts and stops.
#' @param MinSize The minimum size of the Auto Scaling group.
#' @param MaxSize The maximum size of the Auto Scaling group.
#' @param DesiredCapacity The desired capacity is the initial capacity of the Auto Scaling group
#' after the scheduled action runs and the capacity it attempts to
#' maintain. It can scale beyond this capacity if you add more scaling
#' conditions.
#'
#' @section Request syntax:
#' ```
#' svc$put_scheduled_update_group_action(
#'   AutoScalingGroupName = "string",
#'   ScheduledActionName = "string",
#'   Time = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Recurrence = "string",
#'   MinSize = 123,
#'   MaxSize = 123,
#'   DesiredCapacity = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example adds the specified scheduled action to the specified Auto
#' # Scaling group.
#' svc$put_scheduled_update_group_action(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   DesiredCapacity = 4L,
#'   EndTime = "2014-05-12T08:00:00Z",
#'   MaxSize = 6L,
#'   MinSize = 2L,
#'   ScheduledActionName = "my-scheduled-action",
#'   StartTime = "2014-05-12T08:00:00Z"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_put_scheduled_update_group_action
autoscaling_put_scheduled_update_group_action <- function(AutoScalingGroupName, ScheduledActionName, Time = NULL, StartTime = NULL, EndTime = NULL, Recurrence = NULL, MinSize = NULL, MaxSize = NULL, DesiredCapacity = NULL) {
  op <- new_operation(
    name = "PutScheduledUpdateGroupAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$put_scheduled_update_group_action_input(AutoScalingGroupName = AutoScalingGroupName, ScheduledActionName = ScheduledActionName, Time = Time, StartTime = StartTime, EndTime = EndTime, Recurrence = Recurrence, MinSize = MinSize, MaxSize = MaxSize, DesiredCapacity = DesiredCapacity)
  output <- .autoscaling$put_scheduled_update_group_action_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$put_scheduled_update_group_action <- autoscaling_put_scheduled_update_group_action

#' Records a heartbeat for the lifecycle action associated with the
#' specified token or instance
#'
#' Records a heartbeat for the lifecycle action associated with the
#' specified token or instance. This extends the timeout by the length of
#' time defined using the PutLifecycleHook API call.
#' 
#' This step is a part of the procedure for adding a lifecycle hook to an
#' Auto Scaling group:
#' 
#' 1.  (Optional) Create a Lambda function and a rule that allows
#'     CloudWatch Events to invoke your Lambda function when Amazon EC2
#'     Auto Scaling launches or terminates instances.
#' 
#' 2.  (Optional) Create a notification target and an IAM role. The target
#'     can be either an Amazon SQS queue or an Amazon SNS topic. The role
#'     allows Amazon EC2 Auto Scaling to publish lifecycle notifications to
#'     the target.
#' 
#' 3.  Create the lifecycle hook. Specify whether the hook is used when the
#'     instances launch or terminate.
#' 
#' 4.  **If you need more time, record the lifecycle action heartbeat to
#'     keep the instance in a pending state.**
#' 
#' 5.  If you finish before the timeout period ends, complete the lifecycle
#'     action.
#' 
#' For more information, see [Auto Scaling
#' Lifecycle](https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_record_lifecycle_action_heartbeat(LifecycleHookName,
#'   AutoScalingGroupName, LifecycleActionToken, InstanceId)
#'
#' @param LifecycleHookName &#91;required&#93; The name of the lifecycle hook.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LifecycleActionToken A token that uniquely identifies a specific lifecycle action associated
#' with an instance. Amazon EC2 Auto Scaling sends this token to the
#' notification target that you specified when you created the lifecycle
#' hook.
#' @param InstanceId The ID of the instance.
#'
#' @section Request syntax:
#' ```
#' svc$record_lifecycle_action_heartbeat(
#'   LifecycleHookName = "string",
#'   AutoScalingGroupName = "string",
#'   LifecycleActionToken = "string",
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example records a lifecycle action heartbeat to keep the instance
#' # in a pending state.
#' svc$record_lifecycle_action_heartbeat(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   LifecycleActionToken = "bcd2f1b8-9a78-44d3-8a7a-4dd07d7cf635",
#'   LifecycleHookName = "my-lifecycle-hook"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_record_lifecycle_action_heartbeat
autoscaling_record_lifecycle_action_heartbeat <- function(LifecycleHookName, AutoScalingGroupName, LifecycleActionToken = NULL, InstanceId = NULL) {
  op <- new_operation(
    name = "RecordLifecycleActionHeartbeat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$record_lifecycle_action_heartbeat_input(LifecycleHookName = LifecycleHookName, AutoScalingGroupName = AutoScalingGroupName, LifecycleActionToken = LifecycleActionToken, InstanceId = InstanceId)
  output <- .autoscaling$record_lifecycle_action_heartbeat_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$record_lifecycle_action_heartbeat <- autoscaling_record_lifecycle_action_heartbeat

#' Resumes the specified suspended automatic scaling processes, or all
#' suspended process, for the specified Auto Scaling group
#'
#' Resumes the specified suspended automatic scaling processes, or all
#' suspended process, for the specified Auto Scaling group.
#' 
#' For more information, see [Suspending and Resuming Scaling
#' Processes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_resume_processes(AutoScalingGroupName, ScalingProcesses)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScalingProcesses One or more of the following processes:
#' 
#' -   `Launch`
#' 
#' -   `Terminate`
#' 
#' -   `AddToLoadBalancer`
#' 
#' -   `AlarmNotification`
#' 
#' -   `AZRebalance`
#' 
#' -   `HealthCheck`
#' 
#' -   `InstanceRefresh`
#' 
#' -   `ReplaceUnhealthy`
#' 
#' -   `ScheduledActions`
#' 
#' If you omit this parameter, all processes are specified.
#'
#' @section Request syntax:
#' ```
#' svc$resume_processes(
#'   AutoScalingGroupName = "string",
#'   ScalingProcesses = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example resumes the specified suspended scaling process for the
#' # specified Auto Scaling group.
#' svc$resume_processes(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   ScalingProcesses = list(
#'     "AlarmNotification"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_resume_processes
autoscaling_resume_processes <- function(AutoScalingGroupName, ScalingProcesses = NULL) {
  op <- new_operation(
    name = "ResumeProcesses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$resume_processes_input(AutoScalingGroupName = AutoScalingGroupName, ScalingProcesses = ScalingProcesses)
  output <- .autoscaling$resume_processes_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$resume_processes <- autoscaling_resume_processes

#' Sets the size of the specified Auto Scaling group
#'
#' Sets the size of the specified Auto Scaling group.
#' 
#' If a scale-in activity occurs as a result of a new `DesiredCapacity`
#' value that is lower than the current size of the group, the Auto Scaling
#' group uses its termination policy to determine which instances to
#' terminate.
#' 
#' For more information, see [Manual
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-manual-scaling.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_set_desired_capacity(AutoScalingGroupName, DesiredCapacity,
#'   HonorCooldown)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param DesiredCapacity &#91;required&#93; The desired capacity is the initial capacity of the Auto Scaling group
#' after this operation completes and the capacity it attempts to maintain.
#' @param HonorCooldown Indicates whether Amazon EC2 Auto Scaling waits for the cooldown period
#' to complete before initiating a scaling activity to set your Auto
#' Scaling group to its new capacity. By default, Amazon EC2 Auto Scaling
#' does not honor the cooldown period during manual scaling activities.
#'
#' @section Request syntax:
#' ```
#' svc$set_desired_capacity(
#'   AutoScalingGroupName = "string",
#'   DesiredCapacity = 123,
#'   HonorCooldown = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example sets the desired capacity for the specified Auto Scaling
#' # group.
#' svc$set_desired_capacity(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   DesiredCapacity = 2L,
#'   HonorCooldown = TRUE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_set_desired_capacity
autoscaling_set_desired_capacity <- function(AutoScalingGroupName, DesiredCapacity, HonorCooldown = NULL) {
  op <- new_operation(
    name = "SetDesiredCapacity",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$set_desired_capacity_input(AutoScalingGroupName = AutoScalingGroupName, DesiredCapacity = DesiredCapacity, HonorCooldown = HonorCooldown)
  output <- .autoscaling$set_desired_capacity_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$set_desired_capacity <- autoscaling_set_desired_capacity

#' Sets the health status of the specified instance
#'
#' Sets the health status of the specified instance.
#' 
#' For more information, see [Health Checks for Auto Scaling
#' Instances](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_set_instance_health(InstanceId, HealthStatus,
#'   ShouldRespectGracePeriod)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param HealthStatus &#91;required&#93; The health status of the instance. Set to `Healthy` to have the instance
#' remain in service. Set to `Unhealthy` to have the instance be out of
#' service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy
#' instance.
#' @param ShouldRespectGracePeriod If the Auto Scaling group of the specified instance has a
#' `HealthCheckGracePeriod` specified for the group, by default, this call
#' respects the grace period. Set this to `False`, to have the call not
#' respect the grace period associated with the group.
#' 
#' For more information about the health check grace period, see
#' [CreateAutoScalingGroup](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_CreateAutoScalingGroup.html)
#' in the *Amazon EC2 Auto Scaling API Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$set_instance_health(
#'   InstanceId = "string",
#'   HealthStatus = "string",
#'   ShouldRespectGracePeriod = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example sets the health status of the specified instance to
#' # Unhealthy.
#' svc$set_instance_health(
#'   HealthStatus = "Unhealthy",
#'   InstanceId = "i-93633f9b"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_set_instance_health
autoscaling_set_instance_health <- function(InstanceId, HealthStatus, ShouldRespectGracePeriod = NULL) {
  op <- new_operation(
    name = "SetInstanceHealth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$set_instance_health_input(InstanceId = InstanceId, HealthStatus = HealthStatus, ShouldRespectGracePeriod = ShouldRespectGracePeriod)
  output <- .autoscaling$set_instance_health_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$set_instance_health <- autoscaling_set_instance_health

#' Updates the instance protection settings of the specified instances
#'
#' Updates the instance protection settings of the specified instances.
#' 
#' For more information about preventing instances that are part of an Auto
#' Scaling group from terminating on scale in, see [Instance
#' Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_set_instance_protection(InstanceIds, AutoScalingGroupName,
#'   ProtectedFromScaleIn)
#'
#' @param InstanceIds &#91;required&#93; One or more instance IDs.
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ProtectedFromScaleIn &#91;required&#93; Indicates whether the instance is protected from termination by Amazon
#' EC2 Auto Scaling when scaling in.
#'
#' @section Request syntax:
#' ```
#' svc$set_instance_protection(
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   AutoScalingGroupName = "string",
#'   ProtectedFromScaleIn = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example enables instance protection for the specified instance.
#' svc$set_instance_protection(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   InstanceIds = list(
#'     "i-93633f9b"
#'   ),
#'   ProtectedFromScaleIn = TRUE
#' )
#' 
#' # This example disables instance protection for the specified instance.
#' svc$set_instance_protection(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   InstanceIds = list(
#'     "i-93633f9b"
#'   ),
#'   ProtectedFromScaleIn = FALSE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_set_instance_protection
autoscaling_set_instance_protection <- function(InstanceIds, AutoScalingGroupName, ProtectedFromScaleIn) {
  op <- new_operation(
    name = "SetInstanceProtection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$set_instance_protection_input(InstanceIds = InstanceIds, AutoScalingGroupName = AutoScalingGroupName, ProtectedFromScaleIn = ProtectedFromScaleIn)
  output <- .autoscaling$set_instance_protection_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$set_instance_protection <- autoscaling_set_instance_protection

#' Starts a new instance refresh operation, which triggers a rolling
#' replacement of all previously launched instances in the Auto Scaling
#' group with a new group of instances
#'
#' Starts a new instance refresh operation, which triggers a rolling
#' replacement of all previously launched instances in the Auto Scaling
#' group with a new group of instances.
#' 
#' If successful, this call creates a new instance refresh request with a
#' unique ID that you can use to track its progress. To query its status,
#' call the DescribeInstanceRefreshes API. To describe the instance
#' refreshes that have already run, call the DescribeInstanceRefreshes API.
#' To cancel an instance refresh operation in progress, use the
#' CancelInstanceRefresh API.
#' 
#' For more information, see [Replacing Auto Scaling Instances Based on an
#' Instance
#' Refresh](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-instance-refresh.html).
#'
#' @usage
#' autoscaling_start_instance_refresh(AutoScalingGroupName, Strategy,
#'   Preferences)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param Strategy The strategy to use for the instance refresh. The only valid value is
#' `Rolling`.
#' 
#' A rolling update is an update that is applied to all instances in an
#' Auto Scaling group until all instances have been updated. A rolling
#' update can fail due to failed health checks or if instances are on
#' standby or are protected from scale in. If the rolling update process
#' fails, any instances that were already replaced are not rolled back to
#' their previous configuration.
#' @param Preferences Set of preferences associated with the instance refresh request.
#' 
#' If not provided, the default values are used. For
#' `MinHealthyPercentage`, the default value is `90`. For `InstanceWarmup`,
#' the default is to use the value specified for the health check grace
#' period for the Auto Scaling group.
#' 
#' For more information, see
#' [RefreshPreferences](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_RefreshPreferences.html)
#' in the *Amazon EC2 Auto Scaling API Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$start_instance_refresh(
#'   AutoScalingGroupName = "string",
#'   Strategy = "Rolling",
#'   Preferences = list(
#'     MinHealthyPercentage = 123,
#'     InstanceWarmup = 123
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example starts an instance refresh for the specified Auto Scaling
#' # group.
#' svc$start_instance_refresh(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   Preferences = list(
#'     InstanceWarmup = 400L,
#'     MinHealthyPercentage = 50L
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_start_instance_refresh
autoscaling_start_instance_refresh <- function(AutoScalingGroupName, Strategy = NULL, Preferences = NULL) {
  op <- new_operation(
    name = "StartInstanceRefresh",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$start_instance_refresh_input(AutoScalingGroupName = AutoScalingGroupName, Strategy = Strategy, Preferences = Preferences)
  output <- .autoscaling$start_instance_refresh_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$start_instance_refresh <- autoscaling_start_instance_refresh

#' Suspends the specified automatic scaling processes, or all processes,
#' for the specified Auto Scaling group
#'
#' Suspends the specified automatic scaling processes, or all processes,
#' for the specified Auto Scaling group.
#' 
#' If you suspend either the `Launch` or `Terminate` process types, it can
#' prevent other process types from functioning properly. For more
#' information, see [Suspending and Resuming Scaling
#' Processes](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' To resume processes that have been suspended, call the ResumeProcesses
#' API.
#'
#' @usage
#' autoscaling_suspend_processes(AutoScalingGroupName, ScalingProcesses)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param ScalingProcesses One or more of the following processes:
#' 
#' -   `Launch`
#' 
#' -   `Terminate`
#' 
#' -   `AddToLoadBalancer`
#' 
#' -   `AlarmNotification`
#' 
#' -   `AZRebalance`
#' 
#' -   `HealthCheck`
#' 
#' -   `InstanceRefresh`
#' 
#' -   `ReplaceUnhealthy`
#' 
#' -   `ScheduledActions`
#' 
#' If you omit this parameter, all processes are specified.
#'
#' @section Request syntax:
#' ```
#' svc$suspend_processes(
#'   AutoScalingGroupName = "string",
#'   ScalingProcesses = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example suspends the specified scaling process for the specified
#' # Auto Scaling group.
#' svc$suspend_processes(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   ScalingProcesses = list(
#'     "AlarmNotification"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_suspend_processes
autoscaling_suspend_processes <- function(AutoScalingGroupName, ScalingProcesses = NULL) {
  op <- new_operation(
    name = "SuspendProcesses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$suspend_processes_input(AutoScalingGroupName = AutoScalingGroupName, ScalingProcesses = ScalingProcesses)
  output <- .autoscaling$suspend_processes_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$suspend_processes <- autoscaling_suspend_processes

#' Terminates the specified instance and optionally adjusts the desired
#' group size
#'
#' Terminates the specified instance and optionally adjusts the desired
#' group size.
#' 
#' This call simply makes a termination request. The instance is not
#' terminated immediately. When an instance is terminated, the instance
#' status changes to `terminated`. You can\'t connect to or start an
#' instance after you\'ve terminated it.
#' 
#' If you do not specify the option to decrement the desired capacity,
#' Amazon EC2 Auto Scaling launches instances to replace the ones that are
#' terminated.
#' 
#' By default, Amazon EC2 Auto Scaling balances instances across all
#' Availability Zones. If you decrement the desired capacity, your Auto
#' Scaling group can become unbalanced between Availability Zones. Amazon
#' EC2 Auto Scaling tries to rebalance the group, and rebalancing might
#' terminate instances in other zones. For more information, see
#' [Rebalancing
#' Activities](https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-benefits.html#AutoScalingBehavior.InstanceUsage)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#'
#' @usage
#' autoscaling_terminate_instance_in_auto_scaling_group(InstanceId,
#'   ShouldDecrementDesiredCapacity)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param ShouldDecrementDesiredCapacity &#91;required&#93; Indicates whether terminating the instance also decrements the size of
#' the Auto Scaling group.
#'
#' @section Request syntax:
#' ```
#' svc$terminate_instance_in_auto_scaling_group(
#'   InstanceId = "string",
#'   ShouldDecrementDesiredCapacity = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example terminates the specified instance from the specified Auto
#' # Scaling group without updating the size of the group. Auto Scaling
#' # launches a replacement instance after the specified instance terminates.
#' svc$terminate_instance_in_auto_scaling_group(
#'   InstanceId = "i-93633f9b",
#'   ShouldDecrementDesiredCapacity = FALSE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_terminate_instance_in_auto_scaling_group
autoscaling_terminate_instance_in_auto_scaling_group <- function(InstanceId, ShouldDecrementDesiredCapacity) {
  op <- new_operation(
    name = "TerminateInstanceInAutoScalingGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$terminate_instance_in_auto_scaling_group_input(InstanceId = InstanceId, ShouldDecrementDesiredCapacity = ShouldDecrementDesiredCapacity)
  output <- .autoscaling$terminate_instance_in_auto_scaling_group_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$terminate_instance_in_auto_scaling_group <- autoscaling_terminate_instance_in_auto_scaling_group

#' Updates the configuration for the specified Auto Scaling group
#'
#' Updates the configuration for the specified Auto Scaling group.
#' 
#' To update an Auto Scaling group, specify the name of the group and the
#' parameter that you want to change. Any parameters that you don\'t
#' specify are not changed by this update request. The new settings take
#' effect on any scaling activities after this call returns.
#' 
#' If you associate a new launch configuration or template with an Auto
#' Scaling group, all new instances will get the updated configuration.
#' Existing instances continue to run with the configuration that they were
#' originally launched with. When you update a group to specify a mixed
#' instances policy instead of a launch configuration or template, existing
#' instances may be replaced to match the new purchasing options that you
#' specified in the policy. For example, if the group currently has 100%
#' On-Demand capacity and the policy specifies 50% Spot capacity, this
#' means that half of your instances will be gradually terminated and
#' relaunched as Spot Instances. When replacing instances, Amazon EC2 Auto
#' Scaling launches new instances before terminating the old ones, so that
#' updating your group does not compromise the performance or availability
#' of your application.
#' 
#' Note the following about changing `DesiredCapacity`, `MaxSize`, or
#' `MinSize`:
#' 
#' -   If a scale-in activity occurs as a result of a new `DesiredCapacity`
#'     value that is lower than the current size of the group, the Auto
#'     Scaling group uses its termination policy to determine which
#'     instances to terminate.
#' 
#' -   If you specify a new value for `MinSize` without specifying a value
#'     for `DesiredCapacity`, and the new `MinSize` is larger than the
#'     current size of the group, this sets the group\'s `DesiredCapacity`
#'     to the new `MinSize` value.
#' 
#' -   If you specify a new value for `MaxSize` without specifying a value
#'     for `DesiredCapacity`, and the new `MaxSize` is smaller than the
#'     current size of the group, this sets the group\'s `DesiredCapacity`
#'     to the new `MaxSize` value.
#' 
#' To see which parameters have been set, call the
#' DescribeAutoScalingGroups API. To view the scaling policies for an Auto
#' Scaling group, call the DescribePolicies API. If the group has scaling
#' policies, you can update them by calling the PutScalingPolicy API.
#'
#' @usage
#' autoscaling_update_auto_scaling_group(AutoScalingGroupName,
#'   LaunchConfigurationName, LaunchTemplate, MixedInstancesPolicy, MinSize,
#'   MaxSize, DesiredCapacity, DefaultCooldown, AvailabilityZones,
#'   HealthCheckType, HealthCheckGracePeriod, PlacementGroup,
#'   VPCZoneIdentifier, TerminationPolicies,
#'   NewInstancesProtectedFromScaleIn, ServiceLinkedRoleARN,
#'   MaxInstanceLifetime)
#'
#' @param AutoScalingGroupName &#91;required&#93; The name of the Auto Scaling group.
#' @param LaunchConfigurationName The name of the launch configuration. If you specify
#' `LaunchConfigurationName` in your update request, you can\'t specify
#' `LaunchTemplate` or `MixedInstancesPolicy`.
#' @param LaunchTemplate The launch template and version to use to specify the updates. If you
#' specify `LaunchTemplate` in your update request, you can\'t specify
#' `LaunchConfigurationName` or `MixedInstancesPolicy`.
#' 
#' For more information, see
#' [LaunchTemplateSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_LaunchTemplateSpecification.html)
#' in the *Amazon EC2 Auto Scaling API Reference*.
#' @param MixedInstancesPolicy An embedded object that specifies a mixed instances policy.
#' 
#' In your call to `UpdateAutoScalingGroup`, you can make changes to the
#' policy that is specified. All optional parameters are left unchanged if
#' not specified.
#' 
#' For more information, see
#' [MixedInstancesPolicy](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_MixedInstancesPolicy.html)
#' in the *Amazon EC2 Auto Scaling API Reference* and [Auto Scaling Groups
#' with Multiple Instance Types and Purchase
#' Options](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MinSize The minimum size of the Auto Scaling group.
#' @param MaxSize The maximum size of the Auto Scaling group.
#' 
#' With a mixed instances policy that uses instance weighting, Amazon EC2
#' Auto Scaling may need to go above `MaxSize` to meet your capacity
#' requirements. In this event, Amazon EC2 Auto Scaling will never go above
#' `MaxSize` by more than your maximum instance weight (weights that define
#' how many capacity units each instance contributes to the capacity of the
#' group).
#' @param DesiredCapacity The desired capacity is the initial capacity of the Auto Scaling group
#' after this operation completes and the capacity it attempts to maintain.
#' 
#' This number must be greater than or equal to the minimum size of the
#' group and less than or equal to the maximum size of the group.
#' @param DefaultCooldown The amount of time, in seconds, after a scaling activity completes
#' before another scaling activity can start. The default value is `300`.
#' 
#' This setting applies when using simple scaling policies, but not when
#' using other scaling policies or scheduled scaling. For more information,
#' see [Scaling Cooldowns for Amazon EC2 Auto
#' Scaling](https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param AvailabilityZones One or more Availability Zones for the group.
#' @param HealthCheckType The service to use for the health checks. The valid values are `EC2` and
#' `ELB`. If you configure an Auto Scaling group to use ELB health checks,
#' it considers the instance unhealthy if it fails either the EC2 status
#' checks or the load balancer health checks.
#' @param HealthCheckGracePeriod The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
#' before checking the health status of an EC2 instance that has come into
#' service. The default value is `0`.
#' 
#' For more information, see [Health Check Grace
#' Period](https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html#health-check-grace-period)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Required if you are adding an `ELB` health check.
#' @param PlacementGroup The name of the placement group into which to launch your instances, if
#' any. A placement group is a logical grouping of instances within a
#' single Availability Zone. You cannot specify multiple Availability Zones
#' and a placement group. For more information, see [Placement
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' @param VPCZoneIdentifier A comma-separated list of subnet IDs for virtual private cloud (VPC).
#' 
#' If you specify `VPCZoneIdentifier` with `AvailabilityZones`, the subnets
#' that you specify for this parameter must reside in those Availability
#' Zones.
#' @param TerminationPolicies A standalone termination policy or a list of termination policies used
#' to select the instance to terminate. The policies are executed in the
#' order that they are listed.
#' 
#' For more information, see [Controlling Which Instances Auto Scaling
#' Terminates During Scale
#' In](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param NewInstancesProtectedFromScaleIn Indicates whether newly launched instances are protected from
#' termination by Amazon EC2 Auto Scaling when scaling in.
#' 
#' For more information about preventing instances from terminating on
#' scale in, see [Instance
#' Protection](https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param ServiceLinkedRoleARN The Amazon Resource Name (ARN) of the service-linked role that the Auto
#' Scaling group uses to call other AWS services on your behalf. For more
#' information, see [Service-Linked
#' Roles](https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' @param MaxInstanceLifetime The maximum amount of time, in seconds, that an instance can be in
#' service. The default is null.
#' 
#' This parameter is optional, but if you specify a value for it, you must
#' specify a value of at least 604,800 seconds (7 days). To clear a
#' previously set value, specify a new value of 0.
#' 
#' For more information, see [Replacing Auto Scaling Instances Based on
#' Maximum Instance
#' Lifetime](https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-max-instance-lifetime.html)
#' in the *Amazon EC2 Auto Scaling User Guide*.
#' 
#' Valid Range: Minimum value of 0.
#'
#' @section Request syntax:
#' ```
#' svc$update_auto_scaling_group(
#'   AutoScalingGroupName = "string",
#'   LaunchConfigurationName = "string",
#'   LaunchTemplate = list(
#'     LaunchTemplateId = "string",
#'     LaunchTemplateName = "string",
#'     Version = "string"
#'   ),
#'   MixedInstancesPolicy = list(
#'     LaunchTemplate = list(
#'       LaunchTemplateSpecification = list(
#'         LaunchTemplateId = "string",
#'         LaunchTemplateName = "string",
#'         Version = "string"
#'       ),
#'       Overrides = list(
#'         list(
#'           InstanceType = "string",
#'           WeightedCapacity = "string"
#'         )
#'       )
#'     ),
#'     InstancesDistribution = list(
#'       OnDemandAllocationStrategy = "string",
#'       OnDemandBaseCapacity = 123,
#'       OnDemandPercentageAboveBaseCapacity = 123,
#'       SpotAllocationStrategy = "string",
#'       SpotInstancePools = 123,
#'       SpotMaxPrice = "string"
#'     )
#'   ),
#'   MinSize = 123,
#'   MaxSize = 123,
#'   DesiredCapacity = 123,
#'   DefaultCooldown = 123,
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   HealthCheckType = "string",
#'   HealthCheckGracePeriod = 123,
#'   PlacementGroup = "string",
#'   VPCZoneIdentifier = "string",
#'   TerminationPolicies = list(
#'     "string"
#'   ),
#'   NewInstancesProtectedFromScaleIn = TRUE|FALSE,
#'   ServiceLinkedRoleARN = "string",
#'   MaxInstanceLifetime = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example updates the launch configuration of the specified Auto
#' # Scaling group.
#' svc$update_auto_scaling_group(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   LaunchConfigurationName = "new-launch-config"
#' )
#' 
#' # This example updates the minimum size and maximum size of the specified
#' # Auto Scaling group.
#' svc$update_auto_scaling_group(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   MaxSize = 3L,
#'   MinSize = 1L
#' )
#' 
#' # This example enables instance protection for the specified Auto Scaling
#' # group.
#' svc$update_auto_scaling_group(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   NewInstancesProtectedFromScaleIn = TRUE
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname autoscaling_update_auto_scaling_group
autoscaling_update_auto_scaling_group <- function(AutoScalingGroupName, LaunchConfigurationName = NULL, LaunchTemplate = NULL, MixedInstancesPolicy = NULL, MinSize = NULL, MaxSize = NULL, DesiredCapacity = NULL, DefaultCooldown = NULL, AvailabilityZones = NULL, HealthCheckType = NULL, HealthCheckGracePeriod = NULL, PlacementGroup = NULL, VPCZoneIdentifier = NULL, TerminationPolicies = NULL, NewInstancesProtectedFromScaleIn = NULL, ServiceLinkedRoleARN = NULL, MaxInstanceLifetime = NULL) {
  op <- new_operation(
    name = "UpdateAutoScalingGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .autoscaling$update_auto_scaling_group_input(AutoScalingGroupName = AutoScalingGroupName, LaunchConfigurationName = LaunchConfigurationName, LaunchTemplate = LaunchTemplate, MixedInstancesPolicy = MixedInstancesPolicy, MinSize = MinSize, MaxSize = MaxSize, DesiredCapacity = DesiredCapacity, DefaultCooldown = DefaultCooldown, AvailabilityZones = AvailabilityZones, HealthCheckType = HealthCheckType, HealthCheckGracePeriod = HealthCheckGracePeriod, PlacementGroup = PlacementGroup, VPCZoneIdentifier = VPCZoneIdentifier, TerminationPolicies = TerminationPolicies, NewInstancesProtectedFromScaleIn = NewInstancesProtectedFromScaleIn, ServiceLinkedRoleARN = ServiceLinkedRoleARN, MaxInstanceLifetime = MaxInstanceLifetime)
  output <- .autoscaling$update_auto_scaling_group_output()
  config <- get_config()
  svc <- .autoscaling$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.autoscaling$operations$update_auto_scaling_group <- autoscaling_update_auto_scaling_group
