% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_accept_portfolio_share}
\alias{servicecatalog_accept_portfolio_share}
\title{Accepts an offer to share the specified portfolio}
\usage{
servicecatalog_accept_portfolio_share(AcceptLanguage, PortfolioId,
  PortfolioShareType)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PortfolioId}{[required] The portfolio identifier.}

\item{PortfolioShareType}{The type of shared portfolios to accept. The default is to accept
imported portfolios.
\itemize{
\item \code{AWS_ORGANIZATIONS} - Accept portfolios shared by the master account
of your organization.
\item \code{IMPORTED} - Accept imported portfolios.
\item \code{AWS_SERVICECATALOG} - Not supported. (Throws
ResourceNotFoundException.)
}

For example,
\verb{aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS}}
}
\description{
Accepts an offer to share the specified portfolio.
}
\section{Request syntax}{
\preformatted{svc$accept_portfolio_share(
  AcceptLanguage = "string",
  PortfolioId = "string",
  PortfolioShareType = "IMPORTED"|"AWS_SERVICECATALOG"|"AWS_ORGANIZATIONS"
)
}
}

\keyword{internal}
