% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_get_inventory}
\alias{ssm_get_inventory}
\title{Query inventory information}
\usage{
ssm_get_inventory(
  Filters = NULL,
  Aggregators = NULL,
  ResultAttributes = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{One or more filters. Use a filter to return a more specific list of
results.}

\item{Aggregators}{Returns counts of inventory types based on one or more expressions. For
example, if you aggregate by using an expression that uses the
\code{AWS:InstanceInformation.PlatformType} type, you can see a count of how
many Windows and Linux managed nodes exist in your inventoried fleet.}

\item{ResultAttributes}{The list of inventory item types to return.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}
}
\description{
Query inventory information. This includes managed node status, such as \code{Stopped} or \code{Terminated}.

See \url{https://paws-r.github.io/docs/ssm/get_inventory.html} for full documentation.
}
\keyword{internal}
