% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_account_limits}
\alias{elbv2_describe_account_limits}
\title{Describes the current Elastic Load Balancing resource limits for your
AWS account}
\usage{
elbv2_describe_account_limits(Marker, PageSize)
}
\arguments{
\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{PageSize}{The maximum number of results to return with this call.}
}
\description{
Describes the current Elastic Load Balancing resource limits for your
AWS account.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html}{Limits for Your Application Load Balancers}
in the \emph{Application Load Balancer Guide} or \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html}{Limits for Your Network Load Balancers}
in the \emph{Network Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_account_limits(
  Marker = "string",
  PageSize = 123
)
}
}

\keyword{internal}
