% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_describe_direct_connect_gateways}
\alias{directconnect_describe_direct_connect_gateways}
\title{Lists all your Direct Connect gateways or only the specified Direct
Connect gateway}
\usage{
directconnect_describe_direct_connect_gateways(directConnectGatewayId,
  maxResults, nextToken)
}
\arguments{
\item{directConnectGatewayId}{The ID of the Direct Connect gateway.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.

If \code{MaxResults} is given a value larger than 100, only 100 results are
returned.}

\item{nextToken}{The token provided in the previous call to retrieve the next page.}
}
\description{
Lists all your Direct Connect gateways or only the specified Direct
Connect gateway. Deleted Direct Connect gateways are not returned.
}
\section{Request syntax}{
\preformatted{svc$describe_direct_connect_gateways(
  directConnectGatewayId = "string",
  maxResults = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
