% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_get_domain_names}
\alias{apigateway_get_domain_names}
\title{Represents a collection of DomainName resources}
\usage{
apigateway_get_domain_names(position, limit)
}
\arguments{
\item{position}{The current pagination position in the paged result set.}

\item{limit}{The maximum number of returned results per page. The default value is 25
and the maximum value is 500.}
}
\value{
A list with the following syntax:\preformatted{list(
  position = "string",
  items = list(
    list(
      domainName = "string",
      certificateName = "string",
      certificateArn = "string",
      certificateUploadDate = as.POSIXct(
        "2015-01-01"
      ),
      regionalDomainName = "string",
      regionalHostedZoneId = "string",
      regionalCertificateName = "string",
      regionalCertificateArn = "string",
      distributionDomainName = "string",
      distributionHostedZoneId = "string",
      endpointConfiguration = list(
        types = list(
          "REGIONAL"|"EDGE"|"PRIVATE"
        ),
        vpcEndpointIds = list(
          "string"
        )
      ),
      domainNameStatus = "AVAILABLE"|"UPDATING"|"PENDING",
      domainNameStatusMessage = "string",
      securityPolicy = "TLS_1_0"|"TLS_1_2",
      tags = list(
        "string"
      ),
      mutualTlsAuthentication = list(
        truststoreUri = "string",
        truststoreVersion = "string",
        truststoreWarnings = list(
          "string"
        )
      )
    )
  )
)
}
}
\description{
Represents a collection of DomainName resources.
}
\section{Request syntax}{
\preformatted{svc$get_domain_names(
  position = "string",
  limit = 123
)
}
}

\keyword{internal}
