% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_get_rest_api}
\alias{apigateway_get_rest_api}
\title{Lists the RestApi resource in the collection}
\usage{
apigateway_get_rest_api(restApiId)
}
\arguments{
\item{restApiId}{[required] [Required] The string identifier of the associated RestApi.}
}
\value{
A list with the following syntax:\preformatted{list(
  id = "string",
  name = "string",
  description = "string",
  createdDate = as.POSIXct(
    "2015-01-01"
  ),
  version = "string",
  warnings = list(
    "string"
  ),
  binaryMediaTypes = list(
    "string"
  ),
  minimumCompressionSize = 123,
  apiKeySource = "HEADER"|"AUTHORIZER",
  endpointConfiguration = list(
    types = list(
      "REGIONAL"|"EDGE"|"PRIVATE"
    ),
    vpcEndpointIds = list(
      "string"
    )
  ),
  policy = "string",
  tags = list(
    "string"
  ),
  disableExecuteApiEndpoint = TRUE|FALSE
)
}
}
\description{
Lists the RestApi resource in the collection.
}
\section{Request syntax}{
\preformatted{svc$get_rest_api(
  restApiId = "string"
)
}
}

\keyword{internal}
