% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_describe_hosted_connections}
\alias{directconnect_describe_hosted_connections}
\title{Lists the hosted connections that have been provisioned on the specified
interconnect or link aggregation group (LAG)}
\usage{
directconnect_describe_hosted_connections(connectionId)
}
\arguments{
\item{connectionId}{[required] The ID of the interconnect or LAG.}
}
\value{
A list with the following syntax:\preformatted{list(
  connections = list(
    list(
      ownerAccount = "string",
      connectionId = "string",
      connectionName = "string",
      connectionState = "ordering"|"requested"|"pending"|"available"|"down"|"deleting"|"deleted"|"rejected"|"unknown",
      region = "string",
      location = "string",
      bandwidth = "string",
      vlan = 123,
      partnerName = "string",
      loaIssueTime = as.POSIXct(
        "2015-01-01"
      ),
      lagId = "string",
      awsDevice = "string",
      jumboFrameCapable = TRUE|FALSE,
      awsDeviceV2 = "string",
      hasLogicalRedundancy = "unknown"|"yes"|"no",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      providerName = "string"
    )
  )
)
}
}
\description{
Lists the hosted connections that have been provisioned on the specified
interconnect or link aggregation group (LAG).

Intended for use by AWS Direct Connect Partners only.
}
\section{Request syntax}{
\preformatted{svc$describe_hosted_connections(
  connectionId = "string"
)
}
}

\keyword{internal}
