% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_create_load_balancer}
\alias{elbv2_create_load_balancer}
\title{Creates an Application Load Balancer, Network Load Balancer, or Gateway
Load Balancer}
\usage{
elbv2_create_load_balancer(Name, Subnets, SubnetMappings,
  SecurityGroups, Scheme, Tags, Type, IpAddressType,
  CustomerOwnedIpv4Pool)
}
\arguments{
\item{Name}{[required] The name of the load balancer.

This name must be unique per region per account, can have a maximum of
32 characters, must contain only alphanumeric characters or hyphens,
must not begin or end with a hyphen, and must not begin with
"internal-".}

\item{Subnets}{The IDs of the public subnets. You can specify only one subnet per
Availability Zone. You must specify either subnets or subnet mappings.

[Application Load Balancers] You must specify subnets from at least
two Availability Zones.

[Application Load Balancers on Outposts] You must specify one Outpost
subnet.

[Application Load Balancers on Local Zones] You can specify subnets
from one or more Local Zones.

[Network Load Balancers] You can specify subnets from one or more
Availability Zones.

[Gateway Load Balancers] You can specify subnets from one or more
Availability Zones.}

\item{SubnetMappings}{The IDs of the public subnets. You can specify only one subnet per
Availability Zone. You must specify either subnets or subnet mappings.

[Application Load Balancers] You must specify subnets from at least
two Availability Zones. You cannot specify Elastic IP addresses for your
subnets.

[Application Load Balancers on Outposts] You must specify one Outpost
subnet.

[Application Load Balancers on Local Zones] You can specify subnets
from one or more Local Zones.

[Network Load Balancers] You can specify subnets from one or more
Availability Zones. You can specify one Elastic IP address per subnet if
you need static IP addresses for your internet-facing load balancer. For
internal load balancers, you can specify one private IP address per
subnet from the IPv4 range of the subnet. For internet-facing load
balancer, you can specify one IPv6 address per subnet.

[Gateway Load Balancers] You can specify subnets from one or more
Availability Zones. You cannot specify Elastic IP addresses for your
subnets.}

\item{SecurityGroups}{[Application Load Balancers] The IDs of the security groups for the
load balancer.}

\item{Scheme}{The nodes of an Internet-facing load balancer have public IP addresses.
The DNS name of an Internet-facing load balancer is publicly resolvable
to the public IP addresses of the nodes. Therefore, Internet-facing load
balancers can route requests from clients over the internet.

The nodes of an internal load balancer have only private IP addresses.
The DNS name of an internal load balancer is publicly resolvable to the
private IP addresses of the nodes. Therefore, internal load balancers
can route requests only from clients with access to the VPC for the load
balancer.

The default is an Internet-facing load balancer.

You cannot specify a scheme for a Gateway Load Balancer.}

\item{Tags}{The tags to assign to the load balancer.}

\item{Type}{The type of load balancer. The default is \code{application}.}

\item{IpAddressType}{The type of IP addresses used by the subnets for your load balancer. The
possible values are \code{ipv4} (for IPv4 addresses) and \code{dualstack} (for
IPv4 and IPv6 addresses). Internal load balancers must use \code{ipv4}.}

\item{CustomerOwnedIpv4Pool}{[Application Load Balancers on Outposts] The ID of the customer-owned
address pool (CoIP pool).}
}
\value{
A list with the following syntax:\preformatted{list(
  LoadBalancers = list(
    list(
      LoadBalancerArn = "string",
      DNSName = "string",
      CanonicalHostedZoneId = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      LoadBalancerName = "string",
      Scheme = "internet-facing"|"internal",
      VpcId = "string",
      State = list(
        Code = "active"|"provisioning"|"active_impaired"|"failed",
        Reason = "string"
      ),
      Type = "application"|"network"|"gateway",
      AvailabilityZones = list(
        list(
          ZoneName = "string",
          SubnetId = "string",
          OutpostId = "string",
          LoadBalancerAddresses = list(
            list(
              IpAddress = "string",
              AllocationId = "string",
              PrivateIPv4Address = "string",
              IPv6Address = "string"
            )
          )
        )
      ),
      SecurityGroups = list(
        "string"
      ),
      IpAddressType = "ipv4"|"dualstack",
      CustomerOwnedIpv4Pool = "string"
    )
  )
)
}
}
\description{
Creates an Application Load Balancer, Network Load Balancer, or Gateway
Load Balancer.

For more information, see the following:
\itemize{
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html}{Application Load Balancers}
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html}{Network Load Balancers}
\item \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html}{Gateway Load Balancers}
}

This operation is idempotent, which means that it completes at most one
time. If you attempt to create multiple load balancers with the same
settings, each call succeeds.
}
\section{Request syntax}{
\preformatted{svc$create_load_balancer(
  Name = "string",
  Subnets = list(
    "string"
  ),
  SubnetMappings = list(
    list(
      SubnetId = "string",
      AllocationId = "string",
      PrivateIPv4Address = "string",
      IPv6Address = "string"
    )
  ),
  SecurityGroups = list(
    "string"
  ),
  Scheme = "internet-facing"|"internal",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  Type = "application"|"network"|"gateway",
  IpAddressType = "ipv4"|"dualstack",
  CustomerOwnedIpv4Pool = "string"
)
}
}

\examples{
\dontrun{
# This example creates an Internet-facing load balancer and enables the
# Availability Zones for the specified subnets.
svc$create_load_balancer(
  Name = "my-load-balancer",
  Subnets = list(
    "subnet-b7d581c0",
    "subnet-8360a9e7"
  )
)

# This example creates an internal load balancer and enables the
# Availability Zones for the specified subnets.
svc$create_load_balancer(
  Name = "my-internal-load-balancer",
  Scheme = "internal",
  SecurityGroups = list(),
  Subnets = list(
    "subnet-b7d581c0",
    "subnet-8360a9e7"
  )
)
}

}
\keyword{internal}
