% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_distributions_by_origin_request_policy_id}
\alias{cloudfront_list_distributions_by_origin_request_policy_id}
\title{Gets a list of distribution IDs for distributions that have a cache
behavior that’s associated with the specified origin request policy}
\usage{
cloudfront_list_distributions_by_origin_request_policy_id(Marker,
  MaxItems, OriginRequestPolicyId)
}
\arguments{
\item{Marker}{Use this field when paginating results to indicate where to begin in
your list of distribution IDs. The response includes distribution IDs in
the list that occur after the marker. To get the next page of the list,
set this field’s value to the value of \code{NextMarker} from the current
page’s response.}

\item{MaxItems}{The maximum number of distribution IDs that you want in the response.}

\item{OriginRequestPolicyId}{[required] The ID of the origin request policy whose associated distribution IDs
you want to list.}
}
\value{
A list with the following syntax:\preformatted{list(
  DistributionIdList = list(
    Marker = "string",
    NextMarker = "string",
    MaxItems = 123,
    IsTruncated = TRUE|FALSE,
    Quantity = 123,
    Items = list(
      "string"
    )
  )
)
}
}
\description{
Gets a list of distribution IDs for distributions that have a cache
behavior that’s associated with the specified origin request policy.

You can optionally specify the maximum number of items to receive in the
response. If the total number of items in the list exceeds the maximum
that you specify, or the default maximum, the response is paginated. To
get the next page of items, send a subsequent request that specifies the
\code{NextMarker} value from the current response as the \code{Marker} value in
the subsequent request.
}
\section{Request syntax}{
\preformatted{svc$list_distributions_by_origin_request_policy_id(
  Marker = "string",
  MaxItems = "string",
  OriginRequestPolicyId = "string"
)
}
}

\keyword{internal}
