% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_create_domain_name}
\alias{apigatewayv2_create_domain_name}
\title{Creates a domain name}
\usage{
apigatewayv2_create_domain_name(DomainName, DomainNameConfigurations,
  Tags)
}
\arguments{
\item{DomainName}{[required] The domain name.}

\item{DomainNameConfigurations}{The domain name configurations.}

\item{Tags}{The key-value map of strings. The valid character set is
[a-zA-Z+-=.\_:/]. The tag key can be up to 128 characters and must not
start with aws:. The tag value can be up to 256 characters..}
}
\description{
Creates a domain name.
}
\section{Request syntax}{
\preformatted{svc$create_domain_name(
  DomainName = "string",
  DomainNameConfigurations = list(
    list(
      ApiGatewayDomainName = "string",
      CertificateArn = "string",
      CertificateName = "string",
      CertificateUploadDate = as.POSIXct(
        "2015-01-01"
      ),
      EndpointType = "REGIONAL"|"EDGE",
      HostedZoneId = "string",
      SecurityPolicy = "TLS_1_0"|"TLS_1_2",
      DomainNameStatus = "AVAILABLE"|"UPDATING",
      DomainNameStatusMessage = "string"
    )
  ),
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
