% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_invalidations}
\alias{cloudfront_list_invalidations}
\title{Lists invalidation batches}
\usage{
cloudfront_list_invalidations(DistributionId, Marker, MaxItems)
}
\arguments{
\item{DistributionId}{[required] The distribution's ID.}

\item{Marker}{Use this parameter when paginating results to indicate where to begin in
your list of invalidation batches. Because the results are returned in
decreasing order from most recent to oldest, the most recent results are
on the first page, the second page will contain earlier results, and so
on. To get the next page of results, set \code{Marker} to the value of the
\code{NextMarker} from the current page's response. This value is the same
as the ID of the last invalidation batch on that page.}

\item{MaxItems}{The maximum number of invalidation batches that you want in the response
body.}
}
\description{
Lists invalidation batches.
}
\section{Request syntax}{
\preformatted{svc$list_invalidations(
  DistributionId = "string",
  Marker = "string",
  MaxItems = "string"
)
}
}

\keyword{internal}
