% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_target_health}
\alias{elbv2_describe_target_health}
\title{Describes the health of the specified targets or all of your targets}
\usage{
elbv2_describe_target_health(TargetGroupArn, Targets)
}
\arguments{
\item{TargetGroupArn}{[required] The Amazon Resource Name (ARN) of the target group.}

\item{Targets}{The targets.}
}
\description{
Describes the health of the specified targets or all of your targets.
}
\section{Request syntax}{
\preformatted{svc$describe_target_health(
  TargetGroupArn = "string",
  Targets = list(
    list(
      Id = "string",
      Port = 123,
      AvailabilityZone = "string"
    )
  )
)
}
}

\examples{
# This example describes the health of the targets for the specified
# target group. One target is healthy but the other is not specified in an
# action, so it can't receive traffic from the load balancer.
\dontrun{svc$describe_target_health(
  TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targe..."
)}

# This example describes the health of the specified target. This target
# is healthy.
\dontrun{svc$describe_target_health(
  TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targe...",
  Targets = list(
    list(
      Id = "i-0f76fade",
      Port = 80L
    )
  )
)}

}
\keyword{internal}
