% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_attach_load_balancer_to_subnets}
\alias{elb_attach_load_balancer_to_subnets}
\title{Adds one or more subnets to the set of configured subnets for the
specified load balancer}
\usage{
elb_attach_load_balancer_to_subnets(LoadBalancerName, Subnets)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{Subnets}{[required] The IDs of the subnets to add. You can add only one subnet per
Availability Zone.}
}
\description{
Adds one or more subnets to the set of configured subnets for the
specified load balancer.
}
\details{
The load balancer evenly distributes requests across all registered
subnets. For more information, see \href{http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html}{Add or Remove Subnets for Your Load Balancer in a VPC}
in the \emph{Classic Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$attach_load_balancer_to_subnets(
  LoadBalancerName = "string",
  Subnets = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example adds the specified subnet to the set of configured subnets
# for the specified load balancer.
svc$attach_load_balancer_to_subnets(
  LoadBalancerName = "my-load-balancer",
  Subnets = list(
    "subnet-0ecac448"
  )
)
}

}
\keyword{internal}
