% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_delete_virtual_node}
\alias{appmesh_delete_virtual_node}
\title{Deletes an existing virtual node}
\usage{
appmesh_delete_virtual_node(meshName, meshOwner, virtualNodeName)
}
\arguments{
\item{meshName}{[required] The name of the service mesh to delete the virtual node in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it\'s the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{virtualNodeName}{[required] The name of the virtual node to delete.}
}
\description{
Deletes an existing virtual node.
}
\details{
You must delete any virtual services that list a virtual node as a
service provider before you can delete the virtual node itself.
}
\section{Request syntax}{
\preformatted{svc$delete_virtual_node(
  meshName = "string",
  meshOwner = "string",
  virtualNodeName = "string"
)
}
}

\keyword{internal}
