% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_describe_virtual_gateway}
\alias{appmesh_describe_virtual_gateway}
\title{Describes an existing virtual gateway}
\usage{
appmesh_describe_virtual_gateway(meshName, meshOwner,
  virtualGatewayName)
}
\arguments{
\item{meshName}{[required] The name of the service mesh that the gateway route resides in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it\'s the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{virtualGatewayName}{[required] The name of the virtual gateway to describe.}
}
\description{
Describes an existing virtual gateway.
}
\section{Request syntax}{
\preformatted{svc$describe_virtual_gateway(
  meshName = "string",
  meshOwner = "string",
  virtualGatewayName = "string"
)
}
}

\keyword{internal}
