% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_withdraw_byoip_cidr}
\alias{globalaccelerator_withdraw_byoip_cidr}
\title{Stops advertising an address range that is provisioned as an address
pool}
\usage{
globalaccelerator_withdraw_byoip_cidr(Cidr)
}
\arguments{
\item{Cidr}{[required] The address range, in CIDR notation.}
}
\description{
Stops advertising an address range that is provisioned as an address
pool. You can perform this operation at most once every 10 seconds, even
if you specify different address ranges each time. To see an AWS CLI
example of withdrawing an address range for BYOIP so it will no longer
be advertised by AWS, scroll down to \strong{Example}.
}
\details{
It can take a few minutes before traffic to the specified addresses
stops routing to AWS because of propagation delays.

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html}{Bring Your Own IP Addresses (BYOIP)}
in the \emph{AWS Global Accelerator Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$withdraw_byoip_cidr(
  Cidr = "string"
)
}
}

\keyword{internal}
