% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_authorizer}
\alias{apigateway_create_authorizer}
\title{Adds a new Authorizer resource to an existing RestApi resource}
\usage{
apigateway_create_authorizer(
  restApiId,
  name,
  type,
  providerARNs = NULL,
  authType = NULL,
  authorizerUri = NULL,
  authorizerCredentials = NULL,
  identitySource = NULL,
  identityValidationExpression = NULL,
  authorizerResultTtlInSeconds = NULL
)
}
\arguments{
\item{restApiId}{[required] The string identifier of the associated RestApi.}

\item{name}{[required] The name of the authorizer.}

\item{type}{[required] The authorizer type. Valid values are \code{TOKEN} for a Lambda function
using a single authorization token submitted in a custom header,
\code{REQUEST} for a Lambda function using incoming request parameters, and
\code{COGNITO_USER_POOLS} for using an Amazon Cognito user pool.}

\item{providerARNs}{A list of the Amazon Cognito user pool ARNs for the \code{COGNITO_USER_POOLS}
authorizer. Each element is of this format:
\code{arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}}. For
a \code{TOKEN} or \code{REQUEST} authorizer, this is not defined.}

\item{authType}{Optional customer-defined field, used in OpenAPI imports and exports
without functional impact.}

\item{authorizerUri}{Specifies the authorizer's Uniform Resource Identifier (URI). For
\code{TOKEN} or \code{REQUEST} authorizers, this must be a well-formed Lambda
function URI, for example,
\verb{arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:\{account_id\}:function:\{lambda_function_name\}/invocations}.
In general, the URI has this form
\code{arn:aws:apigateway:{region}:lambda:path/{service_api}}, where
\code{{region}} is the same as the region hosting the Lambda function, \code{path}
indicates that the remaining substring in the URI should be treated as
the path to the resource, including the initial \code{/}. For Lambda
functions, this is usually of the form
\verb{/2015-03-31/functions/[FunctionARN]/invocations}.}

\item{authorizerCredentials}{Specifies the required credentials as an IAM role for API Gateway to
invoke the authorizer. To specify an IAM role for API Gateway to assume,
use the role's Amazon Resource Name (ARN). To use resource-based
permissions on the Lambda function, specify null.}

\item{identitySource}{The identity source for which authorization is requested. For a \code{TOKEN}
or \code{COGNITO_USER_POOLS} authorizer, this is required and specifies the
request header mapping expression for the custom header holding the
authorization token submitted by the client. For example, if the token
header name is \code{Auth}, the header mapping expression is
\code{method.request.header.Auth}. For the \code{REQUEST} authorizer, this is
required when authorization caching is enabled. The value is a
comma-separated string of one or more mapping expressions of the
specified request parameters. For example, if an \code{Auth} header, a \code{Name}
query string parameter are defined as identity sources, this value is
\verb{method.request.header.Auth, method.request.querystring.Name}. These
parameters will be used to derive the authorization caching key and to
perform runtime validation of the \code{REQUEST} authorizer by verifying all
of the identity-related request parameters are present, not null and
non-empty. Only when this is true does the authorizer invoke the
authorizer Lambda function, otherwise, it returns a 401 Unauthorized
response without calling the Lambda function. The valid value is a
string of comma-separated mapping expressions of the specified request
parameters. When the authorization caching is not enabled, this property
is optional.}

\item{identityValidationExpression}{A validation expression for the incoming identity token. For \code{TOKEN}
authorizers, this value is a regular expression. For
\code{COGNITO_USER_POOLS} authorizers, API Gateway will match the \code{aud} field
of the incoming token from the client against the specified regular
expression. It will invoke the authorizer's Lambda function when there
is a match. Otherwise, it will return a 401 Unauthorized response
without calling the Lambda function. The validation expression does not
apply to the \code{REQUEST} authorizer.}

\item{authorizerResultTtlInSeconds}{The TTL in seconds of cached authorizer results. If it equals 0,
authorization caching is disabled. If it is greater than 0, API Gateway
will cache authorizer responses. If this field is not set, the default
value is 300. The maximum value is 3600, or 1 hour.}
}
\description{
Adds a new Authorizer resource to an existing RestApi resource.

See \url{https://paws-r.github.io/docs/apigateway/create_authorizer.html} for full documentation.
}
\keyword{internal}
