% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_create_private_dns_namespace}
\alias{servicediscovery_create_private_dns_namespace}
\title{Creates a private namespace based on DNS, which is visible only inside a
specified Amazon VPC}
\usage{
servicediscovery_create_private_dns_namespace(
  Name,
  CreatorRequestId = NULL,
  Description = NULL,
  Vpc,
  Tags = NULL,
  Properties = NULL
)
}
\arguments{
\item{Name}{[required] The name that you want to assign to this namespace. When you create a
private DNS namespace, Cloud Map automatically creates an Amazon Route
53 private hosted zone that has the same name as the namespace.}

\item{CreatorRequestId}{A unique string that identifies the request and that allows failed
\code{\link[=servicediscovery_create_private_dns_namespace]{create_private_dns_namespace}}
requests to be retried without the risk of running the operation twice.
\code{CreatorRequestId} can be any unique string (for example, a
date/timestamp).}

\item{Description}{A description for the namespace.}

\item{Vpc}{[required] The ID of the Amazon VPC that you want to associate the namespace with.}

\item{Tags}{The tags to add to the namespace. Each tag consists of a key and an
optional value that you define. Tags keys can be up to 128 characters in
length, and tag values can be up to 256 characters in length.}

\item{Properties}{Properties for the private DNS namespace.}
}
\description{
Creates a private namespace based on DNS, which is visible only inside a specified Amazon VPC. The namespace defines your service naming scheme. For example, if you name your namespace \code{example.com} and name your service \code{backend}, the resulting DNS name for the service is \code{backend.example.com}. Service instances that are registered using a private DNS namespace can be discovered using either a \code{\link[=servicediscovery_discover_instances]{discover_instances}} request or using DNS. For the current quota on the number of namespaces that you can create using the same account, see \href{https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html}{Cloud Map quotas} in the \emph{Cloud Map Developer Guide}.

See \url{https://paws-r.github.io/docs/servicediscovery/create_private_dns_namespace.html} for full documentation.
}
\keyword{internal}
