% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_create_connect_peer}
\alias{networkmanager_create_connect_peer}
\title{Creates a core network Connect peer for a specified core network connect
attachment between a core network and an appliance}
\usage{
networkmanager_create_connect_peer(
  ConnectAttachmentId,
  CoreNetworkAddress = NULL,
  PeerAddress,
  BgpOptions = NULL,
  InsideCidrBlocks,
  Tags = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{ConnectAttachmentId}{[required] The ID of the connection attachment.}

\item{CoreNetworkAddress}{A Connect peer core network address.}

\item{PeerAddress}{[required] The Connect peer address.}

\item{BgpOptions}{The Connect peer BGP options.}

\item{InsideCidrBlocks}{[required] The inside IP addresses used for BGP peering.}

\item{Tags}{The tags associated with the peer request.}

\item{ClientToken}{The client token associated with the request.}
}
\description{
Creates a core network Connect peer for a specified core network connect attachment between a core network and an appliance. The peer address and transit gateway address must be the same IP address family (IPv4 or IPv6).

See \url{https://www.paws-r-sdk.com/docs/networkmanager_create_connect_peer/} for full documentation.
}
\keyword{internal}
