% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appfabric_operations.R
\name{appfabric_connect_app_authorization}
\alias{appfabric_connect_app_authorization}
\title{Establishes a connection between Amazon Web Services AppFabric and an
application, which allows AppFabric to call the APIs of the application}
\usage{
appfabric_connect_app_authorization(
  appBundleIdentifier,
  appAuthorizationIdentifier,
  authRequest = NULL
)
}
\arguments{
\item{appBundleIdentifier}{[required] The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
the app bundle that contains the app authorization to use for the
request.}

\item{appAuthorizationIdentifier}{[required] The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of
the app authorization to use for the request.}

\item{authRequest}{Contains OAuth2 authorization information.

This is required if the app authorization for the request is configured
with an OAuth2 (\code{oauth2}) authorization type.}
}
\description{
Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call the APIs of the application.

See \url{https://www.paws-r-sdk.com/docs/appfabric_connect_app_authorization/} for full documentation.
}
\keyword{internal}
