% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arczonalshift_operations.R
\name{arczonalshift_create_practice_run_configuration}
\alias{arczonalshift_create_practice_run_configuration}
\title{A practice run configuration for zonal autoshift is required when you
enable zonal autoshift}
\usage{
arczonalshift_create_practice_run_configuration(
  blockedDates = NULL,
  blockedWindows = NULL,
  blockingAlarms = NULL,
  outcomeAlarms,
  resourceIdentifier
)
}
\arguments{
\item{blockedDates}{Optionally, you can block Route 53 ARC from starting practice runs for a
resource on specific calendar dates.

The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you
specify dates, that dates and times for practice runs are in UTC.
Separate multiple blocked dates with spaces.

For example, if you have an application update scheduled to launch on
May 1, 2024, and you don't want practice runs to shift traffic away at
that time, you could set a blocked date for \code{2024-05-01}.}

\item{blockedWindows}{Optionally, you can block Route 53 ARC from starting practice runs for
specific windows of days and times.

The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind,
when you specify dates, that dates and times for practice runs are in
UTC. Also, be aware of potential time adjustments that might be required
for daylight saving time differences. Separate multiple blocked windows
with spaces.

For example, say you run business report summaries three days a week.
For this scenario, you might set the following recurring days and times
as blocked windows, for example:
\verb{MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30}.}

\item{blockingAlarms}{An Amazon CloudWatch alarm that you can specify for zonal autoshift
practice runs. This alarm blocks Route 53 ARC from starting practice run
zonal shifts, and ends a practice run that's in progress, when the alarm
is in an \code{ALARM} state.}

\item{outcomeAlarms}{[required] The \emph{outcome alarm} for practice runs is a required Amazon CloudWatch
alarm that you specify that ends a practice run when the alarm is in an
\code{ALARM} state.

Configure the alarm to monitor the health of your application when
traffic is shifted away from an Availability Zone during each weekly
practice run. You should configure the alarm to go into an \code{ALARM} state
if your application is impacted by the zonal shift, and you want to stop
the zonal shift, to let traffic for the resource return to the
Availability Zone.}

\item{resourceIdentifier}{[required] The identifier of the resource to shift away traffic for when a practice
run starts a zonal shift. The identifier is the Amazon Resource Name
(ARN) for the resource.

At this time, supported resources are Network Load Balancers and
Application Load Balancers with cross-zone load balancing turned off.}
}
\description{
A practice run configuration for zonal autoshift is required when you enable zonal autoshift. A practice run configuration includes specifications for blocked dates and blocked time windows, and for Amazon CloudWatch alarms that you create to use with practice runs. The alarms that you specify are an \emph{outcome alarm}, to monitor application health during practice runs and, optionally, a \emph{blocking alarm}, to block practice runs from starting.

See \url{https://www.paws-r-sdk.com/docs/arczonalshift_create_practice_run_configuration/} for full documentation.
}
\keyword{internal}
