% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_update_custom_routing_accelerator_attributes}
\alias{globalaccelerator_update_custom_routing_accelerator_attributes}
\title{Update the attributes for a custom routing accelerator}
\usage{
globalaccelerator_update_custom_routing_accelerator_attributes(
  AcceleratorArn,
  FlowLogsEnabled = NULL,
  FlowLogsS3Bucket = NULL,
  FlowLogsS3Prefix = NULL
)
}
\arguments{
\item{AcceleratorArn}{[required] The Amazon Resource Name (ARN) of the custom routing accelerator to
update attributes for.}

\item{FlowLogsEnabled}{Update whether flow logs are enabled. The default value is false. If the
value is true, \code{FlowLogsS3Bucket} and \code{FlowLogsS3Prefix} must be
specified.

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html}{Flow logs}
in the \emph{Global Accelerator Developer Guide}.}

\item{FlowLogsS3Bucket}{The name of the Amazon S3 bucket for the flow logs. Attribute is
required if \code{FlowLogsEnabled} is \code{true}. The bucket must exist and have
a bucket policy that grants Global Accelerator permission to write to
the bucket.}

\item{FlowLogsS3Prefix}{Update the prefix for the location in the Amazon S3 bucket for the flow
logs. Attribute is required if \code{FlowLogsEnabled} is \code{true}.

If you don’t specify a prefix, the flow logs are stored in the root of
the bucket. If you specify slash (/) for the S3 bucket prefix, the log
file bucket folder structure will include a double slash (//), like the
following:

DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id}
}
\description{
Update the attributes for a custom routing accelerator.

See \url{https://www.paws-r-sdk.com/docs/globalaccelerator_update_custom_routing_accelerator_attributes/} for full documentation.
}
\keyword{internal}
