% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpclattice_operations.R
\name{vpclattice_create_service_network}
\alias{vpclattice_create_service_network}
\title{Creates a service network}
\usage{
vpclattice_create_service_network(
  authType = NULL,
  clientToken = NULL,
  name,
  tags = NULL
)
}
\arguments{
\item{authType}{The type of IAM policy.
\itemize{
\item \code{NONE}: The resource does not use an IAM policy. This is the
default.
\item \code{AWS_IAM}: The resource uses an IAM policy. When this type is used,
auth is enabled and an auth policy is required.
}}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If you retry a request that completed
successfully using the same client token and parameters, the retry
succeeds without performing any actions. If the parameters aren't
identical, the retry fails.}

\item{name}{[required] The name of the service network. The name must be unique to the account.
The valid characters are a-z, 0-9, and hyphens (-). You can't use a
hyphen as the first or last character, or immediately after another
hyphen.}

\item{tags}{The tags for the service network.}
}
\description{
Creates a service network. A service network is a logical boundary for a collection of services. You can associate services and VPCs with a service network.

See \url{https://www.paws-r-sdk.com/docs/vpclattice_create_service_network/} for full documentation.
}
\keyword{internal}
