% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_delete_policy}
\alias{fms_delete_policy}
\title{Permanently deletes an AWS Firewall Manager policy}
\usage{
fms_delete_policy(PolicyId, DeleteAllPolicyResources)
}
\arguments{
\item{PolicyId}{[required] The ID of the policy that you want to delete. You can retrieve this ID
from \code{PutPolicy} and \code{ListPolicies}.}

\item{DeleteAllPolicyResources}{If \code{True}, the request performs cleanup according to the policy type.

For AWS WAF and Shield Advanced policies, the cleanup does the
following:
\itemize{
\item Deletes rule groups created by AWS Firewall Manager
\item Removes web ACLs from in-scope resources
\item Deletes web ACLs that contain no rules or rule groups
}

For security group policies, the cleanup does the following for each
security group in the policy:
\itemize{
\item Disassociates the security group from in-scope resources
\item Deletes the security group if it was created through Firewall
Manager and if it's no longer associated with any resources through
another policy
}

After the cleanup, in-scope resources are no longer protected by web
ACLs in this policy. Protection of out-of-scope resources remains
unchanged. Scope is determined by tags that you create and accounts that
you associate with the policy. When creating the policy, if you specify
that only resources in specific accounts or with specific tags are in
scope of the policy, those accounts and resources are handled by the
policy. All others are out of scope. If you don't specify tags or
accounts, all resources are in scope.}
}
\description{
Permanently deletes an AWS Firewall Manager policy.
}
\section{Request syntax}{
\preformatted{svc$delete_policy(
  PolicyId = "string",
  DeleteAllPolicyResources = TRUE|FALSE
)
}
}

\keyword{internal}
