% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_register_cross_account_access_role}
\alias{inspector_register_cross_account_access_role}
\title{Registers the IAM role that grants Amazon Inspector access to AWS
Services needed to perform security assessments}
\usage{
inspector_register_cross_account_access_role(roleArn)
}
\arguments{
\item{roleArn}{[required] The ARN of the IAM role that grants Amazon Inspector access to AWS
Services needed to perform security assessments.}
}
\description{
Registers the IAM role that grants Amazon Inspector access to AWS
Services needed to perform security assessments.
}
\section{Request syntax}{
\preformatted{svc$register_cross_account_access_role(
  roleArn = "string"
)
}
}

\examples{
\dontrun{
# Registers the IAM role that Amazon Inspector uses to list your EC2
# instances at the start of the assessment run or when you call the
# PreviewAgents action.
svc$register_cross_account_access_role(
  roleArn = "arn:aws:iam::123456789012:role/inspector"
)
}

}
\keyword{internal}
