# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include waf_service.R
NULL

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a `ByteMatchSet`. You then use
#' [`update_byte_match_set`][waf_update_byte_match_set] to identify the
#' part of a web request that you want AWS WAF to inspect, such as the
#' values of the `User-Agent` header or the query string. For example, you
#' can create a `ByteMatchSet` that matches any requests with `User-Agent`
#' headers that contain the string `BadBot`. You can then configure AWS WAF
#' to reject those requests.
#' 
#' To create and configure a `ByteMatchSet`, perform the following steps:
#' 
#' 1.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_byte_match_set`][waf_create_byte_match_set] request.
#' 
#' 2.  Submit a [`create_byte_match_set`][waf_create_byte_match_set]
#'     request.
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_byte_match_set`][waf_update_byte_match_set] request.
#' 
#' 4.  Submit an [`update_byte_match_set`][waf_update_byte_match_set]
#'     request to specify the part of the request that you want AWS WAF to
#'     inspect (for example, the header or the URI) and the value that you
#'     want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_byte_match_set(Name, ChangeToken)
#'
#' @param Name &#91;required&#93; A friendly name or description of the ByteMatchSet. You can't change
#' `Name` after you create a `ByteMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ByteMatchSet = list(
#'     ByteMatchSetId = "string",
#'     Name = "string",
#'     ByteMatchTuples = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TargetString = raw,
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         PositionalConstraint = "EXACTLY"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CONTAINS_WORD"
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_byte_match_set(
#'   Name = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_create_byte_match_set
waf_create_byte_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateByteMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_byte_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_byte_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_byte_match_set <- waf_create_byte_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates an GeoMatchSet, which you use to specify which web requests you
#' want to allow or block based on the country that the requests originate
#' from. For example, if you're receiving a lot of requests from one or
#' more countries and you want to block the requests, you can create an
#' `GeoMatchSet` that contains those countries and then configure AWS WAF
#' to block the requests.
#' 
#' To create and configure a `GeoMatchSet`, perform the following steps:
#' 
#' 1.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_geo_match_set`][waf_create_geo_match_set] request.
#' 
#' 2.  Submit a [`create_geo_match_set`][waf_create_geo_match_set] request.
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_geo_match_set`][waf_update_geo_match_set] request.
#' 
#' 4.  Submit an `UpdateGeoMatchSetSet` request to specify the countries
#'     that you want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_geo_match_set(Name, ChangeToken)
#'
#' @param Name &#91;required&#93; A friendly name or description of the GeoMatchSet. You can't change
#' `Name` after you create the `GeoMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   GeoMatchSet = list(
#'     GeoMatchSetId = "string",
#'     Name = "string",
#'     GeoMatchConstraints = list(
#'       list(
#'         Type = "Country",
#'         Value = "AF"|"AX"|"AL"|"DZ"|"AS"|"AD"|"AO"|"AI"|"AQ"|"AG"|"AR"|"AM"|"AW"|"AU"|"AT"|"AZ"|"BS"|"BH"|"BD"|"BB"|"BY"|"BE"|"BZ"|"BJ"|"BM"|"BT"|"BO"|"BQ"|"BA"|"BW"|"BV"|"BR"|"IO"|"BN"|"BG"|"BF"|"BI"|"KH"|"CM"|"CA"|"CV"|"KY"|"CF"|"TD"|"CL"|"CN"|"CX"|"CC"|"CO"|"KM"|"CG"|"CD"|"CK"|"CR"|"CI"|"HR"|"CU"|"CW"|"CY"|"CZ"|"DK"|"DJ"|"DM"|"DO"|"EC"|"EG"|"SV"|"GQ"|"ER"|"EE"|"ET"|"FK"|"FO"|"FJ"|"FI"|"FR"|"GF"|"PF"|"TF"|"GA"|"GM"|"GE"|"DE"|"GH"|"GI"|"GR"|"GL"|"GD"|"GP"|"GU"|"GT"|"GG"|"GN"|"GW"|"GY"|"HT"|"HM"|"VA"|"HN"|"HK"|"HU"|"IS"|"IN"|"ID"|"IR"|"IQ"|"IE"|"IM"|"IL"|"IT"|"JM"|"JP"|"JE"|"JO"|"KZ"|"KE"|"KI"|"KP"|"KR"|"KW"|"KG"|"LA"|"LV"|"LB"|"LS"|"LR"|"LY"|"LI"|"LT"|"LU"|"MO"|"MK"|"MG"|"MW"|"MY"|"MV"|"ML"|"MT"|"MH"|"MQ"|"MR"|"MU"|"YT"|"MX"|"FM"|"MD"|"MC"|"MN"|"ME"|"MS"|"MA"|"MZ"|"MM"|"NA"|"NR"|"NP"|"NL"|"NC"|"NZ"|"NI"|"NE"|"NG"|"NU"|"NF"|"MP"|"NO"|"OM"|"PK"|"PW"|"PS"|"PA"|"PG"|"PY"|"PE"|"PH"|"PN"|"PL"|"PT"|"PR"|"QA"|"RE"|"RO"|"RU"|"RW"|"BL"|"SH"|"KN"|"LC"|"MF"|"PM"|"VC"|"WS"|"SM"|"ST"|"SA"|"SN"|"RS"|"SC"|"SL"|"SG"|"SX"|"SK"|"SI"|"SB"|"SO"|"ZA"|"GS"|"SS"|"ES"|"LK"|"SD"|"SR"|"SJ"|"SZ"|"SE"|"CH"|"SY"|"TW"|"TJ"|"TZ"|"TH"|"TL"|"TG"|"TK"|"TO"|"TT"|"TN"|"TR"|"TM"|"TC"|"TV"|"UG"|"UA"|"AE"|"GB"|"US"|"UM"|"UY"|"UZ"|"VU"|"VE"|"VN"|"VG"|"VI"|"WF"|"EH"|"YE"|"ZM"|"ZW"
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_geo_match_set(
#'   Name = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_create_geo_match_set
waf_create_geo_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateGeoMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_geo_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_geo_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_geo_match_set <- waf_create_geo_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates an IPSet, which you use to specify which web requests that you
#' want to allow or block based on the IP addresses that the requests
#' originate from. For example, if you're receiving a lot of requests from
#' one or more individual IP addresses or one or more ranges of IP
#' addresses and you want to block the requests, you can create an `IPSet`
#' that contains those IP addresses and then configure AWS WAF to block the
#' requests.
#' 
#' To create and configure an `IPSet`, perform the following steps:
#' 
#' 1.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_ip_set`][waf_create_ip_set] request.
#' 
#' 2.  Submit a [`create_ip_set`][waf_create_ip_set] request.
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_ip_set`][waf_update_ip_set] request.
#' 
#' 4.  Submit an [`update_ip_set`][waf_update_ip_set] request to specify
#'     the IP addresses that you want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_ip_set(Name, ChangeToken)
#'
#' @param Name &#91;required&#93; A friendly name or description of the IPSet. You can't change `Name`
#' after you create the `IPSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IPSet = list(
#'     IPSetId = "string",
#'     Name = "string",
#'     IPSetDescriptors = list(
#'       list(
#'         Type = "IPV4"|"IPV6",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_ip_set(
#'   Name = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates an IP match set named MyIPSetFriendlyName.
#' svc$create_ip_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   Name = "MyIPSetFriendlyName"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_create_ip_set
waf_create_ip_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateIPSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_ip_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_ip_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_ip_set <- waf_create_ip_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a RateBasedRule. The `RateBasedRule` contains a `RateLimit`,
#' which specifies the maximum number of requests that AWS WAF allows from
#' a specified IP address in a five-minute period. The `RateBasedRule` also
#' contains the `IPSet` objects, `ByteMatchSet` objects, and other
#' predicates that identify the requests that you want to count or block if
#' these requests exceed the `RateLimit`.
#' 
#' If you add more than one predicate to a `RateBasedRule`, a request not
#' only must exceed the `RateLimit`, but it also must match all the
#' conditions to be counted or blocked. For example, suppose you add the
#' following to a `RateBasedRule`:
#' 
#' -   An `IPSet` that matches the IP address `192.0.2.44/32`
#' 
#' -   A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
#' 
#' Further, you specify a `RateLimit` of 1,000.
#' 
#' You then add the `RateBasedRule` to a `WebACL` and specify that you want
#' to block requests that meet the conditions in the rule. For a request to
#' be blocked, it must come from the IP address 192.0.2.44 *and* the
#' `User-Agent` header in the request must contain the value `BadBot`.
#' Further, requests that match these two conditions must be received at a
#' rate of more than 1,000 requests every five minutes. If both conditions
#' are met and the rate is exceeded, AWS WAF blocks the requests. If the
#' rate drops below 1,000 for a five-minute period, AWS WAF no longer
#' blocks the requests.
#' 
#' As a second example, suppose you want to limit requests to a particular
#' page on your site. To do this, you could add the following to a
#' `RateBasedRule`:
#' 
#' -   A `ByteMatchSet` with `FieldToMatch` of `URI`
#' 
#' -   A `PositionalConstraint` of `STARTS_WITH`
#' 
#' -   A `TargetString` of `login`
#' 
#' Further, you specify a `RateLimit` of 1,000.
#' 
#' By adding this `RateBasedRule` to a `WebACL`, you could limit requests
#' to your login page without affecting the rest of your site.
#' 
#' To create and configure a `RateBasedRule`, perform the following steps:
#' 
#' 1.  Create and update the predicates that you want to include in the
#'     rule. For more information, see
#'     [`create_byte_match_set`][waf_create_byte_match_set],
#'     [`create_ip_set`][waf_create_ip_set], and
#'     [`create_sql_injection_match_set`][waf_create_sql_injection_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_rule`][waf_create_rule] request.
#' 
#' 3.  Submit a [`create_rate_based_rule`][waf_create_rate_based_rule]
#'     request.
#' 
#' 4.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_rule`][waf_update_rule] request.
#' 
#' 5.  Submit an [`update_rate_based_rule`][waf_update_rate_based_rule]
#'     request to specify the predicates that you want to include in the
#'     rule.
#' 
#' 6.  Create and update a `WebACL` that contains the `RateBasedRule`. For
#'     more information, see [`create_web_acl`][waf_create_web_acl].
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_rate_based_rule(Name, MetricName, RateKey, RateLimit,
#'   ChangeToken, Tags)
#'
#' @param Name &#91;required&#93; A friendly name or description of the RateBasedRule. You can't change
#' the name of a `RateBasedRule` after you create it.
#' @param MetricName &#91;required&#93; A friendly name or description for the metrics for this `RateBasedRule`.
#' The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
#' maximum length 128 and minimum length one. It can't contain whitespace
#' or metric names reserved for AWS WAF, including "All" and
#' "Default_Action." You can't change the name of the metric after you
#' create the `RateBasedRule`.
#' @param RateKey &#91;required&#93; The field that AWS WAF uses to determine if requests are likely arriving
#' from a single source and thus subject to rate monitoring. The only valid
#' value for `RateKey` is `IP`. `IP` indicates that requests that arrive
#' from the same IP address are subject to the `RateLimit` that is
#' specified in the `RateBasedRule`.
#' @param RateLimit &#91;required&#93; The maximum number of requests, which have an identical value in the
#' field that is specified by `RateKey`, allowed in a five-minute period.
#' If the number of requests exceeds the `RateLimit` and the other
#' predicates specified in the rule are also met, AWS WAF triggers the
#' action that is specified for this rule.
#' @param ChangeToken &#91;required&#93; The `ChangeToken` that you used to submit the
#' [`create_rate_based_rule`][waf_create_rate_based_rule] request. You can
#' also use this value to query the status of the request. For more
#' information, see
#' [`get_change_token_status`][waf_get_change_token_status].
#' @param Tags 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Rule = list(
#'     RuleId = "string",
#'     Name = "string",
#'     MetricName = "string",
#'     MatchPredicates = list(
#'       list(
#'         Negated = TRUE|FALSE,
#'         Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
#'         DataId = "string"
#'       )
#'     ),
#'     RateKey = "IP",
#'     RateLimit = 123
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_rate_based_rule(
#'   Name = "string",
#'   MetricName = "string",
#'   RateKey = "IP",
#'   RateLimit = 123,
#'   ChangeToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_create_rate_based_rule
waf_create_rate_based_rule <- function(Name, MetricName, RateKey, RateLimit, ChangeToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateRateBasedRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_rate_based_rule_input(Name = Name, MetricName = MetricName, RateKey = RateKey, RateLimit = RateLimit, ChangeToken = ChangeToken, Tags = Tags)
  output <- .waf$create_rate_based_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_rate_based_rule <- waf_create_rate_based_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a RegexMatchSet. You then use
#' [`update_regex_match_set`][waf_update_regex_match_set] to identify the
#' part of a web request that you want AWS WAF to inspect, such as the
#' values of the `User-Agent` header or the query string. For example, you
#' can create a `RegexMatchSet` that contains a `RegexMatchTuple` that
#' looks for any requests with `User-Agent` headers that match a
#' `RegexPatternSet` with pattern `B[a@@]dB[o0]t`. You can then configure
#' AWS WAF to reject those requests.
#' 
#' To create and configure a `RegexMatchSet`, perform the following steps:
#' 
#' 1.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_regex_match_set`][waf_create_regex_match_set] request.
#' 
#' 2.  Submit a [`create_regex_match_set`][waf_create_regex_match_set]
#'     request.
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_regex_match_set`][waf_update_regex_match_set] request.
#' 
#' 4.  Submit an [`update_regex_match_set`][waf_update_regex_match_set]
#'     request to specify the part of the request that you want AWS WAF to
#'     inspect (for example, the header or the URI) and the value, using a
#'     `RegexPatternSet`, that you want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_regex_match_set(Name, ChangeToken)
#'
#' @param Name &#91;required&#93; A friendly name or description of the RegexMatchSet. You can't change
#' `Name` after you create a `RegexMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegexMatchSet = list(
#'     RegexMatchSetId = "string",
#'     Name = "string",
#'     RegexMatchTuples = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         RegexPatternSetId = "string"
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_regex_match_set(
#'   Name = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_create_regex_match_set
waf_create_regex_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateRegexMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_regex_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_regex_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_regex_match_set <- waf_create_regex_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a `RegexPatternSet`. You then use
#' [`update_regex_pattern_set`][waf_update_regex_pattern_set] to specify
#' the regular expression (regex) pattern that you want AWS WAF to search
#' for, such as `B[a@@]dB[o0]t`. You can then configure AWS WAF to reject
#' those requests.
#' 
#' To create and configure a `RegexPatternSet`, perform the following
#' steps:
#' 
#' 1.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_regex_pattern_set`][waf_create_regex_pattern_set] request.
#' 
#' 2.  Submit a [`create_regex_pattern_set`][waf_create_regex_pattern_set]
#'     request.
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_regex_pattern_set`][waf_update_regex_pattern_set] request.
#' 
#' 4.  Submit an [`update_regex_pattern_set`][waf_update_regex_pattern_set]
#'     request to specify the string that you want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_regex_pattern_set(Name, ChangeToken)
#'
#' @param Name &#91;required&#93; A friendly name or description of the RegexPatternSet. You can't change
#' `Name` after you create a `RegexPatternSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegexPatternSet = list(
#'     RegexPatternSetId = "string",
#'     Name = "string",
#'     RegexPatternStrings = list(
#'       "string"
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_regex_pattern_set(
#'   Name = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_create_regex_pattern_set
waf_create_regex_pattern_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_regex_pattern_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_regex_pattern_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_regex_pattern_set <- waf_create_regex_pattern_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a `Rule`, which contains the `IPSet` objects, `ByteMatchSet`
#' objects, and other predicates that identify the requests that you want
#' to block. If you add more than one predicate to a `Rule`, a request must
#' match all of the specifications to be allowed or blocked. For example,
#' suppose that you add the following to a `Rule`:
#' 
#' -   An `IPSet` that matches the IP address `192.0.2.44/32`
#' 
#' -   A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
#' 
#' You then add the `Rule` to a `WebACL` and specify that you want to
#' blocks requests that satisfy the `Rule`. For a request to be blocked, it
#' must come from the IP address 192.0.2.44 *and* the `User-Agent` header
#' in the request must contain the value `BadBot`.
#' 
#' To create and configure a `Rule`, perform the following steps:
#' 
#' 1.  Create and update the predicates that you want to include in the
#'     `Rule`. For more information, see
#'     [`create_byte_match_set`][waf_create_byte_match_set],
#'     [`create_ip_set`][waf_create_ip_set], and
#'     [`create_sql_injection_match_set`][waf_create_sql_injection_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_rule`][waf_create_rule] request.
#' 
#' 3.  Submit a [`create_rule`][waf_create_rule] request.
#' 
#' 4.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_rule`][waf_update_rule] request.
#' 
#' 5.  Submit an [`update_rule`][waf_update_rule] request to specify the
#'     predicates that you want to include in the `Rule`.
#' 
#' 6.  Create and update a `WebACL` that contains the `Rule`. For more
#'     information, see [`create_web_acl`][waf_create_web_acl].
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_rule(Name, MetricName, ChangeToken, Tags)
#'
#' @param Name &#91;required&#93; A friendly name or description of the Rule. You can't change the name of
#' a `Rule` after you create it.
#' @param MetricName &#91;required&#93; A friendly name or description for the metrics for this `Rule`. The name
#' can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum
#' length 128 and minimum length one. It can't contain whitespace or metric
#' names reserved for AWS WAF, including "All" and "Default_Action." You
#' can't change the name of the metric after you create the `Rule`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Tags 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Rule = list(
#'     RuleId = "string",
#'     Name = "string",
#'     MetricName = "string",
#'     Predicates = list(
#'       list(
#'         Negated = TRUE|FALSE,
#'         Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
#'         DataId = "string"
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_rule(
#'   Name = "string",
#'   MetricName = "string",
#'   ChangeToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates a rule named WAFByteHeaderRule.
#' svc$create_rule(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   MetricName = "WAFByteHeaderRule",
#'   Name = "WAFByteHeaderRule"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_create_rule
waf_create_rule <- function(Name, MetricName, ChangeToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_rule_input(Name = Name, MetricName = MetricName, ChangeToken = ChangeToken, Tags = Tags)
  output <- .waf$create_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_rule <- waf_create_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a `RuleGroup`. A rule group is a collection of predefined rules
#' that you add to a web ACL. You use
#' [`update_rule_group`][waf_update_rule_group] to add rules to the rule
#' group.
#' 
#' Rule groups are subject to the following limits:
#' 
#' -   Three rule groups per account. You can request an increase to this
#'     limit by contacting customer support.
#' 
#' -   One rule group per web ACL.
#' 
#' -   Ten rules per rule group.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_rule_group(Name, MetricName, ChangeToken, Tags)
#'
#' @param Name &#91;required&#93; A friendly name or description of the RuleGroup. You can't change `Name`
#' after you create a `RuleGroup`.
#' @param MetricName &#91;required&#93; A friendly name or description for the metrics for this `RuleGroup`. The
#' name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
#' maximum length 128 and minimum length one. It can't contain whitespace
#' or metric names reserved for AWS WAF, including "All" and
#' "Default_Action." You can't change the name of the metric after you
#' create the `RuleGroup`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Tags 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RuleGroup = list(
#'     RuleGroupId = "string",
#'     Name = "string",
#'     MetricName = "string"
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_rule_group(
#'   Name = "string",
#'   MetricName = "string",
#'   ChangeToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_create_rule_group
waf_create_rule_group <- function(Name, MetricName, ChangeToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_rule_group_input(Name = Name, MetricName = MetricName, ChangeToken = ChangeToken, Tags = Tags)
  output <- .waf$create_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_rule_group <- waf_create_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a `SizeConstraintSet`. You then use
#' [`update_size_constraint_set`][waf_update_size_constraint_set] to
#' identify the part of a web request that you want AWS WAF to check for
#' length, such as the length of the `User-Agent` header or the length of
#' the query string. For example, you can create a `SizeConstraintSet` that
#' matches any requests that have a query string that is longer than 100
#' bytes. You can then configure AWS WAF to reject those requests.
#' 
#' To create and configure a `SizeConstraintSet`, perform the following
#' steps:
#' 
#' 1.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_size_constraint_set`][waf_create_size_constraint_set]
#'     request.
#' 
#' 2.  Submit a
#'     [`create_size_constraint_set`][waf_create_size_constraint_set]
#'     request.
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_size_constraint_set`][waf_update_size_constraint_set]
#'     request.
#' 
#' 4.  Submit an
#'     [`update_size_constraint_set`][waf_update_size_constraint_set]
#'     request to specify the part of the request that you want AWS WAF to
#'     inspect (for example, the header or the URI) and the value that you
#'     want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_size_constraint_set(Name, ChangeToken)
#'
#' @param Name &#91;required&#93; A friendly name or description of the SizeConstraintSet. You can't
#' change `Name` after you create a `SizeConstraintSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SizeConstraintSet = list(
#'     SizeConstraintSetId = "string",
#'     Name = "string",
#'     SizeConstraints = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         ComparisonOperator = "EQ"|"NE"|"LE"|"LT"|"GE"|"GT",
#'         Size = 123
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_size_constraint_set(
#'   Name = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates size constraint set named
#' # MySampleSizeConstraintSet.
#' svc$create_size_constraint_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   Name = "MySampleSizeConstraintSet"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_create_size_constraint_set
waf_create_size_constraint_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateSizeConstraintSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_size_constraint_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_size_constraint_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_size_constraint_set <- waf_create_size_constraint_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a SqlInjectionMatchSet, which you use to allow, block, or count
#' requests that contain snippets of SQL code in a specified part of web
#' requests. AWS WAF searches for character sequences that are likely to be
#' malicious strings.
#' 
#' To create and configure a `SqlInjectionMatchSet`, perform the following
#' steps:
#' 
#' 1.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#'     request.
#' 
#' 2.  Submit a
#'     [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#'     request.
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_sql_injection_match_set`][waf_update_sql_injection_match_set]
#'     request.
#' 
#' 4.  Submit an
#'     [`update_sql_injection_match_set`][waf_update_sql_injection_match_set]
#'     request to specify the parts of web requests in which you want to
#'     allow, block, or count malicious SQL code.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_sql_injection_match_set(Name, ChangeToken)
#'
#' @param Name &#91;required&#93; A friendly name or description for the SqlInjectionMatchSet that you're
#' creating. You can't change `Name` after you create the
#' `SqlInjectionMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SqlInjectionMatchSet = list(
#'     SqlInjectionMatchSetId = "string",
#'     Name = "string",
#'     SqlInjectionMatchTuples = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_sql_injection_match_set(
#'   Name = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates a SQL injection match set named
#' # MySQLInjectionMatchSet.
#' svc$create_sql_injection_match_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   Name = "MySQLInjectionMatchSet"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_create_sql_injection_match_set
waf_create_sql_injection_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateSqlInjectionMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_sql_injection_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_sql_injection_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_sql_injection_match_set <- waf_create_sql_injection_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates a `WebACL`, which contains the `Rules` that identify the
#' CloudFront web requests that you want to allow, block, or count. AWS WAF
#' evaluates `Rules` in order based on the value of `Priority` for each
#' `Rule`.
#' 
#' You also specify a default action, either `ALLOW` or `BLOCK`. If a web
#' request doesn't match any of the `Rules` in a `WebACL`, AWS WAF responds
#' to the request with the default action.
#' 
#' To create and configure a `WebACL`, perform the following steps:
#' 
#' 1.  Create and update the `ByteMatchSet` objects and other predicates
#'     that you want to include in `Rules`. For more information, see
#'     [`create_byte_match_set`][waf_create_byte_match_set],
#'     [`update_byte_match_set`][waf_update_byte_match_set],
#'     [`create_ip_set`][waf_create_ip_set],
#'     [`update_ip_set`][waf_update_ip_set],
#'     [`create_sql_injection_match_set`][waf_create_sql_injection_match_set],
#'     and
#'     [`update_sql_injection_match_set`][waf_update_sql_injection_match_set].
#' 
#' 2.  Create and update the `Rules` that you want to include in the
#'     `WebACL`. For more information, see [`create_rule`][waf_create_rule]
#'     and [`update_rule`][waf_update_rule].
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_web_acl`][waf_create_web_acl] request.
#' 
#' 4.  Submit a [`create_web_acl`][waf_create_web_acl] request.
#' 
#' 5.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_web_acl`][waf_update_web_acl] request.
#' 
#' 6.  Submit an [`update_web_acl`][waf_update_web_acl] request to specify
#'     the `Rules` that you want to include in the `WebACL`, to specify the
#'     default action, and to associate the `WebACL` with a CloudFront
#'     distribution.
#' 
#' For more information about how to use the AWS WAF API, see the [AWS WAF
#' Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_web_acl(Name, MetricName, DefaultAction, ChangeToken, Tags)
#'
#' @param Name &#91;required&#93; A friendly name or description of the WebACL. You can't change `Name`
#' after you create the `WebACL`.
#' @param MetricName &#91;required&#93; A friendly name or description for the metrics for this `WebACL`.The
#' name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
#' maximum length 128 and minimum length one. It can't contain whitespace
#' or metric names reserved for AWS WAF, including "All" and
#' "Default_Action." You can't change `MetricName` after you create the
#' `WebACL`.
#' @param DefaultAction &#91;required&#93; The action that you want AWS WAF to take when a request doesn't match
#' the criteria specified in any of the `Rule` objects that are associated
#' with the `WebACL`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Tags 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   WebACL = list(
#'     WebACLId = "string",
#'     Name = "string",
#'     MetricName = "string",
#'     DefaultAction = list(
#'       Type = "BLOCK"|"ALLOW"|"COUNT"
#'     ),
#'     Rules = list(
#'       list(
#'         Priority = 123,
#'         RuleId = "string",
#'         Action = list(
#'           Type = "BLOCK"|"ALLOW"|"COUNT"
#'         ),
#'         OverrideAction = list(
#'           Type = "NONE"|"COUNT"
#'         ),
#'         Type = "REGULAR"|"RATE_BASED"|"GROUP",
#'         ExcludedRules = list(
#'           list(
#'             RuleId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     WebACLArn = "string"
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_web_acl(
#'   Name = "string",
#'   MetricName = "string",
#'   DefaultAction = list(
#'     Type = "BLOCK"|"ALLOW"|"COUNT"
#'   ),
#'   ChangeToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates a web ACL named CreateExample.
#' svc$create_web_acl(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   DefaultAction = list(
#'     Type = "ALLOW"
#'   ),
#'   MetricName = "CreateExample",
#'   Name = "CreateExample"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_create_web_acl
waf_create_web_acl <- function(Name, MetricName, DefaultAction, ChangeToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateWebACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_web_acl_input(Name = Name, MetricName = MetricName, DefaultAction = DefaultAction, ChangeToken = ChangeToken, Tags = Tags)
  output <- .waf$create_web_acl_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_web_acl <- waf_create_web_acl

#' Creates an AWS CloudFormation WAFV2 template for the specified web ACL
#' in the specified Amazon S3 bucket
#'
#' @description
#' Creates an AWS CloudFormation WAFV2 template for the specified web ACL
#' in the specified Amazon S3 bucket. Then, in CloudFormation, you create a
#' stack from the template, to create the web ACL and its resources in AWS
#' WAFV2. Use this to migrate your AWS WAF Classic web ACL to the latest
#' version of AWS WAF.
#' 
#' This is part of a larger migration procedure for web ACLs from AWS WAF
#' Classic to the latest version of AWS WAF. For the full procedure,
#' including caveats and manual steps to complete the migration and switch
#' over to the new web ACL, see [Migrating your AWS WAF Classic resources
#' to AWS
#' WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-migrating-from-classic.html)
#' in the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#'
#' @usage
#' waf_create_web_acl_migration_stack(WebACLId, S3BucketName,
#'   IgnoreUnsupportedType)
#'
#' @param WebACLId &#91;required&#93; The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.
#' @param S3BucketName &#91;required&#93; The name of the Amazon S3 bucket to store the CloudFormation template
#' in. The S3 bucket must be configured as follows for the migration:
#' 
#' -   The bucket name must start with `aws-waf-migration-`. For example,
#'     `aws-waf-migration-my-web-acl`.
#' 
#' -   The bucket must be in the Region where you are deploying the
#'     template. For example, for a web ACL in us-west-2, you must use an
#'     Amazon S3 bucket in us-west-2 and you must deploy the template stack
#'     to us-west-2.
#' 
#' -   The bucket policies must permit the migration process to write data.
#'     For listings of the bucket policies, see the Examples section.
#' @param IgnoreUnsupportedType &#91;required&#93; Indicates whether to exclude entities that can't be migrated or to stop
#' the migration. Set this to true to ignore unsupported entities in the
#' web ACL during the migration. Otherwise, if AWS WAF encounters
#' unsupported entities, it stops the process and throws an exception.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   S3ObjectUrl = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_web_acl_migration_stack(
#'   WebACLId = "string",
#'   S3BucketName = "string",
#'   IgnoreUnsupportedType = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_create_web_acl_migration_stack
waf_create_web_acl_migration_stack <- function(WebACLId, S3BucketName, IgnoreUnsupportedType) {
  op <- new_operation(
    name = "CreateWebACLMigrationStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_web_acl_migration_stack_input(WebACLId = WebACLId, S3BucketName = S3BucketName, IgnoreUnsupportedType = IgnoreUnsupportedType)
  output <- .waf$create_web_acl_migration_stack_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_web_acl_migration_stack <- waf_create_web_acl_migration_stack

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Creates an XssMatchSet, which you use to allow, block, or count requests
#' that contain cross-site scripting attacks in the specified part of web
#' requests. AWS WAF searches for character sequences that are likely to be
#' malicious strings.
#' 
#' To create and configure an `XssMatchSet`, perform the following steps:
#' 
#' 1.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`create_xss_match_set`][waf_create_xss_match_set] request.
#' 
#' 2.  Submit a [`create_xss_match_set`][waf_create_xss_match_set] request.
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_xss_match_set`][waf_update_xss_match_set] request.
#' 
#' 4.  Submit an [`update_xss_match_set`][waf_update_xss_match_set] request
#'     to specify the parts of web requests in which you want to allow,
#'     block, or count cross-site scripting attacks.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_create_xss_match_set(Name, ChangeToken)
#'
#' @param Name &#91;required&#93; A friendly name or description for the XssMatchSet that you're creating.
#' You can't change `Name` after you create the `XssMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   XssMatchSet = list(
#'     XssMatchSetId = "string",
#'     Name = "string",
#'     XssMatchTuples = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_xss_match_set(
#'   Name = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates an XSS match set named
#' # MySampleXssMatchSet.
#' svc$create_xss_match_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   Name = "MySampleXssMatchSet"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_create_xss_match_set
waf_create_xss_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateXssMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_xss_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_xss_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_xss_match_set <- waf_create_xss_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a ByteMatchSet. You can't delete a `ByteMatchSet` if
#' it's still used in any `Rules` or if it still includes any
#' ByteMatchTuple objects (any filters).
#' 
#' If you just want to remove a `ByteMatchSet` from a `Rule`, use
#' [`update_rule`][waf_update_rule].
#' 
#' To permanently delete a `ByteMatchSet`, perform the following steps:
#' 
#' 1.  Update the `ByteMatchSet` to remove filters, if any. For more
#'     information, see
#'     [`update_byte_match_set`][waf_update_byte_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_byte_match_set`][waf_delete_byte_match_set] request.
#' 
#' 3.  Submit a [`delete_byte_match_set`][waf_delete_byte_match_set]
#'     request.
#'
#' @usage
#' waf_delete_byte_match_set(ByteMatchSetId, ChangeToken)
#'
#' @param ByteMatchSetId &#91;required&#93; The `ByteMatchSetId` of the ByteMatchSet that you want to delete.
#' `ByteMatchSetId` is returned by
#' [`create_byte_match_set`][waf_create_byte_match_set] and by
#' [`list_byte_match_sets`][waf_list_byte_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_byte_match_set(
#'   ByteMatchSetId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a byte match set with the ID
#' # exampleIDs3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$delete_byte_match_set(
#'   ByteMatchSetId = "exampleIDs3t-46da-4fdb-b8d5-abc321j569j5",
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_delete_byte_match_set
waf_delete_byte_match_set <- function(ByteMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteByteMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_byte_match_set_input(ByteMatchSetId = ByteMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_byte_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_byte_match_set <- waf_delete_byte_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a GeoMatchSet. You can't delete a `GeoMatchSet` if
#' it's still used in any `Rules` or if it still includes any countries.
#' 
#' If you just want to remove a `GeoMatchSet` from a `Rule`, use
#' [`update_rule`][waf_update_rule].
#' 
#' To permanently delete a `GeoMatchSet` from AWS WAF, perform the
#' following steps:
#' 
#' 1.  Update the `GeoMatchSet` to remove any countries. For more
#'     information, see [`update_geo_match_set`][waf_update_geo_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_geo_match_set`][waf_delete_geo_match_set] request.
#' 
#' 3.  Submit a [`delete_geo_match_set`][waf_delete_geo_match_set] request.
#'
#' @usage
#' waf_delete_geo_match_set(GeoMatchSetId, ChangeToken)
#'
#' @param GeoMatchSetId &#91;required&#93; The `GeoMatchSetID` of the GeoMatchSet that you want to delete.
#' `GeoMatchSetId` is returned by
#' [`create_geo_match_set`][waf_create_geo_match_set] and by
#' [`list_geo_match_sets`][waf_list_geo_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_geo_match_set(
#'   GeoMatchSetId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_delete_geo_match_set
waf_delete_geo_match_set <- function(GeoMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteGeoMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_geo_match_set_input(GeoMatchSetId = GeoMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_geo_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_geo_match_set <- waf_delete_geo_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes an IPSet. You can't delete an `IPSet` if it's still
#' used in any `Rules` or if it still includes any IP addresses.
#' 
#' If you just want to remove an `IPSet` from a `Rule`, use
#' [`update_rule`][waf_update_rule].
#' 
#' To permanently delete an `IPSet` from AWS WAF, perform the following
#' steps:
#' 
#' 1.  Update the `IPSet` to remove IP address ranges, if any. For more
#'     information, see [`update_ip_set`][waf_update_ip_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_ip_set`][waf_delete_ip_set] request.
#' 
#' 3.  Submit a [`delete_ip_set`][waf_delete_ip_set] request.
#'
#' @usage
#' waf_delete_ip_set(IPSetId, ChangeToken)
#'
#' @param IPSetId &#91;required&#93; The `IPSetId` of the IPSet that you want to delete. `IPSetId` is
#' returned by [`create_ip_set`][waf_create_ip_set] and by
#' [`list_ip_sets`][waf_list_ip_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_ip_set(
#'   IPSetId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes an IP match set  with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$delete_ip_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   IPSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_delete_ip_set
waf_delete_ip_set <- function(IPSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteIPSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_ip_set_input(IPSetId = IPSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_ip_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_ip_set <- waf_delete_ip_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes the LoggingConfiguration from the specified web ACL.
#'
#' @usage
#' waf_delete_logging_configuration(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL from which you want to
#' delete the LoggingConfiguration.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_logging_configuration(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_delete_logging_configuration
waf_delete_logging_configuration <- function(ResourceArn) {
  op <- new_operation(
    name = "DeleteLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_logging_configuration_input(ResourceArn = ResourceArn)
  output <- .waf$delete_logging_configuration_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_logging_configuration <- waf_delete_logging_configuration

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes an IAM policy from the specified RuleGroup.
#' 
#' The user making the request must be the owner of the RuleGroup.
#'
#' @usage
#' waf_delete_permission_policy(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the RuleGroup from which you want to
#' delete the policy.
#' 
#' The user making the request must be the owner of the RuleGroup.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_permission_policy(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_delete_permission_policy
waf_delete_permission_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeletePermissionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_permission_policy_input(ResourceArn = ResourceArn)
  output <- .waf$delete_permission_policy_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_permission_policy <- waf_delete_permission_policy

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a RateBasedRule. You can't delete a rule if it's
#' still used in any `WebACL` objects or if it still includes any
#' predicates, such as `ByteMatchSet` objects.
#' 
#' If you just want to remove a rule from a `WebACL`, use
#' [`update_web_acl`][waf_update_web_acl].
#' 
#' To permanently delete a `RateBasedRule` from AWS WAF, perform the
#' following steps:
#' 
#' 1.  Update the `RateBasedRule` to remove predicates, if any. For more
#'     information, see
#'     [`update_rate_based_rule`][waf_update_rate_based_rule].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_rate_based_rule`][waf_delete_rate_based_rule] request.
#' 
#' 3.  Submit a [`delete_rate_based_rule`][waf_delete_rate_based_rule]
#'     request.
#'
#' @usage
#' waf_delete_rate_based_rule(RuleId, ChangeToken)
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the RateBasedRule that you want to delete. `RuleId` is
#' returned by [`create_rate_based_rule`][waf_create_rate_based_rule] and
#' by [`list_rate_based_rules`][waf_list_rate_based_rules].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_rate_based_rule(
#'   RuleId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_delete_rate_based_rule
waf_delete_rate_based_rule <- function(RuleId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRateBasedRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_rate_based_rule_input(RuleId = RuleId, ChangeToken = ChangeToken)
  output <- .waf$delete_rate_based_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_rate_based_rule <- waf_delete_rate_based_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a RegexMatchSet. You can't delete a `RegexMatchSet`
#' if it's still used in any `Rules` or if it still includes any
#' `RegexMatchTuples` objects (any filters).
#' 
#' If you just want to remove a `RegexMatchSet` from a `Rule`, use
#' [`update_rule`][waf_update_rule].
#' 
#' To permanently delete a `RegexMatchSet`, perform the following steps:
#' 
#' 1.  Update the `RegexMatchSet` to remove filters, if any. For more
#'     information, see
#'     [`update_regex_match_set`][waf_update_regex_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_regex_match_set`][waf_delete_regex_match_set] request.
#' 
#' 3.  Submit a [`delete_regex_match_set`][waf_delete_regex_match_set]
#'     request.
#'
#' @usage
#' waf_delete_regex_match_set(RegexMatchSetId, ChangeToken)
#'
#' @param RegexMatchSetId &#91;required&#93; The `RegexMatchSetId` of the RegexMatchSet that you want to delete.
#' `RegexMatchSetId` is returned by
#' [`create_regex_match_set`][waf_create_regex_match_set] and by
#' [`list_regex_match_sets`][waf_list_regex_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_regex_match_set(
#'   RegexMatchSetId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_delete_regex_match_set
waf_delete_regex_match_set <- function(RegexMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRegexMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_regex_match_set_input(RegexMatchSetId = RegexMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_regex_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_regex_match_set <- waf_delete_regex_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a RegexPatternSet. You can't delete a
#' `RegexPatternSet` if it's still used in any `RegexMatchSet` or if the
#' `RegexPatternSet` is not empty.
#'
#' @usage
#' waf_delete_regex_pattern_set(RegexPatternSetId, ChangeToken)
#'
#' @param RegexPatternSetId &#91;required&#93; The `RegexPatternSetId` of the RegexPatternSet that you want to delete.
#' `RegexPatternSetId` is returned by
#' [`create_regex_pattern_set`][waf_create_regex_pattern_set] and by
#' [`list_regex_pattern_sets`][waf_list_regex_pattern_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_regex_pattern_set(
#'   RegexPatternSetId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_delete_regex_pattern_set
waf_delete_regex_pattern_set <- function(RegexPatternSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_regex_pattern_set_input(RegexPatternSetId = RegexPatternSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_regex_pattern_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_regex_pattern_set <- waf_delete_regex_pattern_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a Rule. You can't delete a `Rule` if it's still used
#' in any `WebACL` objects or if it still includes any predicates, such as
#' `ByteMatchSet` objects.
#' 
#' If you just want to remove a `Rule` from a `WebACL`, use
#' [`update_web_acl`][waf_update_web_acl].
#' 
#' To permanently delete a `Rule` from AWS WAF, perform the following
#' steps:
#' 
#' 1.  Update the `Rule` to remove predicates, if any. For more
#'     information, see [`update_rule`][waf_update_rule].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_rule`][waf_delete_rule] request.
#' 
#' 3.  Submit a [`delete_rule`][waf_delete_rule] request.
#'
#' @usage
#' waf_delete_rule(RuleId, ChangeToken)
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the Rule that you want to delete. `RuleId` is returned
#' by [`create_rule`][waf_create_rule] and by
#' [`list_rules`][waf_list_rules].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_rule(
#'   RuleId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a rule with the ID WAFRule-1-Example.
#' svc$delete_rule(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   RuleId = "WAFRule-1-Example"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_delete_rule
waf_delete_rule <- function(RuleId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_rule_input(RuleId = RuleId, ChangeToken = ChangeToken)
  output <- .waf$delete_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_rule <- waf_delete_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a RuleGroup. You can't delete a `RuleGroup` if it's
#' still used in any `WebACL` objects or if it still includes any rules.
#' 
#' If you just want to remove a `RuleGroup` from a `WebACL`, use
#' [`update_web_acl`][waf_update_web_acl].
#' 
#' To permanently delete a `RuleGroup` from AWS WAF, perform the following
#' steps:
#' 
#' 1.  Update the `RuleGroup` to remove rules, if any. For more
#'     information, see [`update_rule_group`][waf_update_rule_group].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_rule_group`][waf_delete_rule_group] request.
#' 
#' 3.  Submit a [`delete_rule_group`][waf_delete_rule_group] request.
#'
#' @usage
#' waf_delete_rule_group(RuleGroupId, ChangeToken)
#'
#' @param RuleGroupId &#91;required&#93; The `RuleGroupId` of the RuleGroup that you want to delete.
#' `RuleGroupId` is returned by
#' [`create_rule_group`][waf_create_rule_group] and by
#' [`list_rule_groups`][waf_list_rule_groups].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_rule_group(
#'   RuleGroupId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_delete_rule_group
waf_delete_rule_group <- function(RuleGroupId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_rule_group_input(RuleGroupId = RuleGroupId, ChangeToken = ChangeToken)
  output <- .waf$delete_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_rule_group <- waf_delete_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a SizeConstraintSet. You can't delete a
#' `SizeConstraintSet` if it's still used in any `Rules` or if it still
#' includes any SizeConstraint objects (any filters).
#' 
#' If you just want to remove a `SizeConstraintSet` from a `Rule`, use
#' [`update_rule`][waf_update_rule].
#' 
#' To permanently delete a `SizeConstraintSet`, perform the following
#' steps:
#' 
#' 1.  Update the `SizeConstraintSet` to remove filters, if any. For more
#'     information, see
#'     [`update_size_constraint_set`][waf_update_size_constraint_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_size_constraint_set`][waf_delete_size_constraint_set]
#'     request.
#' 
#' 3.  Submit a
#'     [`delete_size_constraint_set`][waf_delete_size_constraint_set]
#'     request.
#'
#' @usage
#' waf_delete_size_constraint_set(SizeConstraintSetId, ChangeToken)
#'
#' @param SizeConstraintSetId &#91;required&#93; The `SizeConstraintSetId` of the SizeConstraintSet that you want to
#' delete. `SizeConstraintSetId` is returned by
#' [`create_size_constraint_set`][waf_create_size_constraint_set] and by
#' [`list_size_constraint_sets`][waf_list_size_constraint_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_size_constraint_set(
#'   SizeConstraintSetId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a size constraint set  with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$delete_size_constraint_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   SizeConstraintSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_delete_size_constraint_set
waf_delete_size_constraint_set <- function(SizeConstraintSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteSizeConstraintSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_size_constraint_set_input(SizeConstraintSetId = SizeConstraintSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_size_constraint_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_size_constraint_set <- waf_delete_size_constraint_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a SqlInjectionMatchSet. You can't delete a
#' `SqlInjectionMatchSet` if it's still used in any `Rules` or if it still
#' contains any SqlInjectionMatchTuple objects.
#' 
#' If you just want to remove a `SqlInjectionMatchSet` from a `Rule`, use
#' [`update_rule`][waf_update_rule].
#' 
#' To permanently delete a `SqlInjectionMatchSet` from AWS WAF, perform the
#' following steps:
#' 
#' 1.  Update the `SqlInjectionMatchSet` to remove filters, if any. For
#'     more information, see
#'     [`update_sql_injection_match_set`][waf_update_sql_injection_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_sql_injection_match_set`][waf_delete_sql_injection_match_set]
#'     request.
#' 
#' 3.  Submit a
#'     [`delete_sql_injection_match_set`][waf_delete_sql_injection_match_set]
#'     request.
#'
#' @usage
#' waf_delete_sql_injection_match_set(SqlInjectionMatchSetId, ChangeToken)
#'
#' @param SqlInjectionMatchSetId &#91;required&#93; The `SqlInjectionMatchSetId` of the SqlInjectionMatchSet that you want
#' to delete. `SqlInjectionMatchSetId` is returned by
#' [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#' and by
#' [`list_sql_injection_match_sets`][waf_list_sql_injection_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_sql_injection_match_set(
#'   SqlInjectionMatchSetId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a SQL injection match set  with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$delete_sql_injection_match_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   SqlInjectionMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_delete_sql_injection_match_set
waf_delete_sql_injection_match_set <- function(SqlInjectionMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteSqlInjectionMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_sql_injection_match_set_input(SqlInjectionMatchSetId = SqlInjectionMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_sql_injection_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_sql_injection_match_set <- waf_delete_sql_injection_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes a WebACL. You can't delete a `WebACL` if it still
#' contains any `Rules`.
#' 
#' To delete a `WebACL`, perform the following steps:
#' 
#' 1.  Update the `WebACL` to remove `Rules`, if any. For more information,
#'     see [`update_web_acl`][waf_update_web_acl].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_web_acl`][waf_delete_web_acl] request.
#' 
#' 3.  Submit a [`delete_web_acl`][waf_delete_web_acl] request.
#'
#' @usage
#' waf_delete_web_acl(WebACLId, ChangeToken)
#'
#' @param WebACLId &#91;required&#93; The `WebACLId` of the WebACL that you want to delete. `WebACLId` is
#' returned by [`create_web_acl`][waf_create_web_acl] and by
#' [`list_web_ac_ls`][waf_list_web_ac_ls].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_web_acl(
#'   WebACLId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a web ACL with the ID
#' # example-46da-4444-5555-example.
#' svc$delete_web_acl(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   WebACLId = "example-46da-4444-5555-example"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_delete_web_acl
waf_delete_web_acl <- function(WebACLId, ChangeToken) {
  op <- new_operation(
    name = "DeleteWebACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_web_acl_input(WebACLId = WebACLId, ChangeToken = ChangeToken)
  output <- .waf$delete_web_acl_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_web_acl <- waf_delete_web_acl

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Permanently deletes an XssMatchSet. You can't delete an `XssMatchSet` if
#' it's still used in any `Rules` or if it still contains any XssMatchTuple
#' objects.
#' 
#' If you just want to remove an `XssMatchSet` from a `Rule`, use
#' [`update_rule`][waf_update_rule].
#' 
#' To permanently delete an `XssMatchSet` from AWS WAF, perform the
#' following steps:
#' 
#' 1.  Update the `XssMatchSet` to remove filters, if any. For more
#'     information, see [`update_xss_match_set`][waf_update_xss_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of a
#'     [`delete_xss_match_set`][waf_delete_xss_match_set] request.
#' 
#' 3.  Submit a [`delete_xss_match_set`][waf_delete_xss_match_set] request.
#'
#' @usage
#' waf_delete_xss_match_set(XssMatchSetId, ChangeToken)
#'
#' @param XssMatchSetId &#91;required&#93; The `XssMatchSetId` of the XssMatchSet that you want to delete.
#' `XssMatchSetId` is returned by
#' [`create_xss_match_set`][waf_create_xss_match_set] and by
#' [`list_xss_match_sets`][waf_list_xss_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_xss_match_set(
#'   XssMatchSetId = "string",
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes an XSS match set with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$delete_xss_match_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   XssMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_delete_xss_match_set
waf_delete_xss_match_set <- function(XssMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteXssMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_xss_match_set_input(XssMatchSetId = XssMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_xss_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_xss_match_set <- waf_delete_xss_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the ByteMatchSet specified by `ByteMatchSetId`.
#'
#' @usage
#' waf_get_byte_match_set(ByteMatchSetId)
#'
#' @param ByteMatchSetId &#91;required&#93; The `ByteMatchSetId` of the ByteMatchSet that you want to get.
#' `ByteMatchSetId` is returned by
#' [`create_byte_match_set`][waf_create_byte_match_set] and by
#' [`list_byte_match_sets`][waf_list_byte_match_sets].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ByteMatchSet = list(
#'     ByteMatchSetId = "string",
#'     Name = "string",
#'     ByteMatchTuples = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TargetString = raw,
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         PositionalConstraint = "EXACTLY"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CONTAINS_WORD"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_byte_match_set(
#'   ByteMatchSetId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns the details of a byte match set with the
#' # ID exampleIDs3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$get_byte_match_set(
#'   ByteMatchSetId = "exampleIDs3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_byte_match_set
waf_get_byte_match_set <- function(ByteMatchSetId) {
  op <- new_operation(
    name = "GetByteMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_byte_match_set_input(ByteMatchSetId = ByteMatchSetId)
  output <- .waf$get_byte_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_byte_match_set <- waf_get_byte_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' When you want to create, update, or delete AWS WAF objects, get a change
#' token and include the change token in the create, update, or delete
#' request. Change tokens ensure that your application doesn't submit
#' conflicting requests to AWS WAF.
#' 
#' Each create, update, or delete request must use a unique change token.
#' If your application submits a [`get_change_token`][waf_get_change_token]
#' request and then submits a second
#' [`get_change_token`][waf_get_change_token] request before submitting a
#' create, update, or delete request, the second
#' [`get_change_token`][waf_get_change_token] request returns the same
#' value as the first [`get_change_token`][waf_get_change_token] request.
#' 
#' When you use a change token in a create, update, or delete request, the
#' status of the change token changes to `PENDING`, which indicates that
#' AWS WAF is propagating the change to all AWS WAF servers. Use
#' [`get_change_token_status`][waf_get_change_token_status] to determine
#' the status of your change token.
#'
#' @usage
#' waf_get_change_token()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_change_token()
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns a change token to use for a create, update
#' # or delete operation.
#' svc$get_change_token()
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_change_token
waf_get_change_token <- function() {
  op <- new_operation(
    name = "GetChangeToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_change_token_input()
  output <- .waf$get_change_token_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_change_token <- waf_get_change_token

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the status of a `ChangeToken` that you got by calling
#' [`get_change_token`][waf_get_change_token]. `ChangeTokenStatus` is one
#' of the following values:
#' 
#' -   `PROVISIONED`: You requested the change token by calling
#'     [`get_change_token`][waf_get_change_token], but you haven't used it
#'     yet in a call to create, update, or delete an AWS WAF object.
#' 
#' -   `PENDING`: AWS WAF is propagating the create, update, or delete
#'     request to all AWS WAF servers.
#' 
#' -   `INSYNC`: Propagation is complete.
#'
#' @usage
#' waf_get_change_token_status(ChangeToken)
#'
#' @param ChangeToken &#91;required&#93; The change token for which you want to get the status. This change token
#' was previously returned in the
#' [`get_change_token`][waf_get_change_token] response.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeTokenStatus = "PROVISIONED"|"PENDING"|"INSYNC"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_change_token_status(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns the status of a change token with the ID
#' # abcd12f2-46da-4fdb-b8d5-fbd4c466928f.
#' svc$get_change_token_status(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_change_token_status
waf_get_change_token_status <- function(ChangeToken) {
  op <- new_operation(
    name = "GetChangeTokenStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_change_token_status_input(ChangeToken = ChangeToken)
  output <- .waf$get_change_token_status_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_change_token_status <- waf_get_change_token_status

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the GeoMatchSet that is specified by `GeoMatchSetId`.
#'
#' @usage
#' waf_get_geo_match_set(GeoMatchSetId)
#'
#' @param GeoMatchSetId &#91;required&#93; The `GeoMatchSetId` of the GeoMatchSet that you want to get.
#' `GeoMatchSetId` is returned by
#' [`create_geo_match_set`][waf_create_geo_match_set] and by
#' [`list_geo_match_sets`][waf_list_geo_match_sets].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   GeoMatchSet = list(
#'     GeoMatchSetId = "string",
#'     Name = "string",
#'     GeoMatchConstraints = list(
#'       list(
#'         Type = "Country",
#'         Value = "AF"|"AX"|"AL"|"DZ"|"AS"|"AD"|"AO"|"AI"|"AQ"|"AG"|"AR"|"AM"|"AW"|"AU"|"AT"|"AZ"|"BS"|"BH"|"BD"|"BB"|"BY"|"BE"|"BZ"|"BJ"|"BM"|"BT"|"BO"|"BQ"|"BA"|"BW"|"BV"|"BR"|"IO"|"BN"|"BG"|"BF"|"BI"|"KH"|"CM"|"CA"|"CV"|"KY"|"CF"|"TD"|"CL"|"CN"|"CX"|"CC"|"CO"|"KM"|"CG"|"CD"|"CK"|"CR"|"CI"|"HR"|"CU"|"CW"|"CY"|"CZ"|"DK"|"DJ"|"DM"|"DO"|"EC"|"EG"|"SV"|"GQ"|"ER"|"EE"|"ET"|"FK"|"FO"|"FJ"|"FI"|"FR"|"GF"|"PF"|"TF"|"GA"|"GM"|"GE"|"DE"|"GH"|"GI"|"GR"|"GL"|"GD"|"GP"|"GU"|"GT"|"GG"|"GN"|"GW"|"GY"|"HT"|"HM"|"VA"|"HN"|"HK"|"HU"|"IS"|"IN"|"ID"|"IR"|"IQ"|"IE"|"IM"|"IL"|"IT"|"JM"|"JP"|"JE"|"JO"|"KZ"|"KE"|"KI"|"KP"|"KR"|"KW"|"KG"|"LA"|"LV"|"LB"|"LS"|"LR"|"LY"|"LI"|"LT"|"LU"|"MO"|"MK"|"MG"|"MW"|"MY"|"MV"|"ML"|"MT"|"MH"|"MQ"|"MR"|"MU"|"YT"|"MX"|"FM"|"MD"|"MC"|"MN"|"ME"|"MS"|"MA"|"MZ"|"MM"|"NA"|"NR"|"NP"|"NL"|"NC"|"NZ"|"NI"|"NE"|"NG"|"NU"|"NF"|"MP"|"NO"|"OM"|"PK"|"PW"|"PS"|"PA"|"PG"|"PY"|"PE"|"PH"|"PN"|"PL"|"PT"|"PR"|"QA"|"RE"|"RO"|"RU"|"RW"|"BL"|"SH"|"KN"|"LC"|"MF"|"PM"|"VC"|"WS"|"SM"|"ST"|"SA"|"SN"|"RS"|"SC"|"SL"|"SG"|"SX"|"SK"|"SI"|"SB"|"SO"|"ZA"|"GS"|"SS"|"ES"|"LK"|"SD"|"SR"|"SJ"|"SZ"|"SE"|"CH"|"SY"|"TW"|"TJ"|"TZ"|"TH"|"TL"|"TG"|"TK"|"TO"|"TT"|"TN"|"TR"|"TM"|"TC"|"TV"|"UG"|"UA"|"AE"|"GB"|"US"|"UM"|"UY"|"UZ"|"VU"|"VE"|"VN"|"VG"|"VI"|"WF"|"EH"|"YE"|"ZM"|"ZW"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_geo_match_set(
#'   GeoMatchSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_get_geo_match_set
waf_get_geo_match_set <- function(GeoMatchSetId) {
  op <- new_operation(
    name = "GetGeoMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_geo_match_set_input(GeoMatchSetId = GeoMatchSetId)
  output <- .waf$get_geo_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_geo_match_set <- waf_get_geo_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the IPSet that is specified by `IPSetId`.
#'
#' @usage
#' waf_get_ip_set(IPSetId)
#'
#' @param IPSetId &#91;required&#93; The `IPSetId` of the IPSet that you want to get. `IPSetId` is returned
#' by [`create_ip_set`][waf_create_ip_set] and by
#' [`list_ip_sets`][waf_list_ip_sets].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   IPSet = list(
#'     IPSetId = "string",
#'     Name = "string",
#'     IPSetDescriptors = list(
#'       list(
#'         Type = "IPV4"|"IPV6",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_ip_set(
#'   IPSetId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns the details of an IP match set with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$get_ip_set(
#'   IPSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_ip_set
waf_get_ip_set <- function(IPSetId) {
  op <- new_operation(
    name = "GetIPSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_ip_set_input(IPSetId = IPSetId)
  output <- .waf$get_ip_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_ip_set <- waf_get_ip_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the LoggingConfiguration for the specified web ACL.
#'
#' @usage
#' waf_get_logging_configuration(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL for which you want to get
#' the LoggingConfiguration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LoggingConfiguration = list(
#'     ResourceArn = "string",
#'     LogDestinationConfigs = list(
#'       "string"
#'     ),
#'     RedactedFields = list(
#'       list(
#'         Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'         Data = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_logging_configuration(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_get_logging_configuration
waf_get_logging_configuration <- function(ResourceArn) {
  op <- new_operation(
    name = "GetLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_logging_configuration_input(ResourceArn = ResourceArn)
  output <- .waf$get_logging_configuration_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_logging_configuration <- waf_get_logging_configuration

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the IAM policy attached to the RuleGroup.
#'
#' @usage
#' waf_get_permission_policy(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the RuleGroup for which you want to
#' get the policy.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Policy = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_permission_policy(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_get_permission_policy
waf_get_permission_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetPermissionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_permission_policy_input(ResourceArn = ResourceArn)
  output <- .waf$get_permission_policy_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_permission_policy <- waf_get_permission_policy

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the RateBasedRule that is specified by the `RuleId` that you
#' included in the [`get_rate_based_rule`][waf_get_rate_based_rule]
#' request.
#'
#' @usage
#' waf_get_rate_based_rule(RuleId)
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the RateBasedRule that you want to get. `RuleId` is
#' returned by [`create_rate_based_rule`][waf_create_rate_based_rule] and
#' by [`list_rate_based_rules`][waf_list_rate_based_rules].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Rule = list(
#'     RuleId = "string",
#'     Name = "string",
#'     MetricName = "string",
#'     MatchPredicates = list(
#'       list(
#'         Negated = TRUE|FALSE,
#'         Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
#'         DataId = "string"
#'       )
#'     ),
#'     RateKey = "IP",
#'     RateLimit = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_rate_based_rule(
#'   RuleId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_get_rate_based_rule
waf_get_rate_based_rule <- function(RuleId) {
  op <- new_operation(
    name = "GetRateBasedRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_rate_based_rule_input(RuleId = RuleId)
  output <- .waf$get_rate_based_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_rate_based_rule <- waf_get_rate_based_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of IP addresses currently being blocked by the
#' RateBasedRule that is specified by the `RuleId`. The maximum number of
#' managed keys that will be blocked is 10,000. If more than 10,000
#' addresses exceed the rate limit, the 10,000 addresses with the highest
#' rates will be blocked.
#'
#' @usage
#' waf_get_rate_based_rule_managed_keys(RuleId, NextMarker)
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the RateBasedRule for which you want to get a list of
#' `ManagedKeys`. `RuleId` is returned by
#' [`create_rate_based_rule`][waf_create_rate_based_rule] and by
#' [`list_rate_based_rules`][waf_list_rate_based_rules].
#' @param NextMarker A null value and not currently used. Do not include this in your
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ManagedKeys = list(
#'     "string"
#'   ),
#'   NextMarker = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_rate_based_rule_managed_keys(
#'   RuleId = "string",
#'   NextMarker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_get_rate_based_rule_managed_keys
waf_get_rate_based_rule_managed_keys <- function(RuleId, NextMarker = NULL) {
  op <- new_operation(
    name = "GetRateBasedRuleManagedKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_rate_based_rule_managed_keys_input(RuleId = RuleId, NextMarker = NextMarker)
  output <- .waf$get_rate_based_rule_managed_keys_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_rate_based_rule_managed_keys <- waf_get_rate_based_rule_managed_keys

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the RegexMatchSet specified by `RegexMatchSetId`.
#'
#' @usage
#' waf_get_regex_match_set(RegexMatchSetId)
#'
#' @param RegexMatchSetId &#91;required&#93; The `RegexMatchSetId` of the RegexMatchSet that you want to get.
#' `RegexMatchSetId` is returned by
#' [`create_regex_match_set`][waf_create_regex_match_set] and by
#' [`list_regex_match_sets`][waf_list_regex_match_sets].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegexMatchSet = list(
#'     RegexMatchSetId = "string",
#'     Name = "string",
#'     RegexMatchTuples = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         RegexPatternSetId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_regex_match_set(
#'   RegexMatchSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_get_regex_match_set
waf_get_regex_match_set <- function(RegexMatchSetId) {
  op <- new_operation(
    name = "GetRegexMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_regex_match_set_input(RegexMatchSetId = RegexMatchSetId)
  output <- .waf$get_regex_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_regex_match_set <- waf_get_regex_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the RegexPatternSet specified by `RegexPatternSetId`.
#'
#' @usage
#' waf_get_regex_pattern_set(RegexPatternSetId)
#'
#' @param RegexPatternSetId &#91;required&#93; The `RegexPatternSetId` of the RegexPatternSet that you want to get.
#' `RegexPatternSetId` is returned by
#' [`create_regex_pattern_set`][waf_create_regex_pattern_set] and by
#' [`list_regex_pattern_sets`][waf_list_regex_pattern_sets].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RegexPatternSet = list(
#'     RegexPatternSetId = "string",
#'     Name = "string",
#'     RegexPatternStrings = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_regex_pattern_set(
#'   RegexPatternSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_get_regex_pattern_set
waf_get_regex_pattern_set <- function(RegexPatternSetId) {
  op <- new_operation(
    name = "GetRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_regex_pattern_set_input(RegexPatternSetId = RegexPatternSetId)
  output <- .waf$get_regex_pattern_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_regex_pattern_set <- waf_get_regex_pattern_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the Rule that is specified by the `RuleId` that you included in
#' the [`get_rule`][waf_get_rule] request.
#'
#' @usage
#' waf_get_rule(RuleId)
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the Rule that you want to get. `RuleId` is returned by
#' [`create_rule`][waf_create_rule] and by [`list_rules`][waf_list_rules].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Rule = list(
#'     RuleId = "string",
#'     Name = "string",
#'     MetricName = "string",
#'     Predicates = list(
#'       list(
#'         Negated = TRUE|FALSE,
#'         Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
#'         DataId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_rule(
#'   RuleId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns the details of a rule with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$get_rule(
#'   RuleId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_rule
waf_get_rule <- function(RuleId) {
  op <- new_operation(
    name = "GetRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_rule_input(RuleId = RuleId)
  output <- .waf$get_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_rule <- waf_get_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the RuleGroup that is specified by the `RuleGroupId` that you
#' included in the [`get_rule_group`][waf_get_rule_group] request.
#' 
#' To view the rules in a rule group, use
#' [`list_activated_rules_in_rule_group`][waf_list_activated_rules_in_rule_group].
#'
#' @usage
#' waf_get_rule_group(RuleGroupId)
#'
#' @param RuleGroupId &#91;required&#93; The `RuleGroupId` of the RuleGroup that you want to get. `RuleGroupId`
#' is returned by [`create_rule_group`][waf_create_rule_group] and by
#' [`list_rule_groups`][waf_list_rule_groups].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RuleGroup = list(
#'     RuleGroupId = "string",
#'     Name = "string",
#'     MetricName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_rule_group(
#'   RuleGroupId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_get_rule_group
waf_get_rule_group <- function(RuleGroupId) {
  op <- new_operation(
    name = "GetRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_rule_group_input(RuleGroupId = RuleGroupId)
  output <- .waf$get_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_rule_group <- waf_get_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Gets detailed information about a specified number of requests--a
#' sample--that AWS WAF randomly selects from among the first 5,000
#' requests that your AWS resource received during a time range that you
#' choose. You can specify a sample size of up to 500 requests, and you can
#' specify any time range in the previous three hours.
#' 
#' [`get_sampled_requests`][waf_get_sampled_requests] returns a time range,
#' which is usually the time range that you specified. However, if your
#' resource (such as a CloudFront distribution) received 5,000 requests
#' before the specified time range elapsed,
#' [`get_sampled_requests`][waf_get_sampled_requests] returns an updated
#' time range. This new time range indicates the actual period during which
#' AWS WAF selected the requests in the sample.
#'
#' @usage
#' waf_get_sampled_requests(WebAclId, RuleId, TimeWindow, MaxItems)
#'
#' @param WebAclId &#91;required&#93; The `WebACLId` of the `WebACL` for which you want
#' [`get_sampled_requests`][waf_get_sampled_requests] to return a sample of
#' requests.
#' @param RuleId &#91;required&#93; `RuleId` is one of three values:
#' 
#' -   The `RuleId` of the `Rule` or the `RuleGroupId` of the `RuleGroup`
#'     for which you want
#'     [`get_sampled_requests`][waf_get_sampled_requests] to return a
#'     sample of requests.
#' 
#' -   `Default_Action`, which causes
#'     [`get_sampled_requests`][waf_get_sampled_requests] to return a
#'     sample of the requests that didn't match any of the rules in the
#'     specified `WebACL`.
#' @param TimeWindow &#91;required&#93; The start date and time and the end date and time of the range for which
#' you want [`get_sampled_requests`][waf_get_sampled_requests] to return a
#' sample of requests. You must specify the times in Coordinated Universal
#' Time (UTC) format. UTC format includes the special designator, `Z`. For
#' example, `"2016-09-27T14:50Z"`. You can specify any time range in the
#' previous three hours.
#' @param MaxItems &#91;required&#93; The number of requests that you want AWS WAF to return from among the
#' first 5,000 requests that your AWS resource received during the time
#' range. If your resource received fewer requests than the value of
#' `MaxItems`, [`get_sampled_requests`][waf_get_sampled_requests] returns
#' information about all of them.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SampledRequests = list(
#'     list(
#'       Request = list(
#'         ClientIP = "string",
#'         Country = "string",
#'         URI = "string",
#'         Method = "string",
#'         HTTPVersion = "string",
#'         Headers = list(
#'           list(
#'             Name = "string",
#'             Value = "string"
#'           )
#'         )
#'       ),
#'       Weight = 123,
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Action = "string",
#'       RuleWithinRuleGroup = "string"
#'     )
#'   ),
#'   PopulationSize = 123,
#'   TimeWindow = list(
#'     StartTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EndTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_sampled_requests(
#'   WebAclId = "string",
#'   RuleId = "string",
#'   TimeWindow = list(
#'     StartTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EndTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   MaxItems = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns detailed information about 100 requests
#' # --a sample-- that AWS WAF randomly selects from among the first 5,000
#' # requests that your AWS resource received between the time period
#' # 2016-09-27T15:50Z to 2016-09-27T15:50Z.
#' svc$get_sampled_requests(
#'   MaxItems = 100L,
#'   RuleId = "WAFRule-1-Example",
#'   TimeWindow = list(
#'     EndTime = "2016-09-27T15:50Z",
#'     StartTime = "2016-09-27T15:50Z"
#'   ),
#'   WebAclId = "createwebacl-1472061481310"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_sampled_requests
waf_get_sampled_requests <- function(WebAclId, RuleId, TimeWindow, MaxItems) {
  op <- new_operation(
    name = "GetSampledRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_sampled_requests_input(WebAclId = WebAclId, RuleId = RuleId, TimeWindow = TimeWindow, MaxItems = MaxItems)
  output <- .waf$get_sampled_requests_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_sampled_requests <- waf_get_sampled_requests

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the SizeConstraintSet specified by `SizeConstraintSetId`.
#'
#' @usage
#' waf_get_size_constraint_set(SizeConstraintSetId)
#'
#' @param SizeConstraintSetId &#91;required&#93; The `SizeConstraintSetId` of the SizeConstraintSet that you want to get.
#' `SizeConstraintSetId` is returned by
#' [`create_size_constraint_set`][waf_create_size_constraint_set] and by
#' [`list_size_constraint_sets`][waf_list_size_constraint_sets].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SizeConstraintSet = list(
#'     SizeConstraintSetId = "string",
#'     Name = "string",
#'     SizeConstraints = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         ComparisonOperator = "EQ"|"NE"|"LE"|"LT"|"GE"|"GT",
#'         Size = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_size_constraint_set(
#'   SizeConstraintSetId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns the details of a size constraint match set
#' # with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$get_size_constraint_set(
#'   SizeConstraintSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_size_constraint_set
waf_get_size_constraint_set <- function(SizeConstraintSetId) {
  op <- new_operation(
    name = "GetSizeConstraintSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_size_constraint_set_input(SizeConstraintSetId = SizeConstraintSetId)
  output <- .waf$get_size_constraint_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_size_constraint_set <- waf_get_size_constraint_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the SqlInjectionMatchSet that is specified by
#' `SqlInjectionMatchSetId`.
#'
#' @usage
#' waf_get_sql_injection_match_set(SqlInjectionMatchSetId)
#'
#' @param SqlInjectionMatchSetId &#91;required&#93; The `SqlInjectionMatchSetId` of the SqlInjectionMatchSet that you want
#' to get. `SqlInjectionMatchSetId` is returned by
#' [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#' and by
#' [`list_sql_injection_match_sets`][waf_list_sql_injection_match_sets].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SqlInjectionMatchSet = list(
#'     SqlInjectionMatchSetId = "string",
#'     Name = "string",
#'     SqlInjectionMatchTuples = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_sql_injection_match_set(
#'   SqlInjectionMatchSetId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns the details of a SQL injection match set
#' # with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$get_sql_injection_match_set(
#'   SqlInjectionMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_sql_injection_match_set
waf_get_sql_injection_match_set <- function(SqlInjectionMatchSetId) {
  op <- new_operation(
    name = "GetSqlInjectionMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_sql_injection_match_set_input(SqlInjectionMatchSetId = SqlInjectionMatchSetId)
  output <- .waf$get_sql_injection_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_sql_injection_match_set <- waf_get_sql_injection_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the WebACL that is specified by `WebACLId`.
#'
#' @usage
#' waf_get_web_acl(WebACLId)
#'
#' @param WebACLId &#91;required&#93; The `WebACLId` of the WebACL that you want to get. `WebACLId` is
#' returned by [`create_web_acl`][waf_create_web_acl] and by
#' [`list_web_ac_ls`][waf_list_web_ac_ls].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   WebACL = list(
#'     WebACLId = "string",
#'     Name = "string",
#'     MetricName = "string",
#'     DefaultAction = list(
#'       Type = "BLOCK"|"ALLOW"|"COUNT"
#'     ),
#'     Rules = list(
#'       list(
#'         Priority = 123,
#'         RuleId = "string",
#'         Action = list(
#'           Type = "BLOCK"|"ALLOW"|"COUNT"
#'         ),
#'         OverrideAction = list(
#'           Type = "NONE"|"COUNT"
#'         ),
#'         Type = "REGULAR"|"RATE_BASED"|"GROUP",
#'         ExcludedRules = list(
#'           list(
#'             RuleId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     WebACLArn = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_web_acl(
#'   WebACLId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns the details of a web ACL with the ID
#' # createwebacl-1472061481310.
#' svc$get_web_acl(
#'   WebACLId = "createwebacl-1472061481310"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_web_acl
waf_get_web_acl <- function(WebACLId) {
  op <- new_operation(
    name = "GetWebACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_web_acl_input(WebACLId = WebACLId)
  output <- .waf$get_web_acl_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_web_acl <- waf_get_web_acl

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns the XssMatchSet that is specified by `XssMatchSetId`.
#'
#' @usage
#' waf_get_xss_match_set(XssMatchSetId)
#'
#' @param XssMatchSetId &#91;required&#93; The `XssMatchSetId` of the XssMatchSet that you want to get.
#' `XssMatchSetId` is returned by
#' [`create_xss_match_set`][waf_create_xss_match_set] and by
#' [`list_xss_match_sets`][waf_list_xss_match_sets].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   XssMatchSet = list(
#'     XssMatchSetId = "string",
#'     Name = "string",
#'     XssMatchTuples = list(
#'       list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_xss_match_set(
#'   XssMatchSetId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns the details of an XSS match set with the
#' # ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$get_xss_match_set(
#'   XssMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_get_xss_match_set
waf_get_xss_match_set <- function(XssMatchSetId) {
  op <- new_operation(
    name = "GetXssMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_xss_match_set_input(XssMatchSetId = XssMatchSetId)
  output <- .waf$get_xss_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_xss_match_set <- waf_get_xss_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of ActivatedRule objects.
#'
#' @usage
#' waf_list_activated_rules_in_rule_group(RuleGroupId, NextMarker, Limit)
#'
#' @param RuleGroupId The `RuleGroupId` of the RuleGroup for which you want to get a list of
#' ActivatedRule objects.
#' @param NextMarker If you specify a value for `Limit` and you have more `ActivatedRules`
#' than the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `ActivatedRules`. For
#' the second and subsequent
#' [`list_activated_rules_in_rule_group`][waf_list_activated_rules_in_rule_group]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of `ActivatedRules`.
#' @param Limit Specifies the number of `ActivatedRules` that you want AWS WAF to return
#' for this request. If you have more `ActivatedRules` than the number that
#' you specify for `Limit`, the response includes a `NextMarker` value that
#' you can use to get another batch of `ActivatedRules`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   ActivatedRules = list(
#'     list(
#'       Priority = 123,
#'       RuleId = "string",
#'       Action = list(
#'         Type = "BLOCK"|"ALLOW"|"COUNT"
#'       ),
#'       OverrideAction = list(
#'         Type = "NONE"|"COUNT"
#'       ),
#'       Type = "REGULAR"|"RATE_BASED"|"GROUP",
#'       ExcludedRules = list(
#'         list(
#'           RuleId = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_activated_rules_in_rule_group(
#'   RuleGroupId = "string",
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_activated_rules_in_rule_group
waf_list_activated_rules_in_rule_group <- function(RuleGroupId = NULL, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListActivatedRulesInRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_activated_rules_in_rule_group_input(RuleGroupId = RuleGroupId, NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_activated_rules_in_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_activated_rules_in_rule_group <- waf_list_activated_rules_in_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of ByteMatchSetSummary objects.
#'
#' @usage
#' waf_list_byte_match_sets(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `ByteMatchSets`
#' than the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `ByteMatchSets`. For
#' the second and subsequent
#' [`list_byte_match_sets`][waf_list_byte_match_sets] requests, specify the
#' value of `NextMarker` from the previous response to get information
#' about another batch of `ByteMatchSets`.
#' @param Limit Specifies the number of `ByteMatchSet` objects that you want AWS WAF to
#' return for this request. If you have more `ByteMatchSets` objects than
#' the number you specify for `Limit`, the response includes a `NextMarker`
#' value that you can use to get another batch of `ByteMatchSet` objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   ByteMatchSets = list(
#'     list(
#'       ByteMatchSetId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_byte_match_sets(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_byte_match_sets
waf_list_byte_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListByteMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_byte_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_byte_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_byte_match_sets <- waf_list_byte_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of GeoMatchSetSummary objects in the response.
#'
#' @usage
#' waf_list_geo_match_sets(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `GeoMatchSet`s than
#' the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `GeoMatchSet` objects.
#' For the second and subsequent
#' [`list_geo_match_sets`][waf_list_geo_match_sets] requests, specify the
#' value of `NextMarker` from the previous response to get information
#' about another batch of `GeoMatchSet` objects.
#' @param Limit Specifies the number of `GeoMatchSet` objects that you want AWS WAF to
#' return for this request. If you have more `GeoMatchSet` objects than the
#' number you specify for `Limit`, the response includes a `NextMarker`
#' value that you can use to get another batch of `GeoMatchSet` objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   GeoMatchSets = list(
#'     list(
#'       GeoMatchSetId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_geo_match_sets(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_geo_match_sets
waf_list_geo_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListGeoMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_geo_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_geo_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_geo_match_sets <- waf_list_geo_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of IPSetSummary objects in the response.
#'
#' @usage
#' waf_list_ip_sets(NextMarker, Limit)
#'
#' @param NextMarker AWS WAF returns a `NextMarker` value in the response that allows you to
#' list another group of `IPSets`. For the second and subsequent
#' [`list_ip_sets`][waf_list_ip_sets] requests, specify the value of
#' `NextMarker` from the previous response to get information about another
#' batch of `IPSets`.
#' @param Limit Specifies the number of `IPSet` objects that you want AWS WAF to return
#' for this request. If you have more `IPSet` objects than the number you
#' specify for `Limit`, the response includes a `NextMarker` value that you
#' can use to get another batch of `IPSet` objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   IPSets = list(
#'     list(
#'       IPSetId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_ip_sets(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns an array of up to 100 IP match sets.
#' svc$list_ip_sets(
#'   Limit = 100L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_list_ip_sets
waf_list_ip_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListIPSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_ip_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_ip_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_ip_sets <- waf_list_ip_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of LoggingConfiguration objects.
#'
#' @usage
#' waf_list_logging_configurations(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more
#' `LoggingConfigurations` than the value of `Limit`, AWS WAF returns a
#' `NextMarker` value in the response that allows you to list another group
#' of `LoggingConfigurations`. For the second and subsequent
#' [`list_logging_configurations`][waf_list_logging_configurations]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of
#' [`list_logging_configurations`][waf_list_logging_configurations].
#' @param Limit Specifies the number of `LoggingConfigurations` that you want AWS WAF to
#' return for this request. If you have more `LoggingConfigurations` than
#' the number that you specify for `Limit`, the response includes a
#' `NextMarker` value that you can use to get another batch of
#' `LoggingConfigurations`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LoggingConfigurations = list(
#'     list(
#'       ResourceArn = "string",
#'       LogDestinationConfigs = list(
#'         "string"
#'       ),
#'       RedactedFields = list(
#'         list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextMarker = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_logging_configurations(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_logging_configurations
waf_list_logging_configurations <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListLoggingConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_logging_configurations_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_logging_configurations_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_logging_configurations <- waf_list_logging_configurations

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of RuleSummary objects.
#'
#' @usage
#' waf_list_rate_based_rules(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `Rules` than the
#' value of `Limit`, AWS WAF returns a `NextMarker` value in the response
#' that allows you to list another group of `Rules`. For the second and
#' subsequent [`list_rate_based_rules`][waf_list_rate_based_rules]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of `Rules`.
#' @param Limit Specifies the number of `Rules` that you want AWS WAF to return for this
#' request. If you have more `Rules` than the number that you specify for
#' `Limit`, the response includes a `NextMarker` value that you can use to
#' get another batch of `Rules`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   Rules = list(
#'     list(
#'       RuleId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_rate_based_rules(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_rate_based_rules
waf_list_rate_based_rules <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRateBasedRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_rate_based_rules_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_rate_based_rules_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_rate_based_rules <- waf_list_rate_based_rules

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of RegexMatchSetSummary objects.
#'
#' @usage
#' waf_list_regex_match_sets(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `RegexMatchSet`
#' objects than the value of `Limit`, AWS WAF returns a `NextMarker` value
#' in the response that allows you to list another group of
#' `ByteMatchSets`. For the second and subsequent
#' [`list_regex_match_sets`][waf_list_regex_match_sets] requests, specify
#' the value of `NextMarker` from the previous response to get information
#' about another batch of `RegexMatchSet` objects.
#' @param Limit Specifies the number of `RegexMatchSet` objects that you want AWS WAF to
#' return for this request. If you have more `RegexMatchSet` objects than
#' the number you specify for `Limit`, the response includes a `NextMarker`
#' value that you can use to get another batch of `RegexMatchSet` objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   RegexMatchSets = list(
#'     list(
#'       RegexMatchSetId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_regex_match_sets(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_regex_match_sets
waf_list_regex_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRegexMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_regex_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_regex_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_regex_match_sets <- waf_list_regex_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of RegexPatternSetSummary objects.
#'
#' @usage
#' waf_list_regex_pattern_sets(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `RegexPatternSet`
#' objects than the value of `Limit`, AWS WAF returns a `NextMarker` value
#' in the response that allows you to list another group of
#' `RegexPatternSet` objects. For the second and subsequent
#' [`list_regex_pattern_sets`][waf_list_regex_pattern_sets] requests,
#' specify the value of `NextMarker` from the previous response to get
#' information about another batch of `RegexPatternSet` objects.
#' @param Limit Specifies the number of `RegexPatternSet` objects that you want AWS WAF
#' to return for this request. If you have more `RegexPatternSet` objects
#' than the number you specify for `Limit`, the response includes a
#' `NextMarker` value that you can use to get another batch of
#' `RegexPatternSet` objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   RegexPatternSets = list(
#'     list(
#'       RegexPatternSetId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_regex_pattern_sets(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_regex_pattern_sets
waf_list_regex_pattern_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRegexPatternSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_regex_pattern_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_regex_pattern_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_regex_pattern_sets <- waf_list_regex_pattern_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of RuleGroup objects.
#'
#' @usage
#' waf_list_rule_groups(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `RuleGroups` than
#' the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `RuleGroups`. For the
#' second and subsequent [`list_rule_groups`][waf_list_rule_groups]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of `RuleGroups`.
#' @param Limit Specifies the number of `RuleGroups` that you want AWS WAF to return for
#' this request. If you have more `RuleGroups` than the number that you
#' specify for `Limit`, the response includes a `NextMarker` value that you
#' can use to get another batch of `RuleGroups`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   RuleGroups = list(
#'     list(
#'       RuleGroupId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_rule_groups(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_rule_groups
waf_list_rule_groups <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRuleGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_rule_groups_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_rule_groups_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_rule_groups <- waf_list_rule_groups

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of RuleSummary objects.
#'
#' @usage
#' waf_list_rules(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `Rules` than the
#' value of `Limit`, AWS WAF returns a `NextMarker` value in the response
#' that allows you to list another group of `Rules`. For the second and
#' subsequent [`list_rules`][waf_list_rules] requests, specify the value of
#' `NextMarker` from the previous response to get information about another
#' batch of `Rules`.
#' @param Limit Specifies the number of `Rules` that you want AWS WAF to return for this
#' request. If you have more `Rules` than the number that you specify for
#' `Limit`, the response includes a `NextMarker` value that you can use to
#' get another batch of `Rules`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   Rules = list(
#'     list(
#'       RuleId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_rules(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns an array of up to 100 rules.
#' svc$list_rules(
#'   Limit = 100L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_list_rules
waf_list_rules <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_rules_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_rules_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_rules <- waf_list_rules

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of SizeConstraintSetSummary objects.
#'
#' @usage
#' waf_list_size_constraint_sets(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more
#' `SizeConstraintSets` than the value of `Limit`, AWS WAF returns a
#' `NextMarker` value in the response that allows you to list another group
#' of `SizeConstraintSets`. For the second and subsequent
#' [`list_size_constraint_sets`][waf_list_size_constraint_sets] requests,
#' specify the value of `NextMarker` from the previous response to get
#' information about another batch of `SizeConstraintSets`.
#' @param Limit Specifies the number of `SizeConstraintSet` objects that you want AWS
#' WAF to return for this request. If you have more `SizeConstraintSets`
#' objects than the number you specify for `Limit`, the response includes a
#' `NextMarker` value that you can use to get another batch of
#' `SizeConstraintSet` objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   SizeConstraintSets = list(
#'     list(
#'       SizeConstraintSetId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_size_constraint_sets(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns an array of up to 100 size contraint match
#' # sets.
#' svc$list_size_constraint_sets(
#'   Limit = 100L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_list_size_constraint_sets
waf_list_size_constraint_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListSizeConstraintSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_size_constraint_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_size_constraint_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_size_constraint_sets <- waf_list_size_constraint_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of SqlInjectionMatchSet objects.
#'
#' @usage
#' waf_list_sql_injection_match_sets(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more
#' SqlInjectionMatchSet objects than the value of `Limit`, AWS WAF returns
#' a `NextMarker` value in the response that allows you to list another
#' group of `SqlInjectionMatchSets`. For the second and subsequent
#' [`list_sql_injection_match_sets`][waf_list_sql_injection_match_sets]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of `SqlInjectionMatchSets`.
#' @param Limit Specifies the number of SqlInjectionMatchSet objects that you want AWS
#' WAF to return for this request. If you have more `SqlInjectionMatchSet`
#' objects than the number you specify for `Limit`, the response includes a
#' `NextMarker` value that you can use to get another batch of `Rules`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   SqlInjectionMatchSets = list(
#'     list(
#'       SqlInjectionMatchSetId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_sql_injection_match_sets(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns an array of up to 100 SQL injection match
#' # sets.
#' svc$list_sql_injection_match_sets(
#'   Limit = 100L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_list_sql_injection_match_sets
waf_list_sql_injection_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListSqlInjectionMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_sql_injection_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_sql_injection_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_sql_injection_match_sets <- waf_list_sql_injection_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of RuleGroup objects that you are subscribed to.
#'
#' @usage
#' waf_list_subscribed_rule_groups(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more
#' `ByteMatchSets`subscribed rule groups than the value of `Limit`, AWS WAF
#' returns a `NextMarker` value in the response that allows you to list
#' another group of subscribed rule groups. For the second and subsequent
#' `ListSubscribedRuleGroupsRequest` requests, specify the value of
#' `NextMarker` from the previous response to get information about another
#' batch of subscribed rule groups.
#' @param Limit Specifies the number of subscribed rule groups that you want AWS WAF to
#' return for this request. If you have more objects than the number you
#' specify for `Limit`, the response includes a `NextMarker` value that you
#' can use to get another batch of objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   RuleGroups = list(
#'     list(
#'       RuleGroupId = "string",
#'       Name = "string",
#'       MetricName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_subscribed_rule_groups(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_subscribed_rule_groups
waf_list_subscribed_rule_groups <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListSubscribedRuleGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_subscribed_rule_groups_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_subscribed_rule_groups_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_subscribed_rule_groups <- waf_list_subscribed_rule_groups

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Retrieves the tags associated with the specified AWS resource. Tags are
#' key:value pairs that you can use to categorize and manage your
#' resources, for purposes like billing. For example, you might set the tag
#' key to "customer" and the value to the customer name or ID. You can
#' specify one or more tags to add to each AWS resource, up to 50 tags for
#' a resource.
#' 
#' Tagging is only available through the API, SDKs, and CLI. You can't
#' manage or view tags through the AWS WAF Classic console. You can tag the
#' AWS resources that you manage through AWS WAF Classic: web ACLs, rule
#' groups, and rules.
#'
#' @usage
#' waf_list_tags_for_resource(NextMarker, Limit, ResourceARN)
#'
#' @param NextMarker 
#' @param Limit 
#' @param ResourceARN &#91;required&#93; 
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   TagInfoForResource = list(
#'     ResourceARN = "string",
#'     TagList = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   NextMarker = "string",
#'   Limit = 123,
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_list_tags_for_resource
waf_list_tags_for_resource <- function(NextMarker = NULL, Limit = NULL, ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_tags_for_resource_input(NextMarker = NextMarker, Limit = Limit, ResourceARN = ResourceARN)
  output <- .waf$list_tags_for_resource_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_tags_for_resource <- waf_list_tags_for_resource

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of WebACLSummary objects in the response.
#'
#' @usage
#' waf_list_web_ac_ls(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `WebACL` objects
#' than the number that you specify for `Limit`, AWS WAF returns a
#' `NextMarker` value in the response that allows you to list another group
#' of `WebACL` objects. For the second and subsequent
#' [`list_web_ac_ls`][waf_list_web_ac_ls] requests, specify the value of
#' `NextMarker` from the previous response to get information about another
#' batch of `WebACL` objects.
#' @param Limit Specifies the number of `WebACL` objects that you want AWS WAF to return
#' for this request. If you have more `WebACL` objects than the number that
#' you specify for `Limit`, the response includes a `NextMarker` value that
#' you can use to get another batch of `WebACL` objects.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   WebACLs = list(
#'     list(
#'       WebACLId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_web_ac_ls(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns an array of up to 100 web ACLs.
#' svc$list_web_ac_ls(
#'   Limit = 100L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_list_web_ac_ls
waf_list_web_ac_ls <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListWebACLs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_web_ac_ls_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_web_ac_ls_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_web_ac_ls <- waf_list_web_ac_ls

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Returns an array of XssMatchSet objects.
#'
#' @usage
#' waf_list_xss_match_sets(NextMarker, Limit)
#'
#' @param NextMarker If you specify a value for `Limit` and you have more XssMatchSet objects
#' than the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `XssMatchSets`. For
#' the second and subsequent
#' [`list_xss_match_sets`][waf_list_xss_match_sets] requests, specify the
#' value of `NextMarker` from the previous response to get information
#' about another batch of `XssMatchSets`.
#' @param Limit Specifies the number of XssMatchSet objects that you want AWS WAF to
#' return for this request. If you have more `XssMatchSet` objects than the
#' number you specify for `Limit`, the response includes a `NextMarker`
#' value that you can use to get another batch of `Rules`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextMarker = "string",
#'   XssMatchSets = list(
#'     list(
#'       XssMatchSetId = "string",
#'       Name = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_xss_match_sets(
#'   NextMarker = "string",
#'   Limit = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example returns an array of up to 100 XSS match sets.
#' svc$list_xss_match_sets(
#'   Limit = 100L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_list_xss_match_sets
waf_list_xss_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListXssMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_xss_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_xss_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_xss_match_sets <- waf_list_xss_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Associates a LoggingConfiguration with a specified web ACL.
#' 
#' You can access information about all traffic that AWS WAF inspects using
#' the following steps:
#' 
#' 1.  Create an Amazon Kinesis Data Firehose.
#' 
#'     Create the data firehose with a PUT source and in the region that
#'     you are operating. However, if you are capturing logs for Amazon
#'     CloudFront, always create the firehose in US East (N. Virginia).
#' 
#'     Do not create the data firehose using a `Kinesis stream` as your
#'     source.
#' 
#' 2.  Associate that firehose to your web ACL using a
#'     [`put_logging_configuration`][waf_put_logging_configuration]
#'     request.
#' 
#' When you successfully enable logging using a
#' [`put_logging_configuration`][waf_put_logging_configuration] request,
#' AWS WAF will create a service linked role with the necessary permissions
#' to write logs to the Amazon Kinesis Data Firehose. For more information,
#' see [Logging Web ACL Traffic
#' Information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html)
#' in the *AWS WAF Developer Guide*.
#'
#' @usage
#' waf_put_logging_configuration(LoggingConfiguration)
#'
#' @param LoggingConfiguration &#91;required&#93; The Amazon Kinesis Data Firehose that contains the inspected traffic
#' information, the redacted fields details, and the Amazon Resource Name
#' (ARN) of the web ACL to monitor.
#' 
#' When specifying `Type` in `RedactedFields`, you must use one of the
#' following values: `URI`, `QUERY_STRING`, `HEADER`, or `METHOD`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   LoggingConfiguration = list(
#'     ResourceArn = "string",
#'     LogDestinationConfigs = list(
#'       "string"
#'     ),
#'     RedactedFields = list(
#'       list(
#'         Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'         Data = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_logging_configuration(
#'   LoggingConfiguration = list(
#'     ResourceArn = "string",
#'     LogDestinationConfigs = list(
#'       "string"
#'     ),
#'     RedactedFields = list(
#'       list(
#'         Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'         Data = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_put_logging_configuration
waf_put_logging_configuration <- function(LoggingConfiguration) {
  op <- new_operation(
    name = "PutLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$put_logging_configuration_input(LoggingConfiguration = LoggingConfiguration)
  output <- .waf$put_logging_configuration_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$put_logging_configuration <- waf_put_logging_configuration

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Attaches an IAM policy to the specified resource. The only supported use
#' for this action is to share a RuleGroup across accounts.
#' 
#' The [`put_permission_policy`][waf_put_permission_policy] is subject to
#' the following restrictions:
#' 
#' -   You can attach only one policy with each
#'     [`put_permission_policy`][waf_put_permission_policy] request.
#' 
#' -   The policy must include an `Effect`, `Action` and `Principal`.
#' 
#' -   `Effect` must specify `Allow`.
#' 
#' -   The `Action` in the policy must be `waf:UpdateWebACL`,
#'     `waf-regional:UpdateWebACL`, `waf:GetRuleGroup` and
#'     `waf-regional:GetRuleGroup` . Any extra or wildcard actions in the
#'     policy will be rejected.
#' 
#' -   The policy cannot include a `Resource` parameter.
#' 
#' -   The ARN in the request must be a valid WAF RuleGroup ARN and the
#'     RuleGroup must exist in the same region.
#' 
#' -   The user making the request must be the owner of the RuleGroup.
#' 
#' -   Your policy must be composed using IAM Policy version 2012-10-17.
#' 
#' For more information, see [IAM
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
#' 
#' An example of a valid policy parameter is shown in the Examples section
#' below.
#'
#' @usage
#' waf_put_permission_policy(ResourceArn, Policy)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the RuleGroup to which you want to
#' attach the policy.
#' @param Policy &#91;required&#93; The policy to attach to the specified RuleGroup.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_permission_policy(
#'   ResourceArn = "string",
#'   Policy = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_put_permission_policy
waf_put_permission_policy <- function(ResourceArn, Policy) {
  op <- new_operation(
    name = "PutPermissionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$put_permission_policy_input(ResourceArn = ResourceArn, Policy = Policy)
  output <- .waf$put_permission_policy_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$put_permission_policy <- waf_put_permission_policy

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Associates tags with the specified AWS resource. Tags are key:value
#' pairs that you can use to categorize and manage your resources, for
#' purposes like billing. For example, you might set the tag key to
#' "customer" and the value to the customer name or ID. You can specify one
#' or more tags to add to each AWS resource, up to 50 tags for a resource.
#' 
#' Tagging is only available through the API, SDKs, and CLI. You can't
#' manage or view tags through the AWS WAF Classic console. You can use
#' this action to tag the AWS resources that you manage through AWS WAF
#' Classic: web ACLs, rule groups, and rules.
#'
#' @usage
#' waf_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; 
#' @param Tags &#91;required&#93; 
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_tag_resource
waf_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .waf$tag_resource_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$tag_resource <- waf_tag_resource

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#'
#' @usage
#' waf_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; 
#' @param TagKeys &#91;required&#93; 
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_untag_resource
waf_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .waf$untag_resource_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$untag_resource <- waf_untag_resource

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet.
#' For each `ByteMatchTuple` object, you specify the following values:
#' 
#' -   Whether to insert or delete the object from the array. If you want
#'     to change a `ByteMatchSetUpdate` object, you delete the existing
#'     object and add a new one.
#' 
#' -   The part of a web request that you want AWS WAF to inspect, such as
#'     a query string or the value of the `User-Agent` header.
#' 
#' -   The bytes (typically a string that corresponds with ASCII
#'     characters) that you want AWS WAF to look for. For more information,
#'     including how you specify the values for the AWS WAF API and the AWS
#'     CLI or SDKs, see `TargetString` in the ByteMatchTuple data type.
#' 
#' -   Where to look, such as at the beginning or the end of a query
#'     string.
#' 
#' -   Whether to perform any conversions on the request, such as
#'     converting it to lowercase, before inspecting it for the specified
#'     string.
#' 
#' For example, you can add a `ByteMatchSetUpdate` object that matches web
#' requests in which `User-Agent` headers contain the string `BadBot`. You
#' can then configure AWS WAF to block those requests.
#' 
#' To create and configure a `ByteMatchSet`, perform the following steps:
#' 
#' 1.  Create a `ByteMatchSet.` For more information, see
#'     [`create_byte_match_set`][waf_create_byte_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_byte_match_set`][waf_update_byte_match_set] request.
#' 
#' 3.  Submit an [`update_byte_match_set`][waf_update_byte_match_set]
#'     request to specify the part of the request that you want AWS WAF to
#'     inspect (for example, the header or the URI) and the value that you
#'     want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_byte_match_set(ByteMatchSetId, ChangeToken, Updates)
#'
#' @param ByteMatchSetId &#91;required&#93; The `ByteMatchSetId` of the ByteMatchSet that you want to update.
#' `ByteMatchSetId` is returned by
#' [`create_byte_match_set`][waf_create_byte_match_set] and by
#' [`list_byte_match_sets`][waf_list_byte_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `ByteMatchSetUpdate` objects that you want to insert into or
#' delete from a ByteMatchSet. For more information, see the applicable
#' data types:
#' 
#' -   ByteMatchSetUpdate: Contains `Action` and `ByteMatchTuple`
#' 
#' -   ByteMatchTuple: Contains `FieldToMatch`, `PositionalConstraint`,
#'     `TargetString`, and `TextTransformation`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_byte_match_set(
#'   ByteMatchSetId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       ByteMatchTuple = list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TargetString = raw,
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         PositionalConstraint = "EXACTLY"|"STARTS_WITH"|"ENDS_WITH"|"CONTAINS"|"CONTAINS_WORD"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a ByteMatchTuple object (filters) in an
#' # byte match set with the ID exampleIDs3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$update_byte_match_set(
#'   ByteMatchSetId = "exampleIDs3t-46da-4fdb-b8d5-abc321j569j5",
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   Updates = list(
#'     list(
#'       Action = "DELETE",
#'       ByteMatchTuple = list(
#'         FieldToMatch = list(
#'           Data = "referer",
#'           Type = "HEADER"
#'         ),
#'         PositionalConstraint = "CONTAINS",
#'         TargetString = "badrefer1",
#'         TextTransformation = "NONE"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_update_byte_match_set
waf_update_byte_match_set <- function(ByteMatchSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateByteMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_byte_match_set_input(ByteMatchSetId = ByteMatchSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_byte_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_byte_match_set <- waf_update_byte_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes GeoMatchConstraint objects in an `GeoMatchSet`. For
#' each `GeoMatchConstraint` object, you specify the following values:
#' 
#' -   Whether to insert or delete the object from the array. If you want
#'     to change an `GeoMatchConstraint` object, you delete the existing
#'     object and add a new one.
#' 
#' -   The `Type`. The only valid value for `Type` is `Country`.
#' 
#' -   The `Value`, which is a two character code for the country to add to
#'     the `GeoMatchConstraint` object. Valid codes are listed in
#'     GeoMatchConstraint$Value.
#' 
#' To create and configure an `GeoMatchSet`, perform the following steps:
#' 
#' 1.  Submit a [`create_geo_match_set`][waf_create_geo_match_set] request.
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_geo_match_set`][waf_update_geo_match_set] request.
#' 
#' 3.  Submit an [`update_geo_match_set`][waf_update_geo_match_set] request
#'     to specify the country that you want AWS WAF to watch for.
#' 
#' When you update an `GeoMatchSet`, you specify the country that you want
#' to add and/or the country that you want to delete. If you want to change
#' a country, you delete the existing country and add the new one.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_geo_match_set(GeoMatchSetId, ChangeToken, Updates)
#'
#' @param GeoMatchSetId &#91;required&#93; The `GeoMatchSetId` of the GeoMatchSet that you want to update.
#' `GeoMatchSetId` is returned by
#' [`create_geo_match_set`][waf_create_geo_match_set] and by
#' [`list_geo_match_sets`][waf_list_geo_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `GeoMatchSetUpdate` objects that you want to insert into or
#' delete from an GeoMatchSet. For more information, see the applicable
#' data types:
#' 
#' -   GeoMatchSetUpdate: Contains `Action` and `GeoMatchConstraint`
#' 
#' -   GeoMatchConstraint: Contains `Type` and `Value`
#' 
#'     You can have only one `Type` and `Value` per `GeoMatchConstraint`.
#'     To add multiple countries, include multiple `GeoMatchSetUpdate`
#'     objects in your request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_geo_match_set(
#'   GeoMatchSetId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       GeoMatchConstraint = list(
#'         Type = "Country",
#'         Value = "AF"|"AX"|"AL"|"DZ"|"AS"|"AD"|"AO"|"AI"|"AQ"|"AG"|"AR"|"AM"|"AW"|"AU"|"AT"|"AZ"|"BS"|"BH"|"BD"|"BB"|"BY"|"BE"|"BZ"|"BJ"|"BM"|"BT"|"BO"|"BQ"|"BA"|"BW"|"BV"|"BR"|"IO"|"BN"|"BG"|"BF"|"BI"|"KH"|"CM"|"CA"|"CV"|"KY"|"CF"|"TD"|"CL"|"CN"|"CX"|"CC"|"CO"|"KM"|"CG"|"CD"|"CK"|"CR"|"CI"|"HR"|"CU"|"CW"|"CY"|"CZ"|"DK"|"DJ"|"DM"|"DO"|"EC"|"EG"|"SV"|"GQ"|"ER"|"EE"|"ET"|"FK"|"FO"|"FJ"|"FI"|"FR"|"GF"|"PF"|"TF"|"GA"|"GM"|"GE"|"DE"|"GH"|"GI"|"GR"|"GL"|"GD"|"GP"|"GU"|"GT"|"GG"|"GN"|"GW"|"GY"|"HT"|"HM"|"VA"|"HN"|"HK"|"HU"|"IS"|"IN"|"ID"|"IR"|"IQ"|"IE"|"IM"|"IL"|"IT"|"JM"|"JP"|"JE"|"JO"|"KZ"|"KE"|"KI"|"KP"|"KR"|"KW"|"KG"|"LA"|"LV"|"LB"|"LS"|"LR"|"LY"|"LI"|"LT"|"LU"|"MO"|"MK"|"MG"|"MW"|"MY"|"MV"|"ML"|"MT"|"MH"|"MQ"|"MR"|"MU"|"YT"|"MX"|"FM"|"MD"|"MC"|"MN"|"ME"|"MS"|"MA"|"MZ"|"MM"|"NA"|"NR"|"NP"|"NL"|"NC"|"NZ"|"NI"|"NE"|"NG"|"NU"|"NF"|"MP"|"NO"|"OM"|"PK"|"PW"|"PS"|"PA"|"PG"|"PY"|"PE"|"PH"|"PN"|"PL"|"PT"|"PR"|"QA"|"RE"|"RO"|"RU"|"RW"|"BL"|"SH"|"KN"|"LC"|"MF"|"PM"|"VC"|"WS"|"SM"|"ST"|"SA"|"SN"|"RS"|"SC"|"SL"|"SG"|"SX"|"SK"|"SI"|"SB"|"SO"|"ZA"|"GS"|"SS"|"ES"|"LK"|"SD"|"SR"|"SJ"|"SZ"|"SE"|"CH"|"SY"|"TW"|"TJ"|"TZ"|"TH"|"TL"|"TG"|"TK"|"TO"|"TT"|"TN"|"TR"|"TM"|"TC"|"TV"|"UG"|"UA"|"AE"|"GB"|"US"|"UM"|"UY"|"UZ"|"VU"|"VE"|"VN"|"VG"|"VI"|"WF"|"EH"|"YE"|"ZM"|"ZW"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_update_geo_match_set
waf_update_geo_match_set <- function(GeoMatchSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateGeoMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_geo_match_set_input(GeoMatchSetId = GeoMatchSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_geo_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_geo_match_set <- waf_update_geo_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes IPSetDescriptor objects in an `IPSet`. For each
#' `IPSetDescriptor` object, you specify the following values:
#' 
#' -   Whether to insert or delete the object from the array. If you want
#'     to change an `IPSetDescriptor` object, you delete the existing
#'     object and add a new one.
#' 
#' -   The IP address version, `IPv4` or `IPv6`.
#' 
#' -   The IP address in CIDR notation, for example, `192.0.2.0/24` (for
#'     the range of IP addresses from `192.0.2.0` to `192.0.2.255`) or
#'     `192.0.2.44/32` (for the individual IP address `192.0.2.44`).
#' 
#' AWS WAF supports IPv4 address ranges: /8 and any range between /16
#' through /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56,
#' /64, and /128. For more information about CIDR notation, see the
#' Wikipedia entry [Classless Inter-Domain
#' Routing](https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
#' 
#' IPv6 addresses can be represented using any of the following formats:
#' 
#' -   1111:0000:0000:0000:0000:0000:0000:0111/128
#' 
#' -   1111:0:0:0:0:0:0:0111/128
#' 
#' -   1111::0111/128
#' 
#' -   1111::111/128
#' 
#' You use an `IPSet` to specify which web requests you want to allow or
#' block based on the IP addresses that the requests originated from. For
#' example, if you're receiving a lot of requests from one or a small
#' number of IP addresses and you want to block the requests, you can
#' create an `IPSet` that specifies those IP addresses, and then configure
#' AWS WAF to block the requests.
#' 
#' To create and configure an `IPSet`, perform the following steps:
#' 
#' 1.  Submit a [`create_ip_set`][waf_create_ip_set] request.
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_ip_set`][waf_update_ip_set] request.
#' 
#' 3.  Submit an [`update_ip_set`][waf_update_ip_set] request to specify
#'     the IP addresses that you want AWS WAF to watch for.
#' 
#' When you update an `IPSet`, you specify the IP addresses that you want
#' to add and/or the IP addresses that you want to delete. If you want to
#' change an IP address, you delete the existing IP address and add the new
#' one.
#' 
#' You can insert a maximum of 1000 addresses in a single request.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_ip_set(IPSetId, ChangeToken, Updates)
#'
#' @param IPSetId &#91;required&#93; The `IPSetId` of the IPSet that you want to update. `IPSetId` is
#' returned by [`create_ip_set`][waf_create_ip_set] and by
#' [`list_ip_sets`][waf_list_ip_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `IPSetUpdate` objects that you want to insert into or delete
#' from an IPSet. For more information, see the applicable data types:
#' 
#' -   IPSetUpdate: Contains `Action` and `IPSetDescriptor`
#' 
#' -   IPSetDescriptor: Contains `Type` and `Value`
#' 
#' You can insert a maximum of 1000 addresses in a single request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_ip_set(
#'   IPSetId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       IPSetDescriptor = list(
#'         Type = "IPV4"|"IPV6",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes an IPSetDescriptor object in an IP match
#' # set with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$update_ip_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   IPSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5",
#'   Updates = list(
#'     list(
#'       Action = "DELETE",
#'       IPSetDescriptor = list(
#'         Type = "IPV4",
#'         Value = "192.0.2.44/32"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_update_ip_set
waf_update_ip_set <- function(IPSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateIPSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_ip_set_input(IPSetId = IPSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_ip_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_ip_set <- waf_update_ip_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes Predicate objects in a rule and updates the
#' `RateLimit` in the rule.
#' 
#' Each `Predicate` object identifies a predicate, such as a ByteMatchSet
#' or an IPSet, that specifies the web requests that you want to block or
#' count. The `RateLimit` specifies the number of requests every five
#' minutes that triggers the rule.
#' 
#' If you add more than one predicate to a `RateBasedRule`, a request must
#' match all the predicates and exceed the `RateLimit` to be counted or
#' blocked. For example, suppose you add the following to a
#' `RateBasedRule`:
#' 
#' -   An `IPSet` that matches the IP address `192.0.2.44/32`
#' 
#' -   A `ByteMatchSet` that matches `BadBot` in the `User-Agent` header
#' 
#' Further, you specify a `RateLimit` of 1,000.
#' 
#' You then add the `RateBasedRule` to a `WebACL` and specify that you want
#' to block requests that satisfy the rule. For a request to be blocked, it
#' must come from the IP address 192.0.2.44 *and* the `User-Agent` header
#' in the request must contain the value `BadBot`. Further, requests that
#' match these two conditions much be received at a rate of more than 1,000
#' every five minutes. If the rate drops below this limit, AWS WAF no
#' longer blocks the requests.
#' 
#' As a second example, suppose you want to limit requests to a particular
#' page on your site. To do this, you could add the following to a
#' `RateBasedRule`:
#' 
#' -   A `ByteMatchSet` with `FieldToMatch` of `URI`
#' 
#' -   A `PositionalConstraint` of `STARTS_WITH`
#' 
#' -   A `TargetString` of `login`
#' 
#' Further, you specify a `RateLimit` of 1,000.
#' 
#' By adding this `RateBasedRule` to a `WebACL`, you could limit requests
#' to your login page without affecting the rest of your site.
#'
#' @usage
#' waf_update_rate_based_rule(RuleId, ChangeToken, Updates, RateLimit)
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the `RateBasedRule` that you want to update. `RuleId` is
#' returned by [`create_rate_based_rule`][waf_create_rate_based_rule] and
#' by [`list_rate_based_rules`][waf_list_rate_based_rules].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `RuleUpdate` objects that you want to insert into or delete
#' from a RateBasedRule.
#' @param RateLimit &#91;required&#93; The maximum number of requests, which have an identical value in the
#' field specified by the `RateKey`, allowed in a five-minute period. If
#' the number of requests exceeds the `RateLimit` and the other predicates
#' specified in the rule are also met, AWS WAF triggers the action that is
#' specified for this rule.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_rate_based_rule(
#'   RuleId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       Predicate = list(
#'         Negated = TRUE|FALSE,
#'         Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
#'         DataId = "string"
#'       )
#'     )
#'   ),
#'   RateLimit = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_update_rate_based_rule
waf_update_rate_based_rule <- function(RuleId, ChangeToken, Updates, RateLimit) {
  op <- new_operation(
    name = "UpdateRateBasedRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_rate_based_rule_input(RuleId = RuleId, ChangeToken = ChangeToken, Updates = Updates, RateLimit = RateLimit)
  output <- .waf$update_rate_based_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_rate_based_rule <- waf_update_rate_based_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes RegexMatchTuple objects (filters) in a RegexMatchSet.
#' For each `RegexMatchSetUpdate` object, you specify the following values:
#' 
#' -   Whether to insert or delete the object from the array. If you want
#'     to change a `RegexMatchSetUpdate` object, you delete the existing
#'     object and add a new one.
#' 
#' -   The part of a web request that you want AWS WAF to inspectupdate,
#'     such as a query string or the value of the `User-Agent` header.
#' 
#' -   The identifier of the pattern (a regular expression) that you want
#'     AWS WAF to look for. For more information, see RegexPatternSet.
#' 
#' -   Whether to perform any conversions on the request, such as
#'     converting it to lowercase, before inspecting it for the specified
#'     string.
#' 
#' For example, you can create a `RegexPatternSet` that matches any
#' requests with `User-Agent` headers that contain the string
#' `B[a@@]dB[o0]t`. You can then configure AWS WAF to reject those requests.
#' 
#' To create and configure a `RegexMatchSet`, perform the following steps:
#' 
#' 1.  Create a `RegexMatchSet.` For more information, see
#'     [`create_regex_match_set`][waf_create_regex_match_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_regex_match_set`][waf_update_regex_match_set] request.
#' 
#' 3.  Submit an [`update_regex_match_set`][waf_update_regex_match_set]
#'     request to specify the part of the request that you want AWS WAF to
#'     inspect (for example, the header or the URI) and the identifier of
#'     the `RegexPatternSet` that contain the regular expression patters
#'     you want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_regex_match_set(RegexMatchSetId, Updates, ChangeToken)
#'
#' @param RegexMatchSetId &#91;required&#93; The `RegexMatchSetId` of the RegexMatchSet that you want to update.
#' `RegexMatchSetId` is returned by
#' [`create_regex_match_set`][waf_create_regex_match_set] and by
#' [`list_regex_match_sets`][waf_list_regex_match_sets].
#' @param Updates &#91;required&#93; An array of `RegexMatchSetUpdate` objects that you want to insert into
#' or delete from a RegexMatchSet. For more information, see
#' RegexMatchTuple.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_regex_match_set(
#'   RegexMatchSetId = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       RegexMatchTuple = list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         RegexPatternSetId = "string"
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_update_regex_match_set
waf_update_regex_match_set <- function(RegexMatchSetId, Updates, ChangeToken) {
  op <- new_operation(
    name = "UpdateRegexMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_regex_match_set_input(RegexMatchSetId = RegexMatchSetId, Updates = Updates, ChangeToken = ChangeToken)
  output <- .waf$update_regex_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_regex_match_set <- waf_update_regex_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes `RegexPatternString` objects in a RegexPatternSet.
#' For each `RegexPatternString` object, you specify the following values:
#' 
#' -   Whether to insert or delete the `RegexPatternString`.
#' 
#' -   The regular expression pattern that you want to insert or delete.
#'     For more information, see RegexPatternSet.
#' 
#' For example, you can create a `RegexPatternString` such as
#' `B[a@@]dB[o0]t`. AWS WAF will match this `RegexPatternString` to:
#' 
#' -   BadBot
#' 
#' -   BadB0t
#' 
#' -   B@@dBot
#' 
#' -   B@@dB0t
#' 
#' To create and configure a `RegexPatternSet`, perform the following
#' steps:
#' 
#' 1.  Create a `RegexPatternSet.` For more information, see
#'     [`create_regex_pattern_set`][waf_create_regex_pattern_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_regex_pattern_set`][waf_update_regex_pattern_set] request.
#' 
#' 3.  Submit an [`update_regex_pattern_set`][waf_update_regex_pattern_set]
#'     request to specify the regular expression pattern that you want AWS
#'     WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_regex_pattern_set(RegexPatternSetId, Updates, ChangeToken)
#'
#' @param RegexPatternSetId &#91;required&#93; The `RegexPatternSetId` of the RegexPatternSet that you want to update.
#' `RegexPatternSetId` is returned by
#' [`create_regex_pattern_set`][waf_create_regex_pattern_set] and by
#' [`list_regex_pattern_sets`][waf_list_regex_pattern_sets].
#' @param Updates &#91;required&#93; An array of `RegexPatternSetUpdate` objects that you want to insert into
#' or delete from a RegexPatternSet.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_regex_pattern_set(
#'   RegexPatternSetId = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       RegexPatternString = "string"
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_update_regex_pattern_set
waf_update_regex_pattern_set <- function(RegexPatternSetId, Updates, ChangeToken) {
  op <- new_operation(
    name = "UpdateRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_regex_pattern_set_input(RegexPatternSetId = RegexPatternSetId, Updates = Updates, ChangeToken = ChangeToken)
  output <- .waf$update_regex_pattern_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_regex_pattern_set <- waf_update_regex_pattern_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes Predicate objects in a `Rule`. Each `Predicate`
#' object identifies a predicate, such as a ByteMatchSet or an IPSet, that
#' specifies the web requests that you want to allow, block, or count. If
#' you add more than one predicate to a `Rule`, a request must match all of
#' the specifications to be allowed, blocked, or counted. For example,
#' suppose that you add the following to a `Rule`:
#' 
#' -   A `ByteMatchSet` that matches the value `BadBot` in the `User-Agent`
#'     header
#' 
#' -   An `IPSet` that matches the IP address `192.0.2.44`
#' 
#' You then add the `Rule` to a `WebACL` and specify that you want to block
#' requests that satisfy the `Rule`. For a request to be blocked, the
#' `User-Agent` header in the request must contain the value `BadBot` *and*
#' the request must originate from the IP address 192.0.2.44.
#' 
#' To create and configure a `Rule`, perform the following steps:
#' 
#' 1.  Create and update the predicates that you want to include in the
#'     `Rule`.
#' 
#' 2.  Create the `Rule`. See [`create_rule`][waf_create_rule].
#' 
#' 3.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_rule`][waf_update_rule] request.
#' 
#' 4.  Submit an [`update_rule`][waf_update_rule] request to add predicates
#'     to the `Rule`.
#' 
#' 5.  Create and update a `WebACL` that contains the `Rule`. See
#'     [`create_web_acl`][waf_create_web_acl].
#' 
#' If you want to replace one `ByteMatchSet` or `IPSet` with another, you
#' delete the existing one and add the new one.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_rule(RuleId, ChangeToken, Updates)
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the `Rule` that you want to update. `RuleId` is returned
#' by [`create_rule`][waf_create_rule] and by
#' [`list_rules`][waf_list_rules].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `RuleUpdate` objects that you want to insert into or delete
#' from a Rule. For more information, see the applicable data types:
#' 
#' -   RuleUpdate: Contains `Action` and `Predicate`
#' 
#' -   Predicate: Contains `DataId`, `Negated`, and `Type`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_rule(
#'   RuleId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       Predicate = list(
#'         Negated = TRUE|FALSE,
#'         Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
#'         DataId = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a Predicate object in a rule with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$update_rule(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   RuleId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5",
#'   Updates = list(
#'     list(
#'       Action = "DELETE",
#'       Predicate = list(
#'         DataId = "MyByteMatchSetID",
#'         Negated = FALSE,
#'         Type = "ByteMatch"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_update_rule
waf_update_rule <- function(RuleId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_rule_input(RuleId = RuleId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_rule <- waf_update_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes ActivatedRule objects in a `RuleGroup`.
#' 
#' You can only insert `REGULAR` rules into a rule group.
#' 
#' You can have a maximum of ten rules per rule group.
#' 
#' To create and configure a `RuleGroup`, perform the following steps:
#' 
#' 1.  Create and update the `Rules` that you want to include in the
#'     `RuleGroup`. See [`create_rule`][waf_create_rule].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_rule_group`][waf_update_rule_group] request.
#' 
#' 3.  Submit an [`update_rule_group`][waf_update_rule_group] request to
#'     add `Rules` to the `RuleGroup`.
#' 
#' 4.  Create and update a `WebACL` that contains the `RuleGroup`. See
#'     [`create_web_acl`][waf_create_web_acl].
#' 
#' If you want to replace one `Rule` with another, you delete the existing
#' one and add the new one.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_rule_group(RuleGroupId, Updates, ChangeToken)
#'
#' @param RuleGroupId &#91;required&#93; The `RuleGroupId` of the RuleGroup that you want to update.
#' `RuleGroupId` is returned by
#' [`create_rule_group`][waf_create_rule_group] and by
#' [`list_rule_groups`][waf_list_rule_groups].
#' @param Updates &#91;required&#93; An array of `RuleGroupUpdate` objects that you want to insert into or
#' delete from a RuleGroup.
#' 
#' You can only insert `REGULAR` rules into a rule group.
#' 
#' `ActivatedRule|OverrideAction` applies only when updating or adding a
#' `RuleGroup` to a `WebACL`. In this case you do not use
#' `ActivatedRule|Action`. For all other update requests,
#' `ActivatedRule|Action` is used instead of
#' `ActivatedRule|OverrideAction`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_rule_group(
#'   RuleGroupId = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       ActivatedRule = list(
#'         Priority = 123,
#'         RuleId = "string",
#'         Action = list(
#'           Type = "BLOCK"|"ALLOW"|"COUNT"
#'         ),
#'         OverrideAction = list(
#'           Type = "NONE"|"COUNT"
#'         ),
#'         Type = "REGULAR"|"RATE_BASED"|"GROUP",
#'         ExcludedRules = list(
#'           list(
#'             RuleId = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname waf_update_rule_group
waf_update_rule_group <- function(RuleGroupId, Updates, ChangeToken) {
  op <- new_operation(
    name = "UpdateRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_rule_group_input(RuleGroupId = RuleGroupId, Updates = Updates, ChangeToken = ChangeToken)
  output <- .waf$update_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_rule_group <- waf_update_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes SizeConstraint objects (filters) in a
#' SizeConstraintSet. For each `SizeConstraint` object, you specify the
#' following values:
#' 
#' -   Whether to insert or delete the object from the array. If you want
#'     to change a `SizeConstraintSetUpdate` object, you delete the
#'     existing object and add a new one.
#' 
#' -   The part of a web request that you want AWS WAF to evaluate, such as
#'     the length of a query string or the length of the `User-Agent`
#'     header.
#' 
#' -   Whether to perform any transformations on the request, such as
#'     converting it to lowercase, before checking its length. Note that
#'     transformations of the request body are not supported because the
#'     AWS resource forwards only the first `8192` bytes of your request to
#'     AWS WAF.
#' 
#'     You can only specify a single type of TextTransformation.
#' 
#' -   A `ComparisonOperator` used for evaluating the selected part of the
#'     request against the specified `Size`, such as equals, greater than,
#'     less than, and so on.
#' 
#' -   The length, in bytes, that you want AWS WAF to watch for in selected
#'     part of the request. The length is computed after applying the
#'     transformation.
#' 
#' For example, you can add a `SizeConstraintSetUpdate` object that matches
#' web requests in which the length of the `User-Agent` header is greater
#' than 100 bytes. You can then configure AWS WAF to block those requests.
#' 
#' To create and configure a `SizeConstraintSet`, perform the following
#' steps:
#' 
#' 1.  Create a `SizeConstraintSet.` For more information, see
#'     [`create_size_constraint_set`][waf_create_size_constraint_set].
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_size_constraint_set`][waf_update_size_constraint_set]
#'     request.
#' 
#' 3.  Submit an
#'     [`update_size_constraint_set`][waf_update_size_constraint_set]
#'     request to specify the part of the request that you want AWS WAF to
#'     inspect (for example, the header or the URI) and the value that you
#'     want AWS WAF to watch for.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_size_constraint_set(SizeConstraintSetId, ChangeToken,
#'   Updates)
#'
#' @param SizeConstraintSetId &#91;required&#93; The `SizeConstraintSetId` of the SizeConstraintSet that you want to
#' update. `SizeConstraintSetId` is returned by
#' [`create_size_constraint_set`][waf_create_size_constraint_set] and by
#' [`list_size_constraint_sets`][waf_list_size_constraint_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `SizeConstraintSetUpdate` objects that you want to insert
#' into or delete from a SizeConstraintSet. For more information, see the
#' applicable data types:
#' 
#' -   SizeConstraintSetUpdate: Contains `Action` and `SizeConstraint`
#' 
#' -   SizeConstraint: Contains `FieldToMatch`, `TextTransformation`,
#'     `ComparisonOperator`, and `Size`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_size_constraint_set(
#'   SizeConstraintSetId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       SizeConstraint = list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE",
#'         ComparisonOperator = "EQ"|"NE"|"LE"|"LT"|"GE"|"GT",
#'         Size = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a SizeConstraint object (filters) in a
#' # size constraint set with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$update_size_constraint_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   SizeConstraintSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5",
#'   Updates = list(
#'     list(
#'       Action = "DELETE",
#'       SizeConstraint = list(
#'         ComparisonOperator = "GT",
#'         FieldToMatch = list(
#'           Type = "QUERY_STRING"
#'         ),
#'         Size = 0L,
#'         TextTransformation = "NONE"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_update_size_constraint_set
waf_update_size_constraint_set <- function(SizeConstraintSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateSizeConstraintSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_size_constraint_set_input(SizeConstraintSetId = SizeConstraintSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_size_constraint_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_size_constraint_set <- waf_update_size_constraint_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes SqlInjectionMatchTuple objects (filters) in a
#' SqlInjectionMatchSet. For each `SqlInjectionMatchTuple` object, you
#' specify the following values:
#' 
#' -   `Action`: Whether to insert the object into or delete the object
#'     from the array. To change a `SqlInjectionMatchTuple`, you delete the
#'     existing object and add a new one.
#' 
#' -   `FieldToMatch`: The part of web requests that you want AWS WAF to
#'     inspect and, if you want AWS WAF to inspect a header or custom query
#'     parameter, the name of the header or parameter.
#' 
#' -   `TextTransformation`: Which text transformation, if any, to perform
#'     on the web request before inspecting the request for snippets of
#'     malicious SQL code.
#' 
#'     You can only specify a single type of TextTransformation.
#' 
#' You use `SqlInjectionMatchSet` objects to specify which CloudFront
#' requests that you want to allow, block, or count. For example, if you're
#' receiving requests that contain snippets of SQL code in the query string
#' and you want to block the requests, you can create a
#' `SqlInjectionMatchSet` with the applicable settings, and then configure
#' AWS WAF to block the requests.
#' 
#' To create and configure a `SqlInjectionMatchSet`, perform the following
#' steps:
#' 
#' 1.  Submit a
#'     [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#'     request.
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_ip_set`][waf_update_ip_set] request.
#' 
#' 3.  Submit an
#'     [`update_sql_injection_match_set`][waf_update_sql_injection_match_set]
#'     request to specify the parts of web requests that you want AWS WAF
#'     to inspect for snippets of SQL code.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_sql_injection_match_set(SqlInjectionMatchSetId, ChangeToken,
#'   Updates)
#'
#' @param SqlInjectionMatchSetId &#91;required&#93; The `SqlInjectionMatchSetId` of the `SqlInjectionMatchSet` that you want
#' to update. `SqlInjectionMatchSetId` is returned by
#' [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#' and by
#' [`list_sql_injection_match_sets`][waf_list_sql_injection_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `SqlInjectionMatchSetUpdate` objects that you want to insert
#' into or delete from a SqlInjectionMatchSet. For more information, see
#' the applicable data types:
#' 
#' -   SqlInjectionMatchSetUpdate: Contains `Action` and
#'     `SqlInjectionMatchTuple`
#' 
#' -   SqlInjectionMatchTuple: Contains `FieldToMatch` and
#'     `TextTransformation`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_sql_injection_match_set(
#'   SqlInjectionMatchSetId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       SqlInjectionMatchTuple = list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes a SqlInjectionMatchTuple object (filters)
#' # in a SQL injection match set with the ID
#' # example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$update_sql_injection_match_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   SqlInjectionMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5",
#'   Updates = list(
#'     list(
#'       Action = "DELETE",
#'       SqlInjectionMatchTuple = list(
#'         FieldToMatch = list(
#'           Type = "QUERY_STRING"
#'         ),
#'         TextTransformation = "URL_DECODE"
#'       )
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_update_sql_injection_match_set
waf_update_sql_injection_match_set <- function(SqlInjectionMatchSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateSqlInjectionMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_sql_injection_match_set_input(SqlInjectionMatchSetId = SqlInjectionMatchSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_sql_injection_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_sql_injection_match_set <- waf_update_sql_injection_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes ActivatedRule objects in a `WebACL`. Each `Rule`
#' identifies web requests that you want to allow, block, or count. When
#' you update a `WebACL`, you specify the following values:
#' 
#' -   A default action for the `WebACL`, either `ALLOW` or `BLOCK`. AWS
#'     WAF performs the default action if a request doesn't match the
#'     criteria in any of the `Rules` in a `WebACL`.
#' 
#' -   The `Rules` that you want to add or delete. If you want to replace
#'     one `Rule` with another, you delete the existing `Rule` and add the
#'     new one.
#' 
#' -   For each `Rule`, whether you want AWS WAF to allow requests, block
#'     requests, or count requests that match the conditions in the `Rule`.
#' 
#' -   The order in which you want AWS WAF to evaluate the `Rules` in a
#'     `WebACL`. If you add more than one `Rule` to a `WebACL`, AWS WAF
#'     evaluates each request against the `Rules` in order based on the
#'     value of `Priority`. (The `Rule` that has the lowest value for
#'     `Priority` is evaluated first.) When a web request matches all the
#'     predicates (such as `ByteMatchSets` and `IPSets`) in a `Rule`, AWS
#'     WAF immediately takes the corresponding action, allow or block, and
#'     doesn't evaluate the request against the remaining `Rules` in the
#'     `WebACL`, if any.
#' 
#' To create and configure a `WebACL`, perform the following steps:
#' 
#' 1.  Create and update the predicates that you want to include in
#'     `Rules`. For more information, see
#'     [`create_byte_match_set`][waf_create_byte_match_set],
#'     [`update_byte_match_set`][waf_update_byte_match_set],
#'     [`create_ip_set`][waf_create_ip_set],
#'     [`update_ip_set`][waf_update_ip_set],
#'     [`create_sql_injection_match_set`][waf_create_sql_injection_match_set],
#'     and
#'     [`update_sql_injection_match_set`][waf_update_sql_injection_match_set].
#' 
#' 2.  Create and update the `Rules` that you want to include in the
#'     `WebACL`. For more information, see [`create_rule`][waf_create_rule]
#'     and [`update_rule`][waf_update_rule].
#' 
#' 3.  Create a `WebACL`. See [`create_web_acl`][waf_create_web_acl].
#' 
#' 4.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_web_acl`][waf_update_web_acl] request.
#' 
#' 5.  Submit an [`update_web_acl`][waf_update_web_acl] request to specify
#'     the `Rules` that you want to include in the `WebACL`, to specify the
#'     default action, and to associate the `WebACL` with a CloudFront
#'     distribution.
#' 
#'     The `ActivatedRule` can be a rule group. If you specify a rule group
#'     as your `ActivatedRule` , you can exclude specific rules from that
#'     rule group.
#' 
#'     If you already have a rule group associated with a web ACL and want
#'     to submit an [`update_web_acl`][waf_update_web_acl] request to
#'     exclude certain rules from that rule group, you must first remove
#'     the rule group from the web ACL, the re-insert it again, specifying
#'     the excluded rules. For details, see ActivatedRule$ExcludedRules .
#' 
#' Be aware that if you try to add a RATE_BASED rule to a web ACL without
#' setting the rule type when first creating the rule, the
#' [`update_web_acl`][waf_update_web_acl] request will fail because the
#' request tries to add a REGULAR rule (the default rule type) with the
#' specified ID, which does not exist.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_web_acl(WebACLId, ChangeToken, Updates, DefaultAction)
#'
#' @param WebACLId &#91;required&#93; The `WebACLId` of the WebACL that you want to update. `WebACLId` is
#' returned by [`create_web_acl`][waf_create_web_acl] and by
#' [`list_web_ac_ls`][waf_list_web_ac_ls].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates An array of updates to make to the WebACL.
#' 
#' An array of `WebACLUpdate` objects that you want to insert into or
#' delete from a WebACL. For more information, see the applicable data
#' types:
#' 
#' -   WebACLUpdate: Contains `Action` and `ActivatedRule`
#' 
#' -   ActivatedRule: Contains `Action`, `OverrideAction`, `Priority`,
#'     `RuleId`, and `Type`. `ActivatedRule|OverrideAction` applies only
#'     when updating or adding a `RuleGroup` to a `WebACL`. In this case,
#'     you do not use `ActivatedRule|Action`. For all other update
#'     requests, `ActivatedRule|Action` is used instead of
#'     `ActivatedRule|OverrideAction`.
#' 
#' -   WafAction: Contains `Type`
#' @param DefaultAction A default action for the web ACL, either ALLOW or BLOCK. AWS WAF
#' performs the default action if a request doesn't match the criteria in
#' any of the rules in a web ACL.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_web_acl(
#'   WebACLId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       ActivatedRule = list(
#'         Priority = 123,
#'         RuleId = "string",
#'         Action = list(
#'           Type = "BLOCK"|"ALLOW"|"COUNT"
#'         ),
#'         OverrideAction = list(
#'           Type = "NONE"|"COUNT"
#'         ),
#'         Type = "REGULAR"|"RATE_BASED"|"GROUP",
#'         ExcludedRules = list(
#'           list(
#'             RuleId = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   DefaultAction = list(
#'     Type = "BLOCK"|"ALLOW"|"COUNT"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes an ActivatedRule object in a WebACL with
#' # the ID webacl-1472061481310.
#' svc$update_web_acl(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   DefaultAction = list(
#'     Type = "ALLOW"
#'   ),
#'   Updates = list(
#'     list(
#'       Action = "DELETE",
#'       ActivatedRule = list(
#'         Action = list(
#'           Type = "ALLOW"
#'         ),
#'         Priority = 1L,
#'         RuleId = "WAFRule-1-Example"
#'       )
#'     )
#'   ),
#'   WebACLId = "webacl-1472061481310"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_update_web_acl
waf_update_web_acl <- function(WebACLId, ChangeToken, Updates = NULL, DefaultAction = NULL) {
  op <- new_operation(
    name = "UpdateWebACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_web_acl_input(WebACLId = WebACLId, ChangeToken = ChangeToken, Updates = Updates, DefaultAction = DefaultAction)
  output <- .waf$update_web_acl_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_web_acl <- waf_update_web_acl

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see
#' [AWS WAF
#' Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
#' in the developer guide.
#' 
#' **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the
#' [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
#' With the latest version, AWS WAF has a single set of endpoints for
#' regional and global use.
#' 
#' Inserts or deletes XssMatchTuple objects (filters) in an XssMatchSet.
#' For each `XssMatchTuple` object, you specify the following values:
#' 
#' -   `Action`: Whether to insert the object into or delete the object
#'     from the array. To change an `XssMatchTuple`, you delete the
#'     existing object and add a new one.
#' 
#' -   `FieldToMatch`: The part of web requests that you want AWS WAF to
#'     inspect and, if you want AWS WAF to inspect a header or custom query
#'     parameter, the name of the header or parameter.
#' 
#' -   `TextTransformation`: Which text transformation, if any, to perform
#'     on the web request before inspecting the request for cross-site
#'     scripting attacks.
#' 
#'     You can only specify a single type of TextTransformation.
#' 
#' You use `XssMatchSet` objects to specify which CloudFront requests that
#' you want to allow, block, or count. For example, if you're receiving
#' requests that contain cross-site scripting attacks in the request body
#' and you want to block the requests, you can create an `XssMatchSet` with
#' the applicable settings, and then configure AWS WAF to block the
#' requests.
#' 
#' To create and configure an `XssMatchSet`, perform the following steps:
#' 
#' 1.  Submit a [`create_xss_match_set`][waf_create_xss_match_set] request.
#' 
#' 2.  Use [`get_change_token`][waf_get_change_token] to get the change
#'     token that you provide in the `ChangeToken` parameter of an
#'     [`update_ip_set`][waf_update_ip_set] request.
#' 
#' 3.  Submit an [`update_xss_match_set`][waf_update_xss_match_set] request
#'     to specify the parts of web requests that you want AWS WAF to
#'     inspect for cross-site scripting attacks.
#' 
#' For more information about how to use the AWS WAF API to allow or block
#' HTTP requests, see the [AWS WAF Developer
#' Guide](https://docs.aws.amazon.com/waf/latest/developerguide/).
#'
#' @usage
#' waf_update_xss_match_set(XssMatchSetId, ChangeToken, Updates)
#'
#' @param XssMatchSetId &#91;required&#93; The `XssMatchSetId` of the `XssMatchSet` that you want to update.
#' `XssMatchSetId` is returned by
#' [`create_xss_match_set`][waf_create_xss_match_set] and by
#' [`list_xss_match_sets`][waf_list_xss_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `XssMatchSetUpdate` objects that you want to insert into or
#' delete from an XssMatchSet. For more information, see the applicable
#' data types:
#' 
#' -   XssMatchSetUpdate: Contains `Action` and `XssMatchTuple`
#' 
#' -   XssMatchTuple: Contains `FieldToMatch` and `TextTransformation`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ChangeToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_xss_match_set(
#'   XssMatchSetId = "string",
#'   ChangeToken = "string",
#'   Updates = list(
#'     list(
#'       Action = "INSERT"|"DELETE",
#'       XssMatchTuple = list(
#'         FieldToMatch = list(
#'           Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
#'           Data = "string"
#'         ),
#'         TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example deletes an XssMatchTuple object (filters) in an
#' # XssMatchSet with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
#' svc$update_xss_match_set(
#'   ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
#'   Updates = list(
#'     list(
#'       Action = "DELETE",
#'       XssMatchTuple = list(
#'         FieldToMatch = list(
#'           Type = "QUERY_STRING"
#'         ),
#'         TextTransformation = "URL_DECODE"
#'       )
#'     )
#'   ),
#'   XssMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname waf_update_xss_match_set
waf_update_xss_match_set <- function(XssMatchSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateXssMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_xss_match_set_input(XssMatchSetId = XssMatchSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_xss_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_xss_match_set <- waf_update_xss_match_set
