% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_verify_software_token}
\alias{cognitoidentityprovider_verify_software_token}
\title{Use this API to register a user's entered TOTP code and mark the user's
software token MFA status as "verified" if successful}
\usage{
cognitoidentityprovider_verify_software_token(AccessToken, Session,
  UserCode, FriendlyDeviceName)
}
\arguments{
\item{AccessToken}{The access token.}

\item{Session}{The session which should be passed both ways in challenge-response calls
to the service.}

\item{UserCode}{[required] The one time password computed using the secret code returned by
\href{https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AssociateSoftwareToken.html}{AssociateSoftwareToken"}.}

\item{FriendlyDeviceName}{The friendly device name.}
}
\value{
A list with the following syntax:\preformatted{list(
  Status = "SUCCESS"|"ERROR",
  Session = "string"
)
}
}
\description{
Use this API to register a user's entered TOTP code and mark the user's
software token MFA status as "verified" if successful. The request takes
an access token or a session string, but not both.
}
\section{Request syntax}{
\preformatted{svc$verify_software_token(
  AccessToken = "string",
  Session = "string",
  UserCode = "string",
  FriendlyDeviceName = "string"
)
}
}

\keyword{internal}
