% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_virtual_mfa_device}
\alias{iam_create_virtual_mfa_device}
\title{Creates a new virtual MFA device for the AWS account}
\usage{
iam_create_virtual_mfa_device(Path, VirtualMFADeviceName)
}
\arguments{
\item{Path}{The path for the virtual MFA device. For more information about paths,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\verb{\\u0021}) through the DEL character
(\verb{\\u007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{VirtualMFADeviceName}{[required] The name of the virtual MFA device. Use with path to uniquely identify a
virtual MFA device.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}
}
\value{
A list with the following syntax:\preformatted{list(
  VirtualMFADevice = list(
    SerialNumber = "string",
    Base32StringSeed = raw,
    QRCodePNG = raw,
    User = list(
      Path = "string",
      UserName = "string",
      UserId = "string",
      Arn = "string",
      CreateDate = as.POSIXct(
        "2015-01-01"
      ),
      PasswordLastUsed = as.POSIXct(
        "2015-01-01"
      ),
      PermissionsBoundary = list(
        PermissionsBoundaryType = "PermissionsBoundaryPolicy",
        PermissionsBoundaryArn = "string"
      ),
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    ),
    EnableDate = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Creates a new virtual MFA device for the AWS account. After creating the
virtual MFA, use \code{\link[=iam_enable_mfa_device]{enable_mfa_device}} to attach
the MFA device to an IAM user. For more information about creating and
working with virtual MFA devices, go to \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_enable_virtual.html}{Using a Virtual MFA Device}
in the \emph{IAM User Guide}.

The number and size of IAM resources in an AWS account are limited. For
more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html}{IAM and STS Quotas}
in the \emph{IAM User Guide}.

The seed information contained in the QR code and the Base32 string
should be treated like any other secret access information. In other
words, protect the seed information as you would your AWS access keys or
your passwords. After you provision your virtual device, you should
ensure that the information is destroyed following secure procedures.
}
\section{Request syntax}{
\preformatted{svc$create_virtual_mfa_device(
  Path = "string",
  VirtualMFADeviceName = "string"
)
}
}

\keyword{internal}
