% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_set_identity_pool_roles}
\alias{cognitoidentity_set_identity_pool_roles}
\title{Sets the roles for an identity pool}
\usage{
cognitoidentity_set_identity_pool_roles(IdentityPoolId, Roles,
  RoleMappings)
}
\arguments{
\item{IdentityPoolId}{[required] An identity pool ID in the format REGION:GUID.}

\item{Roles}{[required] The map of roles associated with this pool. For a given role, the key
will be either "authenticated" or "unauthenticated" and the value
will be the Role ARN.}

\item{RoleMappings}{How users for a specific identity provider are to mapped to roles. This
is a string to RoleMapping object map. The string identifies the
identity provider, for example, "graph.facebook.com" or
"cognito-idp-east-1.amazonaws.com/us-east-1\_abcdefghi:app\_client\_id".

Up to 25 rules can be specified per identity provider.}
}
\description{
Sets the roles for an identity pool. These roles are used when making
calls to GetCredentialsForIdentity action.
}
\details{
You must use AWS Developer credentials to call this API.
}
\section{Request syntax}{
\preformatted{svc$set_identity_pool_roles(
  IdentityPoolId = "string",
  Roles = list(
    "string"
  ),
  RoleMappings = list(
    list(
      Type = "Token"|"Rules",
      AmbiguousRoleResolution = "AuthenticatedRole"|"Deny",
      RulesConfiguration = list(
        Rules = list(
          list(
            Claim = "string",
            MatchType = "Equals"|"Contains"|"StartsWith"|"NotEqual",
            Value = "string",
            RoleARN = "string"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
