% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_attach_role_policy}
\alias{iam_attach_role_policy}
\title{Attaches the specified managed policy to the specified IAM role}
\usage{
iam_attach_role_policy(RoleName, PolicyArn)
}
\arguments{
\item{RoleName}{[required] The name (friendly name, not ARN) of the role to attach the policy to.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \_+=,.@-}

\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the IAM policy you want to attach.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}
}
\description{
Attaches the specified managed policy to the specified IAM role. When
you attach a managed policy to a role, the managed policy becomes part
of the role's permission (access) policy.
}
\details{
You cannot use a managed policy as the role's trust policy. The role's
trust policy is created at the same time as the role, using CreateRole.
You can update a role's trust policy using UpdateAssumeRolePolicy.

Use this API to attach a \emph{managed} policy to a role. To embed an inline
policy in a role, use PutRolePolicy. For more information about
policies, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$attach_role_policy(
  RoleName = "string",
  PolicyArn = "string"
)
}
}

\examples{
# The following command attaches the AWS managed policy named
# ReadOnlyAccess to the IAM role named ReadOnlyRole.
\donttest{svc$attach_role_policy(
  PolicyArn = "arn:aws:iam::aws:policy/ReadOnlyAccess",
  RoleName = "ReadOnlyRole"
)}

}
\keyword{internal}
