% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_members}
\alias{guardduty_create_members}
\title{Creates member accounts of the current AWS account by specifying a list
of AWS account IDs}
\usage{
guardduty_create_members(DetectorId, AccountDetails)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector of the GuardDuty account that you want to
associate member accounts with.}

\item{AccountDetails}{[required] A list of account ID and email address pairs of the accounts that you
want to associate with the master GuardDuty account.}
}
\description{
Creates member accounts of the current AWS account by specifying a list
of AWS account IDs. The current AWS account can then invite these
members to manage GuardDuty in their accounts.
}
\section{Request syntax}{
\preformatted{svc$create_members(
  DetectorId = "string",
  AccountDetails = list(
    list(
      AccountId = "string",
      Email = "string"
    )
  )
)
}
}

\keyword{internal}
