# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include fms_service.R
NULL

#' Sets the Firewall Manager administrator account
#'
#' @description
#' Sets the Firewall Manager administrator account. The account must be a member of the organization in Organizations whose resources you want to protect. Firewall Manager sets the permissions that allow the account to administer your Firewall Manager policies.
#'
#' See [https://paws-r.github.io/docs/fms/associate_admin_account.html](https://paws-r.github.io/docs/fms/associate_admin_account.html) for full documentation.
#'
#' @param AdminAccount &#91;required&#93; The Amazon Web Services account ID to associate with Firewall Manager as
#' the Firewall Manager administrator account. This must be an
#' Organizations member account. For more information about Organizations,
#' see [Managing the Amazon Web Services Accounts in Your
#' Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html).
#'
#' @keywords internal
#'
#' @rdname fms_associate_admin_account
fms_associate_admin_account <- function(AdminAccount) {
  op <- new_operation(
    name = "AssociateAdminAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$associate_admin_account_input(AdminAccount = AdminAccount)
  output <- .fms$associate_admin_account_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$associate_admin_account <- fms_associate_admin_account

#' Sets the Firewall Manager policy administrator as a tenant administrator
#' of a third-party firewall service
#'
#' @description
#' Sets the Firewall Manager policy administrator as a tenant administrator of a third-party firewall service. A tenant is an instance of the third-party firewall service that's associated with your Amazon Web Services customer account.
#'
#' See [https://paws-r.github.io/docs/fms/associate_third_party_firewall.html](https://paws-r.github.io/docs/fms/associate_third_party_firewall.html) for full documentation.
#'
#' @param ThirdPartyFirewall &#91;required&#93; The name of the third-party firewall vendor.
#'
#' @keywords internal
#'
#' @rdname fms_associate_third_party_firewall
fms_associate_third_party_firewall <- function(ThirdPartyFirewall) {
  op <- new_operation(
    name = "AssociateThirdPartyFirewall",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$associate_third_party_firewall_input(ThirdPartyFirewall = ThirdPartyFirewall)
  output <- .fms$associate_third_party_firewall_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$associate_third_party_firewall <- fms_associate_third_party_firewall

#' Permanently deletes an Firewall Manager applications list
#'
#' @description
#' Permanently deletes an Firewall Manager applications list.
#'
#' See [https://paws-r.github.io/docs/fms/delete_apps_list.html](https://paws-r.github.io/docs/fms/delete_apps_list.html) for full documentation.
#'
#' @param ListId &#91;required&#93; The ID of the applications list that you want to delete. You can
#' retrieve this ID from [`put_apps_list`][fms_put_apps_list],
#' [`list_apps_lists`][fms_list_apps_lists], and
#' [`get_apps_list`][fms_get_apps_list].
#'
#' @keywords internal
#'
#' @rdname fms_delete_apps_list
fms_delete_apps_list <- function(ListId) {
  op <- new_operation(
    name = "DeleteAppsList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$delete_apps_list_input(ListId = ListId)
  output <- .fms$delete_apps_list_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$delete_apps_list <- fms_delete_apps_list

#' Deletes an Firewall Manager association with the IAM role and the Amazon
#' Simple Notification Service (SNS) topic that is used to record Firewall
#' Manager SNS logs
#'
#' @description
#' Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.
#'
#' See [https://paws-r.github.io/docs/fms/delete_notification_channel.html](https://paws-r.github.io/docs/fms/delete_notification_channel.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname fms_delete_notification_channel
fms_delete_notification_channel <- function() {
  op <- new_operation(
    name = "DeleteNotificationChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$delete_notification_channel_input()
  output <- .fms$delete_notification_channel_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$delete_notification_channel <- fms_delete_notification_channel

#' Permanently deletes an Firewall Manager policy
#'
#' @description
#' Permanently deletes an Firewall Manager policy.
#'
#' See [https://paws-r.github.io/docs/fms/delete_policy.html](https://paws-r.github.io/docs/fms/delete_policy.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The ID of the policy that you want to delete. You can retrieve this ID
#' from [`put_policy`][fms_put_policy] and
#' [`list_policies`][fms_list_policies].
#' @param DeleteAllPolicyResources If `True`, the request performs cleanup according to the policy type.
#' 
#' For WAF and Shield Advanced policies, the cleanup does the following:
#' 
#' -   Deletes rule groups created by Firewall Manager
#' 
#' -   Removes web ACLs from in-scope resources
#' 
#' -   Deletes web ACLs that contain no rules or rule groups
#' 
#' For security group policies, the cleanup does the following for each
#' security group in the policy:
#' 
#' -   Disassociates the security group from in-scope resources
#' 
#' -   Deletes the security group if it was created through Firewall
#'     Manager and if it's no longer associated with any resources through
#'     another policy
#' 
#' After the cleanup, in-scope resources are no longer protected by web
#' ACLs in this policy. Protection of out-of-scope resources remains
#' unchanged. Scope is determined by tags that you create and accounts that
#' you associate with the policy. When creating the policy, if you specify
#' that only resources in specific accounts or with specific tags are in
#' scope of the policy, those accounts and resources are handled by the
#' policy. All others are out of scope. If you don't specify tags or
#' accounts, all resources are in scope.
#'
#' @keywords internal
#'
#' @rdname fms_delete_policy
fms_delete_policy <- function(PolicyId, DeleteAllPolicyResources = NULL) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$delete_policy_input(PolicyId = PolicyId, DeleteAllPolicyResources = DeleteAllPolicyResources)
  output <- .fms$delete_policy_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$delete_policy <- fms_delete_policy

#' Permanently deletes an Firewall Manager protocols list
#'
#' @description
#' Permanently deletes an Firewall Manager protocols list.
#'
#' See [https://paws-r.github.io/docs/fms/delete_protocols_list.html](https://paws-r.github.io/docs/fms/delete_protocols_list.html) for full documentation.
#'
#' @param ListId &#91;required&#93; The ID of the protocols list that you want to delete. You can retrieve
#' this ID from [`put_protocols_list`][fms_put_protocols_list],
#' [`list_protocols_lists`][fms_list_protocols_lists], and
#' `GetProtocolsLost`.
#'
#' @keywords internal
#'
#' @rdname fms_delete_protocols_list
fms_delete_protocols_list <- function(ListId) {
  op <- new_operation(
    name = "DeleteProtocolsList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$delete_protocols_list_input(ListId = ListId)
  output <- .fms$delete_protocols_list_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$delete_protocols_list <- fms_delete_protocols_list

#' Disassociates the account that has been set as the Firewall Manager
#' administrator account
#'
#' @description
#' Disassociates the account that has been set as the Firewall Manager administrator account. To set a different account as the administrator account, you must submit an [`associate_admin_account`][fms_associate_admin_account] request.
#'
#' See [https://paws-r.github.io/docs/fms/disassociate_admin_account.html](https://paws-r.github.io/docs/fms/disassociate_admin_account.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname fms_disassociate_admin_account
fms_disassociate_admin_account <- function() {
  op <- new_operation(
    name = "DisassociateAdminAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$disassociate_admin_account_input()
  output <- .fms$disassociate_admin_account_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$disassociate_admin_account <- fms_disassociate_admin_account

#' Disassociates a Firewall Manager policy administrator from a third-party
#' firewall tenant
#'
#' @description
#' Disassociates a Firewall Manager policy administrator from a third-party firewall tenant. When you call [`disassociate_third_party_firewall`][fms_disassociate_third_party_firewall], the third-party firewall vendor deletes all of the firewalls that are associated with the account.
#'
#' See [https://paws-r.github.io/docs/fms/disassociate_third_party_firewall.html](https://paws-r.github.io/docs/fms/disassociate_third_party_firewall.html) for full documentation.
#'
#' @param ThirdPartyFirewall &#91;required&#93; The name of the third-party firewall vendor.
#'
#' @keywords internal
#'
#' @rdname fms_disassociate_third_party_firewall
fms_disassociate_third_party_firewall <- function(ThirdPartyFirewall) {
  op <- new_operation(
    name = "DisassociateThirdPartyFirewall",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$disassociate_third_party_firewall_input(ThirdPartyFirewall = ThirdPartyFirewall)
  output <- .fms$disassociate_third_party_firewall_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$disassociate_third_party_firewall <- fms_disassociate_third_party_firewall

#' Returns the Organizations account that is associated with Firewall
#' Manager as the Firewall Manager administrator
#'
#' @description
#' Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager administrator.
#'
#' See [https://paws-r.github.io/docs/fms/get_admin_account.html](https://paws-r.github.io/docs/fms/get_admin_account.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname fms_get_admin_account
fms_get_admin_account <- function() {
  op <- new_operation(
    name = "GetAdminAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_admin_account_input()
  output <- .fms$get_admin_account_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_admin_account <- fms_get_admin_account

#' Returns information about the specified Firewall Manager applications
#' list
#'
#' @description
#' Returns information about the specified Firewall Manager applications list.
#'
#' See [https://paws-r.github.io/docs/fms/get_apps_list.html](https://paws-r.github.io/docs/fms/get_apps_list.html) for full documentation.
#'
#' @param ListId &#91;required&#93; The ID of the Firewall Manager applications list that you want the
#' details for.
#' @param DefaultList Specifies whether the list to retrieve is a default list owned by
#' Firewall Manager.
#'
#' @keywords internal
#'
#' @rdname fms_get_apps_list
fms_get_apps_list <- function(ListId, DefaultList = NULL) {
  op <- new_operation(
    name = "GetAppsList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_apps_list_input(ListId = ListId, DefaultList = DefaultList)
  output <- .fms$get_apps_list_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_apps_list <- fms_get_apps_list

#' Returns detailed compliance information about the specified member
#' account
#'
#' @description
#' Returns detailed compliance information about the specified member account. Details include resources that are in and out of compliance with the specified policy.
#'
#' See [https://paws-r.github.io/docs/fms/get_compliance_detail.html](https://paws-r.github.io/docs/fms/get_compliance_detail.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The ID of the policy that you want to get the details for. `PolicyId` is
#' returned by [`put_policy`][fms_put_policy] and by
#' [`list_policies`][fms_list_policies].
#' @param MemberAccount &#91;required&#93; The Amazon Web Services account that owns the resources that you want to
#' get the details for.
#'
#' @keywords internal
#'
#' @rdname fms_get_compliance_detail
fms_get_compliance_detail <- function(PolicyId, MemberAccount) {
  op <- new_operation(
    name = "GetComplianceDetail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_compliance_detail_input(PolicyId = PolicyId, MemberAccount = MemberAccount)
  output <- .fms$get_compliance_detail_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_compliance_detail <- fms_get_compliance_detail

#' Information about the Amazon Simple Notification Service (SNS) topic
#' that is used to record Firewall Manager SNS logs
#'
#' @description
#' Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.
#'
#' See [https://paws-r.github.io/docs/fms/get_notification_channel.html](https://paws-r.github.io/docs/fms/get_notification_channel.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname fms_get_notification_channel
fms_get_notification_channel <- function() {
  op <- new_operation(
    name = "GetNotificationChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_notification_channel_input()
  output <- .fms$get_notification_channel_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_notification_channel <- fms_get_notification_channel

#' Returns information about the specified Firewall Manager policy
#'
#' @description
#' Returns information about the specified Firewall Manager policy.
#'
#' See [https://paws-r.github.io/docs/fms/get_policy.html](https://paws-r.github.io/docs/fms/get_policy.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The ID of the Firewall Manager policy that you want the details for.
#'
#' @keywords internal
#'
#' @rdname fms_get_policy
fms_get_policy <- function(PolicyId) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_policy_input(PolicyId = PolicyId)
  output <- .fms$get_policy_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_policy <- fms_get_policy

#' If you created a Shield Advanced policy, returns policy-level attack
#' summary information in the event of a potential DDoS attack
#'
#' @description
#' If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack. Other policy types are currently unsupported.
#'
#' See [https://paws-r.github.io/docs/fms/get_protection_status.html](https://paws-r.github.io/docs/fms/get_protection_status.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The ID of the policy for which you want to get the attack information.
#' @param MemberAccountId The Amazon Web Services account that is in scope of the policy that you
#' want to get the details for.
#' @param StartTime The start of the time period to query for the attacks. This is a
#' `timestamp` type. The request syntax listing indicates a `number` type
#' because the default used by Firewall Manager is Unix time in seconds.
#' However, any valid `timestamp` format is allowed.
#' @param EndTime The end of the time period to query for the attacks. This is a
#' `timestamp` type. The request syntax listing indicates a `number` type
#' because the default used by Firewall Manager is Unix time in seconds.
#' However, any valid `timestamp` format is allowed.
#' @param NextToken If you specify a value for `MaxResults` and you have more objects than
#' the number that you specify for `MaxResults`, Firewall Manager returns a
#' `NextToken` value in the response, which you can use to retrieve another
#' group of objects. For the second and subsequent
#' [`get_protection_status`][fms_get_protection_status] requests, specify
#' the value of `NextToken` from the previous response to get information
#' about another batch of objects.
#' @param MaxResults Specifies the number of objects that you want Firewall Manager to return
#' for this request. If you have more objects than the number that you
#' specify for `MaxResults`, the response includes a `NextToken` value that
#' you can use to get another batch of objects.
#'
#' @keywords internal
#'
#' @rdname fms_get_protection_status
fms_get_protection_status <- function(PolicyId, MemberAccountId = NULL, StartTime = NULL, EndTime = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetProtectionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_protection_status_input(PolicyId = PolicyId, MemberAccountId = MemberAccountId, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$get_protection_status_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_protection_status <- fms_get_protection_status

#' Returns information about the specified Firewall Manager protocols list
#'
#' @description
#' Returns information about the specified Firewall Manager protocols list.
#'
#' See [https://paws-r.github.io/docs/fms/get_protocols_list.html](https://paws-r.github.io/docs/fms/get_protocols_list.html) for full documentation.
#'
#' @param ListId &#91;required&#93; The ID of the Firewall Manager protocols list that you want the details
#' for.
#' @param DefaultList Specifies whether the list to retrieve is a default list owned by
#' Firewall Manager.
#'
#' @keywords internal
#'
#' @rdname fms_get_protocols_list
fms_get_protocols_list <- function(ListId, DefaultList = NULL) {
  op <- new_operation(
    name = "GetProtocolsList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_protocols_list_input(ListId = ListId, DefaultList = DefaultList)
  output <- .fms$get_protocols_list_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_protocols_list <- fms_get_protocols_list

#' The onboarding status of a Firewall Manager admin account to third-party
#' firewall vendor tenant
#'
#' @description
#' The onboarding status of a Firewall Manager admin account to third-party firewall vendor tenant.
#'
#' See [https://paws-r.github.io/docs/fms/get_third_party_firewall_association_status.html](https://paws-r.github.io/docs/fms/get_third_party_firewall_association_status.html) for full documentation.
#'
#' @param ThirdPartyFirewall &#91;required&#93; The name of the third-party firewall vendor.
#'
#' @keywords internal
#'
#' @rdname fms_get_third_party_firewall_association_status
fms_get_third_party_firewall_association_status <- function(ThirdPartyFirewall) {
  op <- new_operation(
    name = "GetThirdPartyFirewallAssociationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_third_party_firewall_association_status_input(ThirdPartyFirewall = ThirdPartyFirewall)
  output <- .fms$get_third_party_firewall_association_status_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_third_party_firewall_association_status <- fms_get_third_party_firewall_association_status

#' Retrieves violations for a resource based on the specified Firewall
#' Manager policy and Amazon Web Services account
#'
#' @description
#' Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/fms/get_violation_details.html](https://paws-r.github.io/docs/fms/get_violation_details.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The ID of the Firewall Manager policy that you want the details for.
#' This currently only supports security group content audit policies.
#' @param MemberAccount &#91;required&#93; The Amazon Web Services account ID that you want the details for.
#' @param ResourceId &#91;required&#93; The ID of the resource that has violations.
#' @param ResourceType &#91;required&#93; The resource type. This is in the format shown in the [Amazon Web
#' Services Resource Types
#' Reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html).
#' Supported resource types are: `AWS::EC2::Instance`,
#' `AWS::EC2::NetworkInterface`, `AWS::EC2::SecurityGroup`,
#' `AWS::NetworkFirewall::FirewallPolicy`, and `AWS::EC2::Subnet`.
#'
#' @keywords internal
#'
#' @rdname fms_get_violation_details
fms_get_violation_details <- function(PolicyId, MemberAccount, ResourceId, ResourceType) {
  op <- new_operation(
    name = "GetViolationDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_violation_details_input(PolicyId = PolicyId, MemberAccount = MemberAccount, ResourceId = ResourceId, ResourceType = ResourceType)
  output <- .fms$get_violation_details_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_violation_details <- fms_get_violation_details

#' Returns an array of AppsListDataSummary objects
#'
#' @description
#' Returns an array of `AppsListDataSummary` objects.
#'
#' See [https://paws-r.github.io/docs/fms/list_apps_lists.html](https://paws-r.github.io/docs/fms/list_apps_lists.html) for full documentation.
#'
#' @param DefaultLists Specifies whether the lists to retrieve are default lists owned by
#' Firewall Manager.
#' @param NextToken If you specify a value for `MaxResults` in your list request, and you
#' have more objects than the maximum, Firewall Manager returns this token
#' in the response. For all but the first request, you provide the token
#' returned by the prior request in the request parameters, to retrieve the
#' next batch of objects.
#' @param MaxResults &#91;required&#93; The maximum number of objects that you want Firewall Manager to return
#' for this request. If more objects are available, in the response,
#' Firewall Manager provides a `NextToken` value that you can use in a
#' subsequent call to get the next batch of objects.
#' 
#' If you don't specify this, Firewall Manager returns all available
#' objects.
#'
#' @keywords internal
#'
#' @rdname fms_list_apps_lists
fms_list_apps_lists <- function(DefaultLists = NULL, NextToken = NULL, MaxResults) {
  op <- new_operation(
    name = "ListAppsLists",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_apps_lists_input(DefaultLists = DefaultLists, NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_apps_lists_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_apps_lists <- fms_list_apps_lists

#' Returns an array of PolicyComplianceStatus objects
#'
#' @description
#' Returns an array of `PolicyComplianceStatus` objects. Use `PolicyComplianceStatus` to get a summary of which member accounts are protected by the specified policy.
#'
#' See [https://paws-r.github.io/docs/fms/list_compliance_status.html](https://paws-r.github.io/docs/fms/list_compliance_status.html) for full documentation.
#'
#' @param PolicyId &#91;required&#93; The ID of the Firewall Manager policy that you want the details for.
#' @param NextToken If you specify a value for `MaxResults` and you have more
#' `PolicyComplianceStatus` objects than the number that you specify for
#' `MaxResults`, Firewall Manager returns a `NextToken` value in the
#' response that allows you to list another group of
#' `PolicyComplianceStatus` objects. For the second and subsequent
#' [`list_compliance_status`][fms_list_compliance_status] requests, specify
#' the value of `NextToken` from the previous response to get information
#' about another batch of `PolicyComplianceStatus` objects.
#' @param MaxResults Specifies the number of `PolicyComplianceStatus` objects that you want
#' Firewall Manager to return for this request. If you have more
#' `PolicyComplianceStatus` objects than the number that you specify for
#' `MaxResults`, the response includes a `NextToken` value that you can use
#' to get another batch of `PolicyComplianceStatus` objects.
#'
#' @keywords internal
#'
#' @rdname fms_list_compliance_status
fms_list_compliance_status <- function(PolicyId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListComplianceStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_compliance_status_input(PolicyId = PolicyId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_compliance_status_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_compliance_status <- fms_list_compliance_status

#' Returns a MemberAccounts object that lists the member accounts in the
#' administrator's Amazon Web Services organization
#'
#' @description
#' Returns a `MemberAccounts` object that lists the member accounts in the administrator's Amazon Web Services organization.
#'
#' See [https://paws-r.github.io/docs/fms/list_member_accounts.html](https://paws-r.github.io/docs/fms/list_member_accounts.html) for full documentation.
#'
#' @param NextToken If you specify a value for `MaxResults` and you have more account IDs
#' than the number that you specify for `MaxResults`, Firewall Manager
#' returns a `NextToken` value in the response that allows you to list
#' another group of IDs. For the second and subsequent
#' `ListMemberAccountsRequest` requests, specify the value of `NextToken`
#' from the previous response to get information about another batch of
#' member account IDs.
#' @param MaxResults Specifies the number of member account IDs that you want Firewall
#' Manager to return for this request. If you have more IDs than the number
#' that you specify for `MaxResults`, the response includes a `NextToken`
#' value that you can use to get another batch of member account IDs.
#'
#' @keywords internal
#'
#' @rdname fms_list_member_accounts
fms_list_member_accounts <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMemberAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_member_accounts_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_member_accounts_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_member_accounts <- fms_list_member_accounts

#' Returns an array of PolicySummary objects
#'
#' @description
#' Returns an array of `PolicySummary` objects.
#'
#' See [https://paws-r.github.io/docs/fms/list_policies.html](https://paws-r.github.io/docs/fms/list_policies.html) for full documentation.
#'
#' @param NextToken If you specify a value for `MaxResults` and you have more
#' `PolicySummary` objects than the number that you specify for
#' `MaxResults`, Firewall Manager returns a `NextToken` value in the
#' response that allows you to list another group of `PolicySummary`
#' objects. For the second and subsequent
#' [`list_policies`][fms_list_policies] requests, specify the value of
#' `NextToken` from the previous response to get information about another
#' batch of `PolicySummary` objects.
#' @param MaxResults Specifies the number of `PolicySummary` objects that you want Firewall
#' Manager to return for this request. If you have more `PolicySummary`
#' objects than the number that you specify for `MaxResults`, the response
#' includes a `NextToken` value that you can use to get another batch of
#' `PolicySummary` objects.
#'
#' @keywords internal
#'
#' @rdname fms_list_policies
fms_list_policies <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_policies_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_policies_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_policies <- fms_list_policies

#' Returns an array of ProtocolsListDataSummary objects
#'
#' @description
#' Returns an array of `ProtocolsListDataSummary` objects.
#'
#' See [https://paws-r.github.io/docs/fms/list_protocols_lists.html](https://paws-r.github.io/docs/fms/list_protocols_lists.html) for full documentation.
#'
#' @param DefaultLists Specifies whether the lists to retrieve are default lists owned by
#' Firewall Manager.
#' @param NextToken If you specify a value for `MaxResults` in your list request, and you
#' have more objects than the maximum, Firewall Manager returns this token
#' in the response. For all but the first request, you provide the token
#' returned by the prior request in the request parameters, to retrieve the
#' next batch of objects.
#' @param MaxResults &#91;required&#93; The maximum number of objects that you want Firewall Manager to return
#' for this request. If more objects are available, in the response,
#' Firewall Manager provides a `NextToken` value that you can use in a
#' subsequent call to get the next batch of objects.
#' 
#' If you don't specify this, Firewall Manager returns all available
#' objects.
#'
#' @keywords internal
#'
#' @rdname fms_list_protocols_lists
fms_list_protocols_lists <- function(DefaultLists = NULL, NextToken = NULL, MaxResults) {
  op <- new_operation(
    name = "ListProtocolsLists",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_protocols_lists_input(DefaultLists = DefaultLists, NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_protocols_lists_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_protocols_lists <- fms_list_protocols_lists

#' Retrieves the list of tags for the specified Amazon Web Services
#' resource
#'
#' @description
#' Retrieves the list of tags for the specified Amazon Web Services resource.
#'
#' See [https://paws-r.github.io/docs/fms/list_tags_for_resource.html](https://paws-r.github.io/docs/fms/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to return tags for. The
#' Firewall Manager resources that support tagging are policies,
#' applications lists, and protocols lists.
#'
#' @keywords internal
#'
#' @rdname fms_list_tags_for_resource
fms_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .fms$list_tags_for_resource_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_tags_for_resource <- fms_list_tags_for_resource

#' Retrieves a list of all of the third-party firewall policies that are
#' associated with the third-party firewall administrator's account
#'
#' @description
#' Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall administrator's account.
#'
#' See [https://paws-r.github.io/docs/fms/list_third_party_firewall_firewall_policies.html](https://paws-r.github.io/docs/fms/list_third_party_firewall_firewall_policies.html) for full documentation.
#'
#' @param ThirdPartyFirewall &#91;required&#93; The name of the third-party firewall vendor.
#' @param NextToken If the previous response included a `NextToken` element, the specified
#' third-party firewall vendor is associated with more third-party firewall
#' policies. To get more third-party firewall policies, submit another
#' `ListThirdPartyFirewallFirewallPoliciesRequest` request.
#' 
#' For the value of `NextToken`, specify the value of `NextToken` from the
#' previous response. If the previous response didn't include a `NextToken`
#' element, there are no more third-party firewall policies to get.
#' @param MaxResults &#91;required&#93; The maximum number of third-party firewall policies that you want
#' Firewall Manager to return. If the specified third-party firewall vendor
#' is associated with more than `MaxResults` firewall policies, the
#' response includes a `NextToken` element. `NextToken` contains an
#' encrypted token that identifies the first third-party firewall policies
#' that Firewall Manager will return if you submit another request.
#'
#' @keywords internal
#'
#' @rdname fms_list_third_party_firewall_firewall_policies
fms_list_third_party_firewall_firewall_policies <- function(ThirdPartyFirewall, NextToken = NULL, MaxResults) {
  op <- new_operation(
    name = "ListThirdPartyFirewallFirewallPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_third_party_firewall_firewall_policies_input(ThirdPartyFirewall = ThirdPartyFirewall, NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_third_party_firewall_firewall_policies_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_third_party_firewall_firewall_policies <- fms_list_third_party_firewall_firewall_policies

#' Creates an Firewall Manager applications list
#'
#' @description
#' Creates an Firewall Manager applications list.
#'
#' See [https://paws-r.github.io/docs/fms/put_apps_list.html](https://paws-r.github.io/docs/fms/put_apps_list.html) for full documentation.
#'
#' @param AppsList &#91;required&#93; The details of the Firewall Manager applications list to be created.
#' @param TagList The tags associated with the resource.
#'
#' @keywords internal
#'
#' @rdname fms_put_apps_list
fms_put_apps_list <- function(AppsList, TagList = NULL) {
  op <- new_operation(
    name = "PutAppsList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$put_apps_list_input(AppsList = AppsList, TagList = TagList)
  output <- .fms$put_apps_list_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$put_apps_list <- fms_put_apps_list

#' Designates the IAM role and Amazon Simple Notification Service (SNS)
#' topic that Firewall Manager uses to record SNS logs
#'
#' @description
#' Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record SNS logs.
#'
#' See [https://paws-r.github.io/docs/fms/put_notification_channel.html](https://paws-r.github.io/docs/fms/put_notification_channel.html) for full documentation.
#'
#' @param SnsTopicArn &#91;required&#93; The Amazon Resource Name (ARN) of the SNS topic that collects
#' notifications from Firewall Manager.
#' @param SnsRoleName &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to
#' record Firewall Manager activity.
#'
#' @keywords internal
#'
#' @rdname fms_put_notification_channel
fms_put_notification_channel <- function(SnsTopicArn, SnsRoleName) {
  op <- new_operation(
    name = "PutNotificationChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$put_notification_channel_input(SnsTopicArn = SnsTopicArn, SnsRoleName = SnsRoleName)
  output <- .fms$put_notification_channel_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$put_notification_channel <- fms_put_notification_channel

#' Creates an Firewall Manager policy
#'
#' @description
#' Creates an Firewall Manager policy.
#'
#' See [https://paws-r.github.io/docs/fms/put_policy.html](https://paws-r.github.io/docs/fms/put_policy.html) for full documentation.
#'
#' @param Policy &#91;required&#93; The details of the Firewall Manager policy to be created.
#' @param TagList The tags to add to the Amazon Web Services resource.
#'
#' @keywords internal
#'
#' @rdname fms_put_policy
fms_put_policy <- function(Policy, TagList = NULL) {
  op <- new_operation(
    name = "PutPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$put_policy_input(Policy = Policy, TagList = TagList)
  output <- .fms$put_policy_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$put_policy <- fms_put_policy

#' Creates an Firewall Manager protocols list
#'
#' @description
#' Creates an Firewall Manager protocols list.
#'
#' See [https://paws-r.github.io/docs/fms/put_protocols_list.html](https://paws-r.github.io/docs/fms/put_protocols_list.html) for full documentation.
#'
#' @param ProtocolsList &#91;required&#93; The details of the Firewall Manager protocols list to be created.
#' @param TagList The tags associated with the resource.
#'
#' @keywords internal
#'
#' @rdname fms_put_protocols_list
fms_put_protocols_list <- function(ProtocolsList, TagList = NULL) {
  op <- new_operation(
    name = "PutProtocolsList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$put_protocols_list_input(ProtocolsList = ProtocolsList, TagList = TagList)
  output <- .fms$put_protocols_list_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$put_protocols_list <- fms_put_protocols_list

#' Adds one or more tags to an Amazon Web Services resource
#'
#' @description
#' Adds one or more tags to an Amazon Web Services resource.
#'
#' See [https://paws-r.github.io/docs/fms/tag_resource.html](https://paws-r.github.io/docs/fms/tag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to return tags for. The
#' Firewall Manager resources that support tagging are policies,
#' applications lists, and protocols lists.
#' @param TagList &#91;required&#93; The tags to add to the resource.
#'
#' @keywords internal
#'
#' @rdname fms_tag_resource
fms_tag_resource <- function(ResourceArn, TagList) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$tag_resource_input(ResourceArn = ResourceArn, TagList = TagList)
  output <- .fms$tag_resource_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$tag_resource <- fms_tag_resource

#' Removes one or more tags from an Amazon Web Services resource
#'
#' @description
#' Removes one or more tags from an Amazon Web Services resource.
#'
#' See [https://paws-r.github.io/docs/fms/untag_resource.html](https://paws-r.github.io/docs/fms/untag_resource.html) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to return tags for. The
#' Firewall Manager resources that support tagging are policies,
#' applications lists, and protocols lists.
#' @param TagKeys &#91;required&#93; The keys of the tags to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname fms_untag_resource
fms_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .fms$untag_resource_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$untag_resource <- fms_untag_resource
