% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessanalyzer_operations.R
\name{accessanalyzer_create_access_preview}
\alias{accessanalyzer_create_access_preview}
\title{Creates an access preview that allows you to preview IAM Access Analyzer
findings for your resource before deploying resource permissions}
\usage{
accessanalyzer_create_access_preview(
  analyzerArn,
  clientToken = NULL,
  configurations
)
}
\arguments{
\item{analyzerArn}{[required] The \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources}{ARN of the account analyzer}
used to generate the access preview. You can only create an access
preview for analyzers with an \code{Account} type and \code{Active} status.}

\item{clientToken}{A client token.}

\item{configurations}{[required] Access control configuration for your resource that is used to generate
the access preview. The access preview includes findings for external
access allowed to the resource with the proposed access control
configuration. The configuration must contain exactly one element.}
}
\description{
Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions.

See \url{https://paws-r.github.io/docs/accessanalyzer/create_access_preview.html} for full documentation.
}
\keyword{internal}
