% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_resource_server}
\alias{cognitoidentityprovider_create_resource_server}
\title{Creates a new OAuth2}
\usage{
cognitoidentityprovider_create_resource_server(
  UserPoolId,
  Identifier,
  Name,
  Scopes = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool.}

\item{Identifier}{[required] A unique resource server identifier for the resource server. This could
be an HTTPS endpoint where the resource server is located, such as
\verb{https://my-weather-api.example.com}.}

\item{Name}{[required] A friendly name for the resource server.}

\item{Scopes}{A list of scopes. Each scope is a key-value map with the keys \code{name} and
\code{description}.}
}
\description{
Creates a new OAuth2.0 resource server and defines custom scopes within it.

See \url{https://paws-r.github.io/docs/cognitoidentityprovider/create_resource_server.html} for full documentation.
}
\keyword{internal}
