% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_login_profile}
\alias{iam_update_login_profile}
\title{Changes the password for the specified IAM user}
\usage{
iam_update_login_profile(
  UserName,
  Password = NULL,
  PasswordResetRequired = NULL
)
}
\arguments{
\item{UserName}{[required] The name of the user whose password you want to update.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Password}{The new password for the specified IAM user.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}

However, the format can be further restricted by the account
administrator by setting a password policy on the Amazon Web Services
account. For more information, see
\code{\link[=iam_update_account_password_policy]{update_account_password_policy}}.}

\item{PasswordResetRequired}{Allows this new password to be used only once by requiring the specified
IAM user to set a new password on next sign-in.}
}
\description{
Changes the password for the specified IAM user. You can use the CLI, the Amazon Web Services API, or the \strong{Users} page in the IAM console to change the password for any IAM user. Use \code{\link[=iam_change_password]{change_password}} to change your own password in the \strong{My Security Credentials} page in the Amazon Web Services Management Console.

See \url{https://paws-r.github.io/docs/iam/update_login_profile.html} for full documentation.
}
\keyword{internal}
