% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_aliases}
\alias{kms_list_aliases}
\title{Gets a list of aliases in the caller's Amazon Web Services account and
region}
\usage{
kms_list_aliases(KeyId = NULL, Limit = NULL, Marker = NULL)
}
\arguments{
\item{KeyId}{Lists only aliases that are associated with the specified KMS key. Enter
a KMS key in your Amazon Web Services account.

This parameter is optional. If you omit it,
\code{\link[=kms_list_aliases]{list_aliases}} returns all aliases in the account
and Region.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, KMS does not return more than the specified
number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
100, inclusive. If you do not include a value, it defaults to 50.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.}
}
\description{
Gets a list of aliases in the caller's Amazon Web Services account and region. For more information about aliases, see \code{\link[=kms_create_alias]{create_alias}}.

See \url{https://paws-r.github.io/docs/kms/list_aliases.html} for full documentation.
}
\keyword{internal}
