% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_put_key_policy}
\alias{kms_put_key_policy}
\title{Attaches a key policy to the specified KMS key}
\usage{
kms_put_key_policy(
  KeyId,
  PolicyName,
  Policy,
  BypassPolicyLockoutSafetyCheck = NULL
)
}
\arguments{
\item{KeyId}{[required] Sets the key policy on the specified KMS key.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{PolicyName}{[required] The name of the key policy. The only valid value is \code{default}.}

\item{Policy}{[required] The key policy to attach to the KMS key.

The key policy must meet the following criteria:
\itemize{
\item If you don't set \code{BypassPolicyLockoutSafetyCheck} to true, the key
policy must allow the principal that is making the
\code{\link[=kms_put_key_policy]{put_key_policy}} request to make a subsequent
\code{\link[=kms_put_key_policy]{put_key_policy}} request on the KMS key. This
reduces the risk that the KMS key becomes unmanageable. For more
information, refer to the scenario in the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam}{Default Key Policy}
section of the \emph{Key Management Service Developer Guide}.
\item Each statement in the key policy must contain one or more
principals. The principals in the key policy must exist and be
visible to KMS. When you create a new Amazon Web Services principal
(for example, an IAM user or role), you might need to enforce a
delay before including the new principal in a key policy because the
new principal might not be immediately visible to KMS. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency}{Changes that I make are not always immediately visible}
in the \emph{Amazon Web Services Identity and Access Management User
Guide}.
}

A key policy document can include only the following characters:
\itemize{
\item Printable ASCII characters from the space character (\code{U+0020})
through the end of the ASCII character range.
\item Printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF}).
\item The tab (\code{U+0009}), line feed (\verb{U+000A}), and carriage return
(\verb{U+000D}) special characters
}

For information about key policies, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html}{Key policies in KMS}
in the \emph{Key Management Service Developer Guide}. For help writing and
formatting a JSON policy document, see the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html}{IAM JSON Policy Reference}
in the \emph{Identity and Access Management User Guide} .}

\item{BypassPolicyLockoutSafetyCheck}{A flag to indicate whether to bypass the key policy lockout safety
check.

Setting this value to true increases the risk that the KMS key becomes
unmanageable. Do not set this value to true indiscriminately.

For more information, refer to the scenario in the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam}{Default Key Policy}
section in the \emph{Key Management Service Developer Guide}.

Use this parameter only when you intend to prevent the principal that is
making the request from making a subsequent
\code{\link[=kms_put_key_policy]{put_key_policy}} request on the KMS key.

The default value is false.}
}
\description{
Attaches a key policy to the specified KMS key.

See \url{https://paws-r.github.io/docs/kms/put_key_policy.html} for full documentation.
}
\keyword{internal}
