% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_update_custom_key_store}
\alias{kms_update_custom_key_store}
\title{Changes the properties of a custom key store}
\usage{
kms_update_custom_key_store(
  CustomKeyStoreId,
  NewCustomKeyStoreName = NULL,
  KeyStorePassword = NULL,
  CloudHsmClusterId = NULL
)
}
\arguments{
\item{CustomKeyStoreId}{[required] Identifies the custom key store that you want to update. Enter the ID of
the custom key store. To find the ID of a custom key store, use the
\code{\link[=kms_describe_custom_key_stores]{describe_custom_key_stores}}
operation.}

\item{NewCustomKeyStoreName}{Changes the friendly name of the custom key store to the value that you
specify. The custom key store name must be unique in the Amazon Web
Services account.}

\item{KeyStorePassword}{Enter the current password of the \code{kmsuser} crypto user (CU) in the
CloudHSM cluster that is associated with the custom key store.

This parameter tells KMS the current password of the \code{kmsuser} crypto
user (CU). It does not set or change the password of any users in the
CloudHSM cluster.}

\item{CloudHsmClusterId}{Associates the custom key store with a related CloudHSM cluster.

Enter the cluster ID of the cluster that you used to create the custom
key store or a cluster that shares a backup history and has the same
cluster certificate as the original cluster. You cannot use this
parameter to associate a custom key store with an unrelated cluster. In
addition, the replacement cluster must \href{https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore}{fulfill the requirements}
for a cluster associated with a custom key store. To view the cluster
certificate of a cluster, use the
\href{https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html}{DescribeClusters}
operation.}
}
\description{
Changes the properties of a custom key store. Use the \code{CustomKeyStoreId} parameter to identify the custom key store you want to edit. Use the remaining parameters to change the properties of the custom key store.

See \url{https://paws-r.github.io/docs/kms/update_custom_key_store.html} for full documentation.
}
\keyword{internal}
