% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_update_secret}
\alias{secretsmanager_update_secret}
\title{Modifies the details of a secret, including metadata and the secret
value}
\usage{
secretsmanager_update_secret(
  SecretId,
  ClientRequestToken = NULL,
  Description = NULL,
  KmsKeyId = NULL,
  SecretBinary = NULL,
  SecretString = NULL
)
}
\arguments{
\item{SecretId}{[required] The ARN or name of the secret.

For an ARN, we recommend that you specify a complete ARN rather than a
partial ARN. See \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen}{Finding a secret from a partial ARN}.}

\item{ClientRequestToken}{If you include \code{SecretString} or \code{SecretBinary}, then Secrets Manager
creates a new version for the secret, and this parameter specifies the
unique identifier for the new version.

If you use the Amazon Web Services CLI or one of the Amazon Web Services
SDKs to call this operation, then you can leave this parameter empty.
The CLI or SDK generates a random UUID for you and includes it as the
value for this parameter in the request. If you don't use the SDK and
instead generate a raw HTTP request to the Secrets Manager service
endpoint, then you must generate a \code{ClientRequestToken} yourself for the
new version and include the value in the request.

This value becomes the \code{VersionId} of the new version.}

\item{Description}{The description of the secret.}

\item{KmsKeyId}{The ARN, key ID, or alias of the KMS key that Secrets Manager uses to
encrypt new secret versions as well as any existing versions the staging
labels \code{AWSCURRENT}, \code{AWSPENDING}, or \code{AWSPREVIOUS}. For more
information about versions and staging labels, see \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/getting-started.html#term_version}{Concepts: Version}.

You can only use the Amazon Web Services managed key
\code{aws/secretsmanager} if you call this operation using credentials from
the same Amazon Web Services account that owns the secret. If the secret
is in a different account, then you must use a customer managed key and
provide the ARN of that KMS key in this field. The user making the call
must have permissions to both the secret and the KMS key in their
respective accounts.}

\item{SecretBinary}{The binary data to encrypt and store in the new version of the secret.
We recommend that you store your binary data in a file and then pass the
contents of the file as a parameter.

Either \code{SecretBinary} or \code{SecretString} must have a value, but not both.

You can't access this parameter in the Secrets Manager console.}

\item{SecretString}{The text data to encrypt and store in the new version of the secret. We
recommend you use a JSON structure of key/value pairs for your secret
value.

Either \code{SecretBinary} or \code{SecretString} must have a value, but not both.}
}
\description{
Modifies the details of a secret, including metadata and the secret value. To change the secret value, you can also use \code{\link[=secretsmanager_put_secret_value]{put_secret_value}}.

See \url{https://paws-r.github.io/docs/secretsmanager/update_secret.html} for full documentation.
}
\keyword{internal}
