% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_get_federation_token}
\alias{sts_get_federation_token}
\title{Returns a set of temporary security credentials (consisting of an access
key ID, a secret access key, and a security token) for a federated user}
\usage{
sts_get_federation_token(
  Name,
  Policy = NULL,
  PolicyArns = NULL,
  DurationSeconds = NULL,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the federated user. The name is used as an identifier for
the temporary security credentials (such as \code{Bob}). For example, you can
reference the federated user name in a resource-based policy, such as in
an Amazon S3 bucket policy.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{Policy}{An IAM policy in JSON format that you want to use as an inline session
policy.

You must pass an inline or managed \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{session policy}
to this operation. You can pass a single JSON policy document to use as
an inline session policy. You can also specify up to 10 managed policies
to use as managed session policies.

This parameter is optional. However, if you do not pass any session
policies, then the resulting federated user session has no permissions.

When you pass session policies, the session permissions are the
intersection of the IAM user policies and the session policies that you
pass. This gives you a way to further restrict the permissions for a
federated user. You cannot use session policies to grant more
permissions than those that are defined in the permissions policy of the
IAM user. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.

The resulting credentials can be used to access a resource that has a
resource-based policy. If that policy specifically references the
federated user session in the \code{Principal} element of the policy, the
session has the permissions allowed by the policy. These permissions are
granted in addition to the permissions that are granted by the session
policies.

The plaintext that you use for both inline and managed session policies
can't exceed 2,048 characters. The JSON policy characters can be any
ASCII character from the space character to the end of the valid
character list (\code{U+0020} through \verb{U+00FF}). It can also include the tab
(\code{U+0009}), linefeed (\verb{U+000A}), and carriage return (\verb{U+000D}) characters.

An Amazon Web Services conversion compresses the passed session policies
and session tags into a packed binary format that has a separate limit.
Your request can fail for this limit even if your plaintext meets the
other requirements. The \code{PackedPolicySize} response element indicates by
percentage how close the policies and tags for your request are to the
upper size limit.}

\item{PolicyArns}{The Amazon Resource Names (ARNs) of the IAM managed policies that you
want to use as a managed session policy. The policies must exist in the
same account as the IAM user that is requesting federated access.

You must pass an inline or managed \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{session policy}
to this operation. You can pass a single JSON policy document to use as
an inline session policy. You can also specify up to 10 managed policies
to use as managed session policies. The plaintext that you use for both
inline and managed session policies can't exceed 2,048 characters. You
can provide up to 10 managed policy ARNs. For more information about
ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces}
in the Amazon Web Services General Reference.

This parameter is optional. However, if you do not pass any session
policies, then the resulting federated user session has no permissions.

When you pass session policies, the session permissions are the
intersection of the IAM user policies and the session policies that you
pass. This gives you a way to further restrict the permissions for a
federated user. You cannot use session policies to grant more
permissions than those that are defined in the permissions policy of the
IAM user. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.

The resulting credentials can be used to access a resource that has a
resource-based policy. If that policy specifically references the
federated user session in the \code{Principal} element of the policy, the
session has the permissions allowed by the policy. These permissions are
granted in addition to the permissions that are granted by the session
policies.

An Amazon Web Services conversion compresses the passed session policies
and session tags into a packed binary format that has a separate limit.
Your request can fail for this limit even if your plaintext meets the
other requirements. The \code{PackedPolicySize} response element indicates by
percentage how close the policies and tags for your request are to the
upper size limit.}

\item{DurationSeconds}{The duration, in seconds, that the session should last. Acceptable
durations for federation sessions range from 900 seconds (15 minutes) to
129,600 seconds (36 hours), with 43,200 seconds (12 hours) as the
default. Sessions obtained using Amazon Web Services account root user
credentials are restricted to a maximum of 3,600 seconds (one hour). If
the specified duration is longer than one hour, the session obtained by
using root user credentials defaults to one hour.}

\item{Tags}{A list of session tags. Each session tag consists of a key name and an
associated value. For more information about session tags, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html}{Passing Session Tags in STS}
in the \emph{IAM User Guide}.

This parameter is optional. You can pass up to 50 session tags. The
plaintext session tag keys can’t exceed 128 characters and the values
can’t exceed 256 characters. For these and additional limits, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length}{IAM and STS Character Limits}
in the \emph{IAM User Guide}.

An Amazon Web Services conversion compresses the passed session policies
and session tags into a packed binary format that has a separate limit.
Your request can fail for this limit even if your plaintext meets the
other requirements. The \code{PackedPolicySize} response element indicates by
percentage how close the policies and tags for your request are to the
upper size limit.

You can pass a session tag with the same key as a tag that is already
attached to the user you are federating. When you do, session tags
override a user tag with the same key.

Tag key–value pairs are not case sensitive, but case is preserved. This
means that you cannot have separate \code{Department} and \code{department} tag
keys. Assume that the role has the \code{Department}=\code{Marketing} tag and you
pass the \code{department}=\code{engineering} session tag. \code{Department} and
\code{department} are not saved as separate tags, and the session tag passed
in the request takes precedence over the role tag.}
}
\description{
Returns a set of temporary security credentials (consisting of an access key ID, a secret access key, and a security token) for a federated user. A typical use is in a proxy application that gets temporary security credentials on behalf of distributed applications inside a corporate network. You must call the \code{\link[=sts_get_federation_token]{get_federation_token}} operation using the long-term security credentials of an IAM user. As a result, this call is appropriate in contexts where those credentials can be safely stored, usually in a server-based application. For a comparison of \code{\link[=sts_get_federation_token]{get_federation_token}} with the other API operations that produce temporary credentials, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials} and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison}{Comparing the Amazon Web Services STS API operations} in the \emph{IAM User Guide}.

See \url{https://paws-r.github.io/docs/sts/get_federation_token.html} for full documentation.
}
\keyword{internal}
