% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_disassociate_web_acl}
\alias{wafv2_disassociate_web_acl}
\title{Disassociates the specified regional application resource from any
existing web ACL association}
\usage{
wafv2_disassociate_web_acl(ResourceArn)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource to disassociate from the
web ACL.

The ARN must be in one of the following formats:
\itemize{
\item For an Application Load Balancer:
\code{arn:aws:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id }
\item For an Amazon API Gateway REST API:
\verb{arn:aws:apigateway:region::/restapis/api-id/stages/stage-name }
\item For an AppSync GraphQL API:
\code{arn:aws:appsync:region:account-id:apis/GraphQLApiId }
\item For an Amazon Cognito user pool:
\code{arn:aws:cognito-idp:region:account-id:userpool/user-pool-id }
}}
}
\description{
Disassociates the specified regional application resource from any existing web ACL association. A resource can have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API, or an Amazon Cognito user pool.

See \url{https://paws-r.github.io/docs/wafv2/disassociate_web_acl.html} for full documentation.
}
\keyword{internal}
