% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_get_rate_based_statement_managed_keys}
\alias{wafv2_get_rate_based_statement_managed_keys}
\title{Retrieves the keys that are currently blocked by a rate-based rule
instance}
\usage{
wafv2_get_rate_based_statement_managed_keys(
  Scope,
  WebACLName,
  WebACLId,
  RuleGroupRuleName = NULL,
  RuleName
)
}
\arguments{
\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
or an Amazon Cognito user pool.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{WebACLName}{[required] The name of the web ACL. You cannot change the name of a web ACL after
you create it.}

\item{WebACLId}{[required] The unique identifier for the web ACL. This ID is returned in the
responses to create and list commands. You provide it to operations like
update and delete.}

\item{RuleGroupRuleName}{The name of the rule group reference statement in your web ACL. This is
required only when you have the rate-based rule nested inside a rule
group.}

\item{RuleName}{[required] The name of the rate-based rule to get the keys for. If you have the
rule defined inside a rule group that you're using in your web ACL, also
provide the name of the rule group reference statement in the request
parameter \code{RuleGroupRuleName}.}
}
\description{
Retrieves the keys that are currently blocked by a rate-based rule instance. The maximum number of managed keys that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.

See \url{https://paws-r.github.io/docs/wafv2/get_rate_based_statement_managed_keys.html} for full documentation.
}
\keyword{internal}
