% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_generate_data_key_pair}
\alias{kms_generate_data_key_pair}
\title{Returns a unique asymmetric data key pair for use outside of KMS}
\usage{
kms_generate_data_key_pair(
  EncryptionContext = NULL,
  KeyId,
  KeyPairSpec,
  GrantTokens = NULL,
  Recipient = NULL,
  DryRun = NULL
)
}
\arguments{
\item{EncryptionContext}{Specifies the encryption context that will be used when encrypting the
private key in the data key pair.

Do not include confidential or sensitive information in this field. This
field may be displayed in plaintext in CloudTrail logs and other output.

An \emph{encryption context} is a collection of non-secret key-value pairs
that represent additional authenticated data. When you use an encryption
context to encrypt data, you must specify the same (an exact
case-sensitive match) encryption context to decrypt the data. An
encryption context is supported only on operations with symmetric
encryption KMS keys. On operations with symmetric encryption KMS keys,
an encryption context is optional, but it is strongly recommended.

For more information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context}{Encryption context}
in the \emph{Key Management Service Developer Guide}.}

\item{KeyId}{[required] Specifies the symmetric encryption KMS key that encrypts the private key
in the data key pair. You cannot specify an asymmetric KMS key or a KMS
key in a custom key store. To get the type and origin of your KMS key,
use the \code{\link[=kms_describe_key]{describe_key}} operation.

To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN.
When using an alias name, prefix it with \code{"alias/"}. To specify a KMS
key in a different Amazon Web Services account, you must use the key ARN
or alias ARN.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
\item Alias name: \code{alias/ExampleAlias}
\item Alias ARN: \code{arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}. To
get the alias name and alias ARN, use
\code{\link[=kms_list_aliases]{list_aliases}}.}

\item{KeyPairSpec}{[required] Determines the type of data key pair that is generated.

The KMS rule that restricts the use of asymmetric RSA and SM2 KMS keys
to encrypt and decrypt or to sign and verify (but not both), and the
rule that permits you to use ECC KMS keys only to sign and verify, are
not effective on data key pairs, which are used outside of KMS. The SM2
key spec is only available in China Regions.}

\item{GrantTokens}{A list of grant tokens.

Use a grant token when your permission to call this operation comes from
a new grant that has not yet achieved \emph{eventual consistency}. For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token}{Grant token}
and \href{https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token}{Using a grant token}
in the \emph{Key Management Service Developer Guide}.}

\item{Recipient}{A signed \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/#term-attestdoc}{attestation document}
from an Amazon Web Services Nitro enclave and the encryption algorithm
to use with the enclave's public key. The only valid encryption
algorithm is \code{RSAES_OAEP_SHA_256}.

This parameter only supports attestation documents for Amazon Web
Services Nitro Enclaves. To include this parameter, use the \href{https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk}{Amazon Web Services Nitro Enclaves SDK}
or any Amazon Web Services SDK.

When you use this parameter, instead of returning a plaintext copy of
the private data key, KMS encrypts the plaintext private data key under
the public key in the attestation document, and returns the resulting
ciphertext in the \code{CiphertextForRecipient} field in the response. This
ciphertext can be decrypted only with the private key in the enclave.
The \code{CiphertextBlob} field in the response contains a copy of the
private data key encrypted under the KMS key specified by the \code{KeyId}
parameter. The \code{PrivateKeyPlaintext} field in the response is null or
empty.

For information about the interaction between KMS and Amazon Web
Services Nitro Enclaves, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html}{How Amazon Web Services Nitro Enclaves uses KMS}
in the \emph{Key Management Service Developer Guide}.}

\item{DryRun}{Checks if your request will succeed. \code{DryRun} is an optional parameter.

To learn more about how to use this parameter, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html}{Testing your KMS API calls}
in the \emph{Key Management Service Developer Guide}.}
}
\description{
Returns a unique asymmetric data key pair for use outside of KMS. This operation returns a plaintext public key, a plaintext private key, and a copy of the private key that is encrypted under the symmetric encryption KMS key you specify. You can use the data key pair to perform asymmetric cryptography and implement digital signatures outside of KMS. The bytes in the keys are random; they are not related to the caller or to the KMS key that is used to encrypt the private key.

See \url{https://www.paws-r-sdk.com/docs/kms_generate_data_key_pair/} for full documentation.
}
\keyword{internal}
