% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_untag_certificate_authority}
\alias{acmpca_untag_certificate_authority}
\title{Remove one or more tags from your private CA}
\usage{
acmpca_untag_certificate_authority(CertificateAuthorityArn, Tags)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
\code{\link[=acmpca_create_certificate_authority]{create_certificate_authority}}.
This must be of the form:

\code{arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 }}

\item{Tags}{[required] List of tags to be removed from the CA.}
}
\description{
Remove one or more tags from your private CA. A tag consists of a key-value pair. If you do not specify the value portion of the tag when calling this action, the tag will be removed regardless of value. If you specify a value, the tag is removed only if it is associated with the specified value. To add tags to a private CA, use the \code{\link[=acmpca_tag_certificate_authority]{tag_certificate_authority}}. Call the \code{\link[=acmpca_list_tags]{list_tags}} action to see what tags are associated with your CA.

See \url{https://www.paws-r-sdk.com/docs/acmpca_untag_certificate_authority/} for full documentation.
}
\keyword{internal}
