% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_sign_up}
\alias{cognitoidentityprovider_sign_up}
\title{Registers the user in the specified user pool and creates a user name,
password, and user attributes}
\usage{
cognitoidentityprovider_sign_up(
  ClientId,
  SecretHash = NULL,
  Username,
  Password,
  UserAttributes = NULL,
  ValidationData = NULL,
  AnalyticsMetadata = NULL,
  UserContextData = NULL,
  ClientMetadata = NULL
)
}
\arguments{
\item{ClientId}{[required] The ID of the client associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{Username}{[required] The username of the user that you want to sign up. The value of this
parameter is typically a username, but can be any alias attribute in
your user pool.}

\item{Password}{[required] The password of the user you want to register.}

\item{UserAttributes}{An array of name-value pairs representing user attributes.

For custom attributes, you must prepend the \verb{custom:} prefix to the
attribute name.}

\item{ValidationData}{Temporary user attributes that contribute to the outcomes of your pre
sign-up Lambda trigger. This set of key-value pairs are for custom
validation of information that you collect from your users but don't
need to retain.

Your Lambda function can analyze this additional data and act on it.
Your function might perform external API operations like logging user
attributes and validation data to Amazon CloudWatch Logs. Validation
data might also affect the response that your function returns to Amazon
Cognito, like automatically confirming the user if they sign up from
within your network.

For more information about the pre sign-up Lambda trigger, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html}{Pre sign-up Lambda trigger}.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata that contributes to your metrics
for \code{\link[=cognitoidentityprovider_sign_up]{sign_up}} calls.}

\item{UserContextData}{Contextual data about your user session, such as the device fingerprint,
IP address, or location. Amazon Cognito advanced security evaluates the
risk of an authentication event based on the context that your app
generates and passes to Amazon Cognito when it makes API requests.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning Lambda functions to user pool
triggers. When you use the SignUp API action, Amazon Cognito invokes any
functions that are assigned to the following triggers: \emph{pre sign-up},
\emph{custom message}, and \emph{post confirmation}. When Amazon Cognito invokes
any of these functions, it passes a JSON payload, which the function
receives as input. This payload contains a \code{clientMetadata} attribute,
which provides the data that you assigned to the ClientMetadata
parameter in your SignUp request. In your function code in Lambda, you
can process the \code{clientMetadata} value to enhance your workflow for your
specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-working-with-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the ClientMetadata parameter, remember that Amazon Cognito
won't do the following:
\itemize{
\item Store the ClientMetadata value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the ClientMetadata parameter serves no purpose.
\item Validate the ClientMetadata value.
\item Encrypt the ClientMetadata value. Don't use Amazon Cognito to
provide sensitive information.
}}
}
\description{
Registers the user in the specified user pool and creates a user name, password, and user attributes.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_sign_up/} for full documentation.
}
\keyword{internal}
