% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_backup_jobs}
\alias{backup_list_backup_jobs}
\title{Returns a list of existing backup jobs for an authenticated account}
\usage{
backup_list_backup_jobs(NextToken, MaxResults, ByResourceArn, ByState,
  ByBackupVaultName, ByCreatedBefore, ByCreatedAfter, ByResourceType,
  ByAccountId)
}
\arguments{
\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{maxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}

\item{ByResourceArn}{Returns only backup jobs that match the specified resource Amazon
Resource Name (ARN).}

\item{ByState}{Returns only backup jobs that are in the specified state.}

\item{ByBackupVaultName}{Returns only backup jobs that will be stored in the specified backup
vault. Backup vaults are identified by names that are unique to the
account used to create them and the AWS Region where they are created.
They consist of lowercase letters, numbers, and hyphens.}

\item{ByCreatedBefore}{Returns only backup jobs that were created before the specified date.}

\item{ByCreatedAfter}{Returns only backup jobs that were created after the specified date.}

\item{ByResourceType}{Returns only backup jobs for the specified resources:
\itemize{
\item \code{DynamoDB} for Amazon DynamoDB
\item \code{EBS} for Amazon Elastic Block Store
\item \code{EC2} for Amazon Elastic Compute Cloud
\item \code{EFS} for Amazon Elastic File System
\item \code{RDS} for Amazon Relational Database Service
\item \verb{Storage Gateway} for AWS Storage Gateway
}}

\item{ByAccountId}{The account ID to list the jobs from. Returns only backup jobs
associated with the specified account ID.}
}
\description{
Returns a list of existing backup jobs for an authenticated account.
}
\section{Request syntax}{
\preformatted{svc$list_backup_jobs(
  NextToken = "string",
  MaxResults = 123,
  ByResourceArn = "string",
  ByState = "CREATED"|"PENDING"|"RUNNING"|"ABORTING"|"ABORTED"|"COMPLETED"|"FAILED"|"EXPIRED",
  ByBackupVaultName = "string",
  ByCreatedBefore = as.POSIXct(
    "2015-01-01"
  ),
  ByCreatedAfter = as.POSIXct(
    "2015-01-01"
  ),
  ByResourceType = "string",
  ByAccountId = "string"
)
}
}

\keyword{internal}
