% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_file_system}
\alias{fsx_create_file_system}
\title{Creates a new, empty Amazon FSx file system}
\usage{
fsx_create_file_system(ClientRequestToken, FileSystemType,
  StorageCapacity, StorageType, SubnetIds, SecurityGroupIds, Tags,
  KmsKeyId, WindowsConfiguration, LustreConfiguration)
}
\arguments{
\item{ClientRequestToken}{A string of up to 64 ASCII characters that Amazon FSx uses to ensure
idempotent creation. This string is automatically filled on your behalf
when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.}

\item{FileSystemType}{[required] The type of Amazon FSx file system to create, either \code{WINDOWS} or
\code{LUSTRE}.}

\item{StorageCapacity}{[required] Sets the storage capacity of the file system that you're creating.

For Lustre file systems:
\itemize{
\item For \code{SCRATCH_2} and \verb{PERSISTENT_1 SSD} deployment types, valid
values are 1200 GiB, 2400 GiB, and increments of 2400 GiB.
\item For \verb{PERSISTENT HDD} file systems, valid values are increments of
6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for
40 MB/s/TiB file systems.
\item For \code{SCRATCH_1} deployment type, valid values are 1200 GiB, 2400
GiB, and increments of 3600 GiB.
}

For Windows file systems:
\itemize{
\item If \code{StorageType=SSD}, valid values are 32 GiB - 65,536 GiB (64 TiB).
\item If \code{StorageType=HDD}, valid values are 2000 GiB - 65,536 GiB (64
TiB).
}}

\item{StorageType}{Sets the storage type for the file system you're creating. Valid values
are \code{SSD} and \code{HDD}.
\itemize{
\item Set to \code{SSD} to use solid state drive storage. SSD is supported on
all Windows and Lustre deployment types.
\item Set to \code{HDD} to use hard disk drive storage. HDD is supported on
\code{SINGLE_AZ_2} and \code{MULTI_AZ_1} Windows file system deployment types,
and on \code{PERSISTENT} Lustre file system deployment types.
}

Default value is \code{SSD}. For more information, see \href{https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options}{Storage Type Options}
in the \emph{Amazon FSx for Windows User Guide} and \href{https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options}{Multiple Storage Options}
in the \emph{Amazon FSx for Lustre User Guide}.}

\item{SubnetIds}{[required] Specifies the IDs of the subnets that the file system will be accessible
from. For Windows \code{MULTI_AZ_1} file system deployment types, provide
exactly two subnet IDs, one for the preferred file server and one for
the standby file server. You specify one of these subnets as the
preferred subnet using the \verb{WindowsConfiguration &gt; PreferredSubnetID}
property.

For Windows \code{SINGLE_AZ_1} and \code{SINGLE_AZ_2} file system deployment types
and Lustre file systems, provide exactly one subnet ID. The file server
is launched in that subnet's Availability Zone.}

\item{SecurityGroupIds}{A list of IDs specifying the security groups to apply to all network
interfaces created for file system access. This list isn't returned in
later requests to describe the file system.}

\item{Tags}{The tags to apply to the file system being created. The key value of the
\code{Name} tag appears in the console as the file system name.}

\item{KmsKeyId}{}

\item{WindowsConfiguration}{The Microsoft Windows configuration for the file system being created.}

\item{LustreConfiguration}{}
}
\description{
Creates a new, empty Amazon FSx file system.

If a file system with the specified client request token exists and the
parameters match, \code{CreateFileSystem} returns the description of the
existing file system. If a file system specified client request token
exists and the parameters don't match, this call returns
\code{IncompatibleParameterError}. If a file system with the specified client
request token doesn't exist, \code{CreateFileSystem} does the following:
\itemize{
\item Creates a new, empty Amazon FSx file system with an assigned ID, and
an initial lifecycle state of \code{CREATING}.
\item Returns the description of the file system.
}

This operation requires a client request token in the request that
Amazon FSx uses to ensure idempotent creation. This means that calling
the operation multiple times with the same client request token has no
effect. By using the idempotent operation, you can retry a
\code{CreateFileSystem} operation without the risk of creating an extra file
system. This approach can be useful when an initial call fails in a way
that makes it unclear whether a file system was created. Examples are if
a transport level timeout occurred, or your connection was reset. If you
use the same client request token and the initial call created a file
system, the client receives success as long as the parameters are the
same.

The \code{CreateFileSystem} call returns while the file system's lifecycle
state is still \code{CREATING}. You can check the file-system creation status
by calling the DescribeFileSystems operation, which returns the file
system state along with other information.
}
\section{Request syntax}{
\preformatted{svc$create_file_system(
  ClientRequestToken = "string",
  FileSystemType = "WINDOWS"|"LUSTRE",
  StorageCapacity = 123,
  StorageType = "SSD"|"HDD",
  SubnetIds = list(
    "string"
  ),
  SecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  WindowsConfiguration = list(
    ActiveDirectoryId = "string",
    SelfManagedActiveDirectoryConfiguration = list(
      DomainName = "string",
      OrganizationalUnitDistinguishedName = "string",
      FileSystemAdministratorsGroup = "string",
      UserName = "string",
      Password = "string",
      DnsIps = list(
        "string"
      )
    ),
    DeploymentType = "MULTI_AZ_1"|"SINGLE_AZ_1"|"SINGLE_AZ_2",
    PreferredSubnetId = "string",
    ThroughputCapacity = 123,
    WeeklyMaintenanceStartTime = "string",
    DailyAutomaticBackupStartTime = "string",
    AutomaticBackupRetentionDays = 123,
    CopyTagsToBackups = TRUE|FALSE,
    Aliases = list(
      "string"
    )
  ),
  LustreConfiguration = list(
    WeeklyMaintenanceStartTime = "string",
    ImportPath = "string",
    ExportPath = "string",
    ImportedFileChunkSize = 123,
    DeploymentType = "SCRATCH_1"|"SCRATCH_2"|"PERSISTENT_1",
    AutoImportPolicy = "NONE"|"NEW"|"NEW_CHANGED",
    PerUnitStorageThroughput = 123,
    DailyAutomaticBackupStartTime = "string",
    AutomaticBackupRetentionDays = 123,
    CopyTagsToBackups = TRUE|FALSE,
    DriveCacheType = "NONE"|"READ"
  )
)
}
}

\examples{
\dontrun{
# This operation creates a new Amazon FSx for Windows File Server file
# system.
svc$create_file_system(
  ClientRequestToken = "a8ca07e4-61ec-4399-99f4-19853801bcd5",
  FileSystemType = "WINDOWS",
  KmsKeyId = "arn:aws:kms:us-east-1:012345678912:key/1111abcd-2222-3333-4444-55556666eeff",
  SecurityGroupIds = list(
    "sg-edcd9784"
  ),
  StorageCapacity = 3200L,
  StorageType = "HDD",
  SubnetIds = list(
    "subnet-1234abcd"
  ),
  Tags = list(
    list(
      Key = "Name",
      Value = "MyFileSystem"
    )
  ),
  WindowsConfiguration = list(
    ActiveDirectoryId = "d-1234abcd12",
    Aliases = list(
      "accounting.corp.example.com"
    ),
    AutomaticBackupRetentionDays = 30L,
    DailyAutomaticBackupStartTime = "05:00",
    ThroughputCapacity = 32L,
    WeeklyMaintenanceStartTime = "1:05:00"
  )
)
}

}
\keyword{internal}
